#
# TABLE STRUCTURE FOR: add_amt
#

DROP TABLE IF EXISTS `add_amt`;

CREATE TABLE `add_amt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `amt` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `utr` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `note` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `addon` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (1, 'ADMIN', '100', '124346', '', '1', '2021-07-03 17:19:46');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (2, 'ADMIN', '10', '6434', '', '2', '2021-07-03 17:50:08');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (3, 'T478838', '10', '118513598442', '', '1', '2021-07-04 13:54:52');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (4, 'T686636', '10', '652389566', '', '2', '2021-07-04 14:04:59');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (5, '1234567891', '100', '253388', '', '1', '2021-07-05 12:44:51');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (6, '6207475162', '360', '5467978', '', '1', '2021-07-05 17:11:22');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (7, 'ADMIN', '1000', '35468', '', '1', '2021-07-05 19:50:29');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (8, 'T974372', '37', '118799342554', '', '1', '2021-07-06 09:18:24');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (9, 'T201269', '100', '119013559902', '', '1', '2021-07-09 13:53:36');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (10, '9798067920', '375', '9798067920', '', '2', '2021-07-12 10:27:52');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (11, '9798067920', '375', '119312956163', '', '1', '2021-07-12 12:09:06');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (12, '9798067920', '45', '119414435822', '', '1', '2021-07-13 14:44:28');
INSERT INTO `add_amt` (`id`, `uid`, `amt`, `utr`, `note`, `status`, `addon`) VALUES (13, '9798067920', '45', '119414435822', '', '2', '2021-07-13 14:50:08');


#
# TABLE STRUCTURE FOR: applied_coupon
#

DROP TABLE IF EXISTS `applied_coupon`;

CREATE TABLE `applied_coupon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coupon_id` varchar(999) NOT NULL,
  `user_id` varchar(999) NOT NULL,
  `payment_id` varchar(999) NOT NULL,
  `addon` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: applied_delivery_address
#

DROP TABLE IF EXISTS `applied_delivery_address`;

CREATE TABLE `applied_delivery_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delivery_address_id` int(11) NOT NULL,
  `user_id` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pin_code` int(11) NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `payment_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (1, 1, '2', 'Kush Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842001, 'AT Tower Juran Chhapra Muzaffarpur', '2021-07-16 19:04:17', '2021-07-16 19:04:17', 1, 1626442457);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (2, 2, '3', 'Ram ji', '9939195269', 'Bihar', 'MUZAFFARPUR', 842001, 'Vill post karaundi soraon allahabad', '2021-07-17 12:04:46', '2021-07-17 12:04:46', 1, 1626503686);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (3, 3, '1', 'TryIt India', '8084940179', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-07-17 16:06:10', '2021-07-17 16:06:10', 1, 1626518170);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (4, 4, '5', 'Manish kr', '9711002470', 'Bihar', 'MUZAFFARPUR', 842001, '85 B, LALA KI SARAI, TELIYARGANJ', '2021-07-17 16:38:23', '2021-07-17 16:38:23', 1, 1626520103);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (5, 2, '3', 'Ram ji', '9939195269', 'Bihar', 'MUZAFFARPUR', 842002, 'Vill post karaundi soraon allahabad', '2021-07-19 11:04:41', '2021-07-19 11:04:41', 1, 1626672881);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (6, 1, '2', 'Kush Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842001, 'AT Tower Juran Chhapra Muzaffarpur', '2021-07-19 16:47:14', '2021-07-19 16:47:14', 1, 1626693434);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (7, 1, '2', 'Kush Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842001, 'AT Tower Juran Chhapra Muzaffarpur', '2021-07-19 16:55:19', '2021-07-19 16:55:19', 1, 1626693919);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (8, 16, '83', 'Anand mohan', '9097027327', 'Bihar', 'MUZAFFARPUR', 842001, ' Ahiyapur Dharmkanta Hanuman mandir road near brahmsthan chakmohamad Muzaffarpur\n', '2021-08-03 14:25:07', '2021-08-03 14:25:07', 1, 1627980907);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (9, 15, '95', 'Lov Prakash', '9835153380', 'Bihar', 'Patna', 842002, 'Muzaffarpur', '2021-08-03 14:44:00', '2021-08-03 14:44:00', 1, 1627982040);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (10, 15, '95', 'Lov Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-08-03 14:52:59', '2021-08-03 14:52:59', 1, 1627982579);
INSERT INTO `applied_delivery_address` (`id`, `delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`, `payment_id`) VALUES (11, 17, '10', 'Vimal Kumar', '7992259617', 'Bihar', 'MUZAFFARPUR', 842002, 'Ram saikil niwas\nJanglimai colony, mithanpura\nMuzaffarpur', '2021-08-03 20:03:15', '2021-08-03 20:03:15', 1, 1628001195);


#
# TABLE STRUCTURE FOR: applied_shipping_cost
#

DROP TABLE IF EXISTS `applied_shipping_cost`;

CREATE TABLE `applied_shipping_cost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipping_cost` float NOT NULL,
  `payment_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `addon` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `applied_shipping_cost` (`id`, `shipping_cost`, `payment_id`, `user_id`, `addon`) VALUES (1, '50', 1626442457, 2, '2021-07-16 19:04:17');
INSERT INTO `applied_shipping_cost` (`id`, `shipping_cost`, `payment_id`, `user_id`, `addon`) VALUES (2, '50', 1626503686, 3, '2021-07-17 12:04:46');
INSERT INTO `applied_shipping_cost` (`id`, `shipping_cost`, `payment_id`, `user_id`, `addon`) VALUES (3, '50', 1626518170, 1, '2021-07-17 16:06:10');
INSERT INTO `applied_shipping_cost` (`id`, `shipping_cost`, `payment_id`, `user_id`, `addon`) VALUES (4, '50', 1627980907, 83, '2021-08-03 14:25:07');


#
# TABLE STRUCTURE FOR: banner
#

DROP TABLE IF EXISTS `banner`;

CREATE TABLE `banner` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photo` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `banner` (`id`, `photo`, `status`) VALUES (1, 'IMG-20210629-WA0009.jpg', 0);


#
# TABLE STRUCTURE FOR: closing
#

DROP TABLE IF EXISTS `closing`;

CREATE TABLE `closing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `total` float DEFAULT NULL,
  `amt` float DEFAULT NULL,
  `tds` float DEFAULT NULL,
  `pr` int(11) DEFAULT NULL,
  `admin` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `note` varchar(999) DEFAULT NULL,
  `txnid` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: complant
#

DROP TABLE IF EXISTS `complant`;

CREATE TABLE `complant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `q1` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `qdate` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `a1` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `adate` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `admins` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (1, 'ADMIN', 'test one', '2021-05-24 12:46:50', 'done', '2021-05-24 13:00:31', '');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (2, 'T450008', 'Hallo', '2021-05-24 15:01:56', 'Hallo', '2021-05-24 15:02:21', '');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (3, 'T147478', 'Test One', '2021-05-24 15:41:56', '', '', 'ADMIN');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (4, 'T147478', 'ok SIr', '2021-05-24 15:45:34', '', '', 'T147478');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (5, 'T450008', 'Hallo', '2021-05-24 15:53:23', '', '', 'ADMIN');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (6, 'T324073', 'Now, I have entered KYC\r\nApprove it as soon as possible\r\nThank You', '2021-06-01 20:31:03', '', '', 'T324073');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (7, 'T478838', 'Hellow sir', '2021-06-08 12:51:49', '', '', 'T478838');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (8, 'T478838', 'Hallo', '2021-06-08 12:52:45', '', '', 'ADMIN');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (9, '8102811241', 'I unbale to recharge', '2021-07-25 13:50:07', '', '', '8102811241');
INSERT INTO `complant` (`id`, `uid`, `q1`, `qdate`, `a1`, `adate`, `admins`) VALUES (10, '9939090087', 'How I indore a merchant  ?  Please guide me.', '2021-08-01 07:19:11', '', '', '9939090087');


#
# TABLE STRUCTURE FOR: customer_invoice
#

DROP TABLE IF EXISTS `customer_invoice`;

CREATE TABLE `customer_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `pv` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`) VALUES (1, '1', '7004983144', '99165741', '664', '134', '', '5', '10', '50', '1541', '1', '2021-08-07 06:36:43', '0');
INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`) VALUES (2, '1', '7004983144', '99165741', '666', '134', '', '5', '10', '50', '1544', '1', '2021-08-07 06:36:43', '0');
INSERT INTO `customer_invoice` (`id`, `user_id`, `customer_id`, `bill_no`, `pid`, `size_id`, `color_id`, `mrp`, `qty`, `total`, `tps`, `status`, `addon`, `pv`) VALUES (3, '1', '9835153380', '49024135', '667', '152', '1', '62', '1', '62', '1548', '1', '2021-08-10 15:57:04', '9.3');


#
# TABLE STRUCTURE FOR: customer_invoice1
#

DROP TABLE IF EXISTS `customer_invoice1`;

CREATE TABLE `customer_invoice1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: customer_invoice_list
#

DROP TABLE IF EXISTS `customer_invoice_list`;

CREATE TABLE `customer_invoice_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `tamt1` varchar(999) NOT NULL,
  `dis` varchar(999) NOT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (1, '1', '7004983144', '99165741', '100', '00', '100', '2021-08-07 06:36:43', '1');
INSERT INTO `customer_invoice_list` (`id`, `user_id`, `customer_id`, `bill_no`, `tamt1`, `dis`, `total`, `addon`, `status`) VALUES (2, '1', '9835153380', '49024135', '62', '0', '62', '2021-08-10 15:57:04', '1');


#
# TABLE STRUCTURE FOR: customer_invoice_list1
#

DROP TABLE IF EXISTS `customer_invoice_list1`;

CREATE TABLE `customer_invoice_list1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `tamt1` varchar(999) NOT NULL,
  `dis` varchar(999) NOT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: customer_payment
#

DROP TABLE IF EXISTS `customer_payment`;

CREATE TABLE `customer_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `customer_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `payid` varchar(999) DEFAULT NULL,
  `pre_amt` varchar(999) DEFAULT NULL,
  `paid` varchar(999) DEFAULT NULL,
  `dues` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (1, '1', '7004983144', '99165741', '492967', '100', '0100', '0', '2021-08-07 06:36:43', '1');
INSERT INTO `customer_payment` (`id`, `user_id`, `customer_id`, `bill_no`, `payid`, `pre_amt`, `paid`, `dues`, `addon`, `status`) VALUES (2, '1', '9835153380', '49024135', '727022', '62', '62', '0', '2021-08-10 15:57:04', '1');


#
# TABLE STRUCTURE FOR: cut_pv
#

DROP TABLE IF EXISTS `cut_pv`;

CREATE TABLE `cut_pv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) DEFAULT NULL,
  `pv` int(11) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: details
#

DROP TABLE IF EXISTS `details`;

CREATE TABLE `details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sponsor` varchar(111) DEFAULT NULL,
  `upid` varchar(111) DEFAULT NULL,
  `uid` varchar(111) DEFAULT NULL,
  `mid` varchar(99) NOT NULL,
  `branch` varchar(99) NOT NULL,
  `staff` varchar(99) NOT NULL,
  `pass` varchar(111) DEFAULT NULL,
  `pass1` varchar(999) NOT NULL,
  `pass2` varchar(999) NOT NULL,
  `name` varchar(111) DEFAULT NULL,
  `fname` varchar(111) DEFAULT NULL,
  `mob` varchar(111) DEFAULT NULL,
  `email` varchar(111) DEFAULT NULL,
  `dob` varchar(111) DEFAULT NULL,
  `address` varchar(111) DEFAULT NULL,
  `aadhar` varchar(111) DEFAULT NULL,
  `pan` varchar(111) DEFAULT NULL,
  `photo` varchar(111) DEFAULT NULL,
  `doc_aadhar` varchar(111) DEFAULT NULL,
  `doc_pan` varchar(111) DEFAULT NULL,
  `luid` varchar(111) DEFAULT NULL,
  `ruid` varchar(111) DEFAULT NULL,
  `tlm` int(11) DEFAULT NULL,
  `tlm1` int(11) DEFAULT NULL,
  `tlm2` int(11) NOT NULL,
  `tlm3` int(11) NOT NULL,
  `wallet` float DEFAULT NULL,
  `wallet1` float DEFAULT NULL,
  `wallet2` float NOT NULL,
  `wallet3` float NOT NULL,
  `level` int(11) DEFAULT NULL,
  `level1` int(11) NOT NULL,
  `level2` int(11) NOT NULL,
  `level3` int(11) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `status1` int(11) NOT NULL,
  `status2` int(11) NOT NULL,
  `status3` int(11) NOT NULL,
  `root` text,
  `ac_holder` varchar(111) DEFAULT NULL,
  `bank_name` varchar(111) DEFAULT NULL,
  `branch_name` varchar(111) DEFAULT NULL,
  `ifsc` varchar(111) DEFAULT NULL,
  `ac_no` varchar(111) DEFAULT NULL,
  `n_name` varchar(111) DEFAULT NULL,
  `n_relation` varchar(999) DEFAULT NULL,
  `n_address` varchar(111) DEFAULT NULL,
  `n_dob` varchar(111) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `role` int(11) DEFAULT NULL,
  `product` int(11) DEFAULT NULL,
  `paym` int(11) DEFAULT NULL,
  `kyc` int(11) DEFAULT NULL,
  `gen` varchar(111) DEFAULT NULL,
  `state` varchar(111) DEFAULT NULL,
  `dist` varchar(111) DEFAULT NULL,
  `pin` varchar(111) DEFAULT NULL,
  `ac_type` varchar(111) DEFAULT NULL,
  `pans` int(11) DEFAULT NULL,
  `pr` int(11) DEFAULT NULL,
  `binary1` int(11) DEFAULT NULL,
  `upd_date` varchar(999) DEFAULT NULL,
  `upd_date2` varchar(999) DEFAULT NULL,
  `kyc2` int(11) DEFAULT NULL,
  `smsd` varchar(999) NOT NULL,
  `logs` int(11) NOT NULL,
  `roya` int(11) DEFAULT NULL,
  `kyc_message` text NOT NULL,
  `popups` int(11) NOT NULL,
  `mt` int(11) NOT NULL,
  `per` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=393 DEFAULT CHARSET=latin1;

INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (1, '', '', '8084940179', '70897', '1', '56605', 'Abhishek@21574', 'Manoj', 'future', 'Tryit India', '', '8084940179', 'tryit@gmail.com', '', 'Muz', '458745684586', '', '', '', '', '', '', 0, 0, 179, 0, '0', '0', '784.211', '0', 0, 0, 0, 0, 0, 1, 1, 1, NULL, 'admin', 'ICICI BANK', 'Muzaffarpur', 'ICIC0000306', '030605010185', '', '', '', '', '2020-05-24 21:35:57', '2021-08-12 16:09:12', 1, 14, 0, 1, '', '', '', '', 'Saving', 1, 0, 1, '2021-05-05 20:26:01', '', 0, 'Docate No 989898 Delhivery', 1, NULL, '', 0, 2, '2');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (220, '8084940179', NULL, '9939195269', '', '0', '', '12345', '', '', 'Manoj Sharma', NULL, '9939195269', 'tryit@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 178, 0, '0', '0', '1616.93', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-16 18:13:54', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 1, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (221, '9939195269', NULL, '7979030395', '', '0', '', '123456', '', '', 'AMAR SINGH', NULL, '7979030395', 'amarsingh101834@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 171, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-19 19:26:18', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (222, '9939195269', NULL, '9918508019', '', '0', '', 'imcool_manish1984', '', '', 'Manish kumar sharma', NULL, '9918508019', 'manishsharma873@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 170, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:20:53', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (223, '9939195269', NULL, '7992259617', '', '0', '', 'v12345', '', '', 'Vimal Kumar', NULL, '7992259617', 'biharbhakti.vimal@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 169, 0, '0', '0', '271.3', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:26:19', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (224, '9918508019', NULL, '6386476787', '', '0', '', 'Rohit@1819', '', '', 'Rohit Sharma', NULL, '6386476787', 'rohitfriends.rkt@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 168, 0, '0', '0', '77.05', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:32:07', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (225, '9939195269', NULL, '9939090087', '', '0', '', 'Sanjay123', '', '', 'Sanjay Kumar Mishra', NULL, '9939090087', 'skmishra951968@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 167, 0, '0', '0', '563.355', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:33:38', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (249, '9939090087', NULL, '9955688371', '', '0', '', 'Info@123', '', '', 'Surendra Bharti', NULL, '9955688371', 'bdm.surendra@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 143, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:19:38', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (227, '6386476787', NULL, '7004983144', '', '0', '', 'abhi1234', '', '', 'Abhishek Sharma', NULL, '7004983144', 'abhisheksharma.rkt@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 165, 0, '0', '0', '10.8', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:39:10', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (228, '9939195269', NULL, '9693287571', '', '0', '', '1977', '', '', 'SANJEEV PANDEY ', NULL, '9693287571', 'Sanjeev.pds73@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 164, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:44:19', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (248, '9931667459', NULL, '9471668022', '', '0', '', 'S12345', '', '', 'Sidh Nath Tiwari', NULL, '9471668022', 'nathtiwarys@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 144, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:16:00', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (230, '7004983144', NULL, '9576684117', '', '0', '', 'abhi1234', '', '', 'Raghuraj Rai', NULL, '9576684117', 'abhiraat18@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 161, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:48:53', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (247, '9939090087', NULL, '7700841919', '', '0', '', '123456', '', '', 'Abhishek Kumar', NULL, '7700841919', 'abhishek11178@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 145, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:11:54', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (246, '7004983144', NULL, '9931667459', '', '0', '', '654321', '', '', 'Umesh sharma', NULL, '9931667459', 'umeshvibha123@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 146, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:05:54', '2021-08-12 16:09:12', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (233, '7004983144', NULL, '9508253533', '', '0', '', 'Manglam@123', '', '', 'Manglam', NULL, '9508253533', 'manglamvats175@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 159, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:52:26', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (245, '9939090087', NULL, '7301536136', '', '0', '', 'Amit@2907', '', '', 'Amit Kumar', NULL, '7301536136', 'ajay.amit29@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 147, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 19:51:46', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (244, '7004983144', NULL, '9546177051', '', '0', '', '842002abhigyan', '', '', 'Abhigyan kumar', NULL, '9546177051', 'abhigyan80@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 148, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 15:37:24', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (236, '7004983144', NULL, '7764898317', '', '0', '', 'yash@tryit', '', '', 'Yash Rajpal', NULL, '7764898317', 'yashh.you@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 156, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 10:56:10', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (237, '7004983144', NULL, '7004779572', '', '0', '', '77791sbp', '', '', 'kaushik srivastava', NULL, '7004779572', 'harshkaushik129@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 155, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 11:44:54', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (238, '7004983144', NULL, '6201211018', '', '0', '', '20376762473', '', '', 'Prince Raj Jha', NULL, '6201211018', 'vickyjha5078@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 154, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 12:28:37', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (243, '8210179625', NULL, '7369882648', '', '0', '', 'avanisH@9', '', '', 'Avanish Kumar', NULL, '7369882648', 'avkumar4321@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 149, 0, '0', '0', '49.235', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 14:00:31', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (240, '7004983144', NULL, '7301101143', '', '0', '', 'steveroger007', '', '', 'Harshit Harsh', NULL, '7301101143', 'harshitharsh32@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 152, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 12:31:01', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (241, '7979030395', NULL, '8210179625', '', '0', '', 'kumar', '', '', 'Mithilesh Kumar', NULL, '8210179625', 'mithileshpds@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 151, 0, '0', '0', '146.345', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 13:18:21', '2021-08-12 16:09:12', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (242, '7004983144', NULL, '9934748803', '', '0', '', 'adi123...', '', '', 'Aditya Raj', NULL, '9934748803', 'adityaraj001213@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 150, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 13:42:21', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (250, '7004983144', NULL, '7050096409', '', '0', '', 'Ab21021989@', '', '', 'Abhishek Kumar', NULL, '7050096409', 'akumarsit1989@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 142, 0, '0', '0', '1', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:20:49', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (251, '6201211018', NULL, '9798067920', '', '0', '', 'Pramod 123', '', '', 'Pramod Kumar jha', NULL, '9798067920', 'pramodkumarjha38@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 141, 0, '0', '0', '2.36', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:29:08', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (252, '9939090087', NULL, '9939002200', '', '0', '', 'amresh', '', '', 'Amresh kumar', NULL, '9939002200', 'oshoamresh94@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 140, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:33:39', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (253, '6201211018', NULL, '8227973889', '', '0', '', 'passwordkumari', '', '', 'Shalini mishra', NULL, '8227973889', 'shalinimishra8804@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 139, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:46:14', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (254, '9939090087', NULL, '8084562474', '', '0', '', 'shobha', '', '', 'Surendra chaudhary', NULL, '8084562474', 'surendraflp74@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 138, 0, '0', '0', '3.94', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 20:50:56', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (255, '7369882648', NULL, '7371815641', '', '0', '', 'shyam3115kumar', '', '', 'Shyam kumar', NULL, '7371815641', 'shyam7371@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 137, 0, '0', '0', '33.065', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,7369882648', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 22:02:55', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (256, '8210179625', NULL, '8936058495', '', '0', '', '181922', '', '', 'Rajni', NULL, '8936058495', 'rspankhurig@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 136, 0, '0', '0', '201', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-20 22:23:47', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (257, '7004983144', NULL, '9334906149', '', '0', '', 'Npa241116@', '', '', 'Hanuman Prasad Marodiya', NULL, '9334906149', 'mr.nagarwal27@rediffmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 135, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 07:57:06', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (258, '7004983144', NULL, '9155868679', '', '0', '', '9693', '', '', 'Amod Kumar ', NULL, '9155868679', 'amod200584@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 134, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 08:08:22', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (259, '7004983144', NULL, '8789369583', '', '0', '', '9934033810', '', '', 'Himanshu kumar singh', NULL, '8789369583', 'Himanshusinghrathore0000@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 133, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 08:38:15', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (260, '9334906149', NULL, '9199354154', '', '0', '', 'Npa241116@', '', '', 'Pooja Agarwal', NULL, '9199354154', 'Poojakeshri07@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 132, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:01:52', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (261, '9199354154', NULL, '8603590717', '', '0', '', 'Npa241116@', '', '', 'Nikhil Kumar Agarwal', NULL, '8603590717', 'jaimatadi010413@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 131, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149,9199354154', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:05:20', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (262, '9334906149', NULL, '9199701755', '', '0', '', 'Npa241116@', '', '', 'Nikhil kumar Agarwal', NULL, '9199701755', 'jaimatadeetraders010410@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 130, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:10:29', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (263, '9939090087', NULL, '7903515631', '', '0', '', '9771123695', '', '', 'Raghavendra Kumar', NULL, '7903515631', 'raghavendrakrmishra@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 129, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 09:36:26', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (264, '6201211018', NULL, '7461099919', '', '0', '', '746109', '', '', 'KÃRÃÑ kumar', NULL, '7461099919', 'karankumar37160@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 128, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:06:22', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (265, '7461099919', NULL, '8574681882', '', '0', '', 'jata shankar', '', '', 'Jata shankar ', NULL, '8574681882', 'jatashankarzee@gmail', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 127, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,6201211018,7461099919', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:16:05', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (266, '8210179625', NULL, '9955659959', '', '0', '', 'prachi51', '', '', 'Wipin kumar', NULL, '9955659959', 'prachi9955659959@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 126, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:23:41', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (267, '9693287571', NULL, '9931220861', '', '0', '', '12345', '', '', 'Sunny Pandey ', NULL, '9931220861', 'sunnypandey850@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 125, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9693287571', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:27:08', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (268, '9199701755', NULL, '6201655088', '', '0', '', 'Npa241116@', '', '', 'Nikhil kumar Agarwal', NULL, '6201655088', 'jaimatadi010413@rediffmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 124, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334906149,9199701755', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:40:06', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (269, '8210179625', NULL, '8210687557', '', '0', '', 'R12345', '', '', 'RAJEEV RANJAN MISHRA', NULL, '8210687557', 'rajiv@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 123, 0, '0', '0', '85.94', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 10:52:29', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (270, '8210179625', NULL, '9570641920', '', '0', '', '7250164501', '', '', 'Manish kumar', NULL, '9570641920', 'mk14606@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 122, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 13:43:45', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (271, '9939090087', NULL, '9708773892', '', '0', '', '27011996', '', '', 'Ram kumar', NULL, '9708773892', 'ar586399@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 121, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 13:46:28', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (308, '9939195269', NULL, '9835153380', '', '0', '', '983515', '', '', 'Lov Prakash', NULL, '9835153380', 'kushprakash92@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 84, 0, '0', '0', '102.8', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 18:16:58', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (272, '8210179625', NULL, '9661725051', '', '0', '', '9661725051', '', '', 'Dilip kumar', NULL, '9661725051', 'dkjee5051@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 120, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 14:34:04', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (273, '9939090087', NULL, '9708203929', '', '0', '', 'Kpsingh123', '', '', 'Kaushlendra prasad singh', NULL, '9708203929', 'kaushlendra10bxdps3869n@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 119, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:25:54', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (274, '8210179625', NULL, '9934919689', '', '0', '', '22222', '', '', 'Jitendra kumar', NULL, '9934919689', 'jitendra_kumar008@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 118, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:43:07', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (275, '8210687557', NULL, '6207574162', '', '0', '', 'S12345', '', '', 'SURESH PRASAD SHAHI', NULL, '6207574162', 'suresh@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 117, 0, '0', '0', '54', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 20:57:30', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (276, '8210687557', NULL, '9708314717', '', '0', '', 'krity0', '', '', 'Kanhaiya Lal Singh', NULL, '9708314717', 'kl.singh86@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 116, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 21:10:00', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (277, '7004983144', NULL, '7717790405', '', '0', '', '9525093649', '', '', 'Pankaj Kumar ', NULL, '7717790405', 'pankajkumar02390@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 115, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 22:10:51', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (278, '9939090087', NULL, '7563092302', '', '0', '', 'av1234', '', '', 'Abhilasha Kumari', NULL, '7563092302', 'abhilashapathak1999@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 114, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-21 22:27:36', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (279, '8210179625', NULL, '9304292354', '', '0', '', 'deepak', '', '', 'Deepak', NULL, '9304292354', 'deepakpappu9304@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 113, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 12:35:41', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (280, '7979030395', NULL, '9122894111', '', '0', '', '12345', '', '', 'amar', NULL, '9122894111', 'amarsingh101834@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 112, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 14:36:26', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (281, '9122894111', NULL, '8102811241', '', '0', '', '12345', '', '', 'AMAR SINGH', NULL, '8102811241', 'gmart.today@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 111, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 14:38:19', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (282, '9939090087', NULL, '8340289850', '', '0', '', 'chandni@123', '', '', 'Chandni', NULL, '8340289850', 'ck8409678724@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 110, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 15:36:04', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (283, '9939090087', NULL, '7991159941', '', '0', '', 'Gaurav@12345', '', '', 'Gaurav', NULL, '7991159941', 'gauav.pandey@icicibank.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 109, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 16:13:20', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (284, '7992259617', NULL, '7033280505', '', '0', '', 'Atul123', '', '', 'Atul Kumar', NULL, '7033280505', 'www.akumar6@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 108, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-22 18:18:31', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (285, '8102811241', NULL, '8873749286', '', '0', '', 'teamteogther2021', '', '', 'Team Teogther ', NULL, '8873749286', 'teamteogther2021@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 107, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:08:07', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (286, '8873749286', NULL, '6201847968', '', '0', '', 'rajkri', '', '', 'Team togther 1', NULL, '6201847968', 'teamtogther20211@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 106, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:38:46', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (287, '6201847968', NULL, '6204143525', '', '0', '', 'rajkri', '', '', 'Team together 2', NULL, '6204143525', 'teamtogether20212@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 105, 0, '0', '0', '100', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:50:03', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (288, '8210179625', NULL, '9835295896', '', '0', '', 'k123456', '', '', 'Kamlesh kumar', NULL, '9835295896', 'mithileshpds@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 104, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 18:54:29', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (289, '7004983144', NULL, '8092221370', '', '0', '', 'N12345', '', '', 'Nandan Kumar', NULL, '8092221370', 'nandanonly4u@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 103, 0, '0', '0', '2', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 20:19:40', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (290, '7004983144', NULL, '9430409859', '', '0', '', 'bcegkmqs', '', '', 'Manoj Kumar Singh', NULL, '9430409859', 'manojksinghreal952@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 102, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-23 20:23:35', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (291, '6204143525', NULL, '6204736973', '', '0', '', '12345', '', '', 'AKASH OJHA', NULL, '6204736973', 'rajojha22222@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 101, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 12:57:08', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (292, '6204143525', NULL, '8235175667', '', '0', '', 'krishna', '', '', 'Krishna Kumar', NULL, '8235175667', 'krishna.ke55@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 100, 0, '0', '0', '434.4', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 13:07:09', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (293, '7004983144', NULL, '8102689164', '', '0', '', 'abhi1234', '', '', 'Pooja sharma ', NULL, '8102689164', 'poojaabhisharma14@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 99, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-24 15:27:17', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (294, '8235175667', NULL, '8873395437', '', '0', '', 'abha kumari', '', '', 'Abha Kumari', NULL, '8873395437', 'manishkumar88733954@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 98, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,8235175667', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 08:22:00', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (295, '6204143525', NULL, '7277977659', '', '0', '', '123456', '', '', 'RAJAN KUMAR', NULL, '7277977659', 'rajan1995ca@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 97, 0, '0', '0', '259.73', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 11:00:34', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (296, '9939195269', NULL, '9097027327', '', '0', '', 'Guriya', '', '', 'Anand mohan', NULL, '9097027327', 'mohananand887@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 96, 0, '0', '0', '5', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-25 22:12:28', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (297, '7371815641', NULL, '7079700793', '', '0', '', 'Kunal@123', '', '', 'Kunal kumar', NULL, '7079700793', 'kunalbabu3238@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 95, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,7369882648,7371815641', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-26 10:15:17', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (298, '7004983144', NULL, '7903332032', '', '0', '', 'anadibabu71', '', '', 'Gauri Shankar Chaudhary', NULL, '7903332032', 'advgauriji71@email.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 94, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-26 16:29:27', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (299, '7004983144', NULL, '8083760428', '', '0', '', 'myname02QA', '', '', 'Kamar Alam', NULL, '8083760428', 'qamar198280@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 93, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-27 12:28:19', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (300, '8102811241', NULL, '7905018718', '', '0', '', 'tryitindia@123', '', '', 'Alok kushwaha', NULL, '7905018718', 'alok.prolabs@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 92, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-27 19:49:39', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (301, '7004983144', NULL, '9234659964', '', '0', '', 'A12345', '', '', 'Amod Kumar', NULL, '9234659964', 'srirambhoj@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 91, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 08:14:18', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (302, '6207574162', NULL, '7562026045', '', '0', '', 's12345', '', '', 'Shantanu kumar', NULL, '7562026045', 'Shantanukumar7562@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 90, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 09:17:41', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (303, '6386476787', NULL, '7518496436', '', '0', '', 'tryit123', '', '', 'Saroj Singh ', NULL, '7518496436', 'singhsaroj571@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 89, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-28 13:58:50', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (304, '8936058495', NULL, '7654487814', '', '0', '', 'aisha1234', '', '', 'Amisha ', NULL, '7654487814', 'amishakumari828@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 88, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 08:41:06', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (305, '8936058495', NULL, '7979835482', '', '0', '', '9852', '', '', 'Dhruv kumar', NULL, '7979835482', 'dhruvkumar.dk5@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 87, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 09:16:09', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (306, '7004983144', NULL, '8789638761', '', '0', '', '1982', '', '', 'Abhishek kartikya', NULL, '8789638761', 'abhi.shreemahimasteelandcrocry@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 86, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 10:41:15', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (307, '8235175667', NULL, '7992241588', '', '0', '', '001993', '', '', 'MD SARFRAJ', NULL, '7992241588', 'mdsarfrajmuz1993@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 85, 0, '0', '0', '2.4', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,8235175667', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 12:56:59', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (309, '9835153380', NULL, '8010221234', '', '0', '', '626474', '', '', 'Manish Kumar', NULL, '8010221234', 'manishmani116@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 83, 0, '0', '0', '82.72', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-29 18:18:37', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (310, '7004983144', NULL, '7903611039', '', '0', '', 'mack9852', '', '', 'Vikas singh', NULL, '7903611039', 'viks.singh62@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 82, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-30 19:02:44', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (311, '7004983144', NULL, '9386254826', '', '0', '', 'molu', '', '', 'Arjun singh ', NULL, '9386254826', 'arjun.sidhwalia@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 81, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 07:02:40', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (312, '7050096409', NULL, '9031291591', '', '0', '', 'k1r2i3t4i5', '', '', 'Raja kumar', NULL, '9031291591', 'kritinayakk@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 80, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,7050096409', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 16:14:15', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (313, '7004983144', NULL, '7004565299', '', '0', '', '777766', '', '', 'Shambhu Kumar', NULL, '7004565299', 'shambhu1976muz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 79, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 19:02:33', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (314, '9471668022', NULL, '9801037453', '', '0', '', 'R12345', '', '', 'Raghvendra Tiwari', NULL, '9801037453', 'raghvendratiwari504@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 78, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459,9471668022', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 20:06:45', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (315, '8936058495', NULL, '7352028508', '', '0', '', 'hk1087752', '', '', 'Harsh Raj', NULL, '7352028508', 'hk1087752@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 77, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-31 20:24:51', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (316, '7992259617', NULL, '9142836671', '', '0', '', 'Sona1976@', '', '', 'Sushmita kumari', NULL, '9142836671', 'sushmitakumari692@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 76, 0, '0', '0', '10', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 07:35:28', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (317, '7992259617', NULL, '7004233679', '', '0', '', '99318', '', '', 'Anand kumar', NULL, '7004233679', 'sonusinghanand01@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 75, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:13:02', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (318, '7004233679', NULL, '6204132224', '', '0', '', 'manishmahi', '', '', 'Manish kumar ', NULL, '6204132224', 'Manishmahi818@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 74, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,7004233679', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:18:12', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (319, '7004233679', NULL, '7903214726', '', '0', '', '5255', '', '', 'SHIVAM', NULL, '7903214726', 'shivam1983muz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 73, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,7004233679', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 09:53:49', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (320, '7992259617', NULL, '9939197125', '', '0', '', 'skdmka@@@123', '', '', 'Sanjay kumar', NULL, '9939197125', 'skdmka@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 72, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 14:10:55', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (321, '8102811241', NULL, '9852520379', '', '0', '', '9554', '', '', 'Raj Kumar', NULL, '9852520379', 'sksantoshart@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 71, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 15:51:52', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (322, '9142836671', NULL, '9773957736', '', '0', '', 'mahesh6218', '', '', 'Mahesh Pandit', NULL, '9773957736', 'maheshpandit6218@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 70, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9142836671', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-01 20:29:47', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (323, '6204736973', NULL, '9128372179', '', '0', '', '12345', '', '', 'suraj ojha', NULL, '9128372179', '6204736973', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 69, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,9122894111,8102811241,8873749286,6201847968,6204143525,6204736973', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-02 14:17:47', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (324, '7004983144', NULL, '7739531880', '', '0', '', 'S12345', '', '', 'Kumari Seema', NULL, '7739531880', 'seemakumari02439@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 68, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-02 19:18:32', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (325, '7004983144', NULL, '7013657676', '', '0', '', 'majhaulia', '', '', 'md naushad', NULL, '7013657676', 'knaushad918@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 67, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-03 11:18:31', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (326, '8210687557', NULL, '7992282859', '', '0', '', 'B12345', '', '', 'Ravi Shankar kumar', NULL, '7992282859', '9934469875', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 66, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-04 16:35:48', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (327, '7992259617', NULL, '9431650043', '', '0', '', '1965sanjay', '', '', 'Sanjay Kumar ', NULL, '9431650043', 'sanjaykr12358@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 65, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 07:46:23', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (328, '9431650043', NULL, '8409394547', '', '0', '', 'bkranjan3155', '', '', 'Braj kishor ranjan', NULL, '8409394547', 'bkranjansjfil@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 64, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 10:56:00', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (329, '9835153380', NULL, '9939527762', '', '0', '', '12345', '', '', 'Chandrabhushan Prakash', NULL, '9939527762', 'chandrabhushan1225@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 63, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 10:56:42', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (330, '9939090087', NULL, '8210297807', '', '0', '', 'N12345', '', '', 'Niraj Kumar', NULL, '8210297807', 'putul0433@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 62, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 15:05:08', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (331, '8210297807', NULL, '8709725571', '', '0', '', 'R12345', '', '', 'RAJESH SAH', NULL, '8709725571', 'rksah97099@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 61, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087,8210297807', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 15:35:35', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (332, '7004983144', NULL, '9835229360', '', '0', '', 'R12345', '', '', 'RANJIT KUMAR', NULL, '9835229360', 'ranjitkumarahuja@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 60, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 17:57:39', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (333, '8936058495', NULL, '8936064895', '', '0', '', 'kumar', '', '', 'Stuti Singh', NULL, '8936064895', 'mithileshsingh18814@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 59, 0, '0', '0', '250', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 18:27:44', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (334, '8936064895', NULL, '9905222899', '', '0', '', 'kumar', '', '', 'Akshra Singh', NULL, '9905222899', 'akshrasingh2210@yahoo.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 58, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 19:19:46', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (335, '7004983144', NULL, '9905739033', '', '0', '', 'R12345', '', '', 'Rajnish Kumar', NULL, '9905739033', 'rajnishkumar83455@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 57, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-05 20:14:33', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (336, '7004983144', NULL, '9693148039', '', '0', '', 'G12345', '', '', 'Govind Kumar', NULL, '9693148039', 'govind@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 56, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:34:01', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (337, '8084940179', NULL, '9693147039', '', '0', '', 'G12345', '', '', 'Govind Kumar', NULL, '9693147039', 'govind@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 55, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:39:28', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (338, '7004983144', NULL, '9142768216', '', '0', '', '630630', '', '', 'Rajput Karan', NULL, '9142768216', 'rajputkarancima@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 54, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 07:57:57', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (339, '9939195269', NULL, '9801211629', '', '0', '', 'B12345', '', '', 'Baba ji', NULL, '9801211629', 'babaji@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 53, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 10:38:42', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (340, '9931667459', NULL, '9939177039', '', '0', '', '8199', '', '', 'Mrityunjay Kumar', NULL, '9939177039', 'mrityunjaymuzaffarpur@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 52, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9931667459', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 11:54:41', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (341, '7004983144', NULL, '9334543228', '', '0', '', 'S12345', '', '', 'Shyam Sharma', NULL, '9334543228', 'atrisharma1@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 51, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 14:11:30', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (342, '9334543228', NULL, '9631506226', '', '0', '', 'R12345', '', '', 'Ram Sharma', NULL, '9631506226', 'ramgungun94@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 50, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9334543228', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 14:19:13', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (343, '9835153380', NULL, '9576244038', '', '0', '', '12345', '', '', 'Chhotu kumar', NULL, '9576244038', '9939527762', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 49, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9835153380', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 17:18:42', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (344, '9431650043', NULL, '7979041485', '', '0', '', '12345', '', '', 'Pramod Kumar', NULL, '7979041485', 'pramodkumarteacher73@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 48, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-06 18:23:41', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (345, '7004983144', NULL, '8877877602', '', '0', '', 'D12345', '', '', 'Dilip Kumar Thakur', NULL, '8877877602', 'dilipthakur1234321@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 47, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 11:00:56', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (346, '7004983144', NULL, '8789420986', '', '0', '', 'phani@123', '', '', 'Phani Sinha', NULL, '8789420986', 'phanibksinha@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 46, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 15:21:22', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (347, '9905222899', NULL, '7488006584', '', '0', '', 'nihal@2002', '', '', 'Navin kumar', NULL, '7488006584', 'kantienterprisesauto@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 45, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-07 18:57:42', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (348, '8936064895', NULL, '9964852841', '', '0', '', '9934886341', '', '', 'Nitin Kumar', NULL, '9964852841', 'nitin3791@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 44, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 09:36:45', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (349, '8936064895', NULL, '7541984238', '', '0', '', 'golu6004', '', '', 'Akshay Kumar', NULL, '7541984238', 'akshays1191044@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 43, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:00:48', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (350, '7541984238', NULL, '8709438362', '', '0', '', '8709438362', '', '', 'Damini kumari', NULL, '8709438362', 'kumaridamini29@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 42, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,7541984238', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:04:11', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (351, '8936064895', NULL, '9334094589', '', '0', '', '123456789', '', '', 'SUDERSHAN SINGH', NULL, '9334094589', 'riya03821@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 41, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 10:45:09', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (352, '8936064895', NULL, '9709568770', '', '0', '', '1203', '', '', 'Arun kumar Sharma', NULL, '9709568770', 'arunkumar@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 40, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 11:16:48', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (353, '9964852841', NULL, '7069449125', '', '0', '', '9135141688', '', '', 'Nitesh kumar', NULL, '7069449125', 'kumarnitesh.npti@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 39, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9964852841', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 11:38:51', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (354, '9939090087', NULL, '9934982684', '', '0', '', 'N123456', '', '', 'Navin kumar nishad', NULL, '9934982684', 'navilflp72@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 38, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 12:36:36', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (355, '9939090087', NULL, '7324950411', '', '0', '', 'S12345', '', '', 'SHASHI RANJAN SRIVASTSVA', NULL, '7324950411', 'shashiranjanshrivastav745@gmel.come', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 37, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 13:07:06', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (356, '6386476787', NULL, '7860683831', '', '0', '', '0007', '', '', 'Amit kumar pathak', NULL, '7860683831', 'amitpathak231217@gmail.con', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 36, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:34:46', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (357, '7860683831', NULL, '8419020475', '', '0', '', '6394097561', '', '', 'Apil ', NULL, '8419020475', 'apilkumarbhuiyan@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 35, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:38:34', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (358, '8419020475', NULL, '8052330561', '', '0', '', 'rajit1234', '', '', 'Rajitram', NULL, '8052330561', 'rajitramnishad0@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 34, 0, '0', '0', '64.25', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831,8419020475', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 15:49:49', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (359, '7992259617', NULL, '9334904141', '', '0', '', 'p@ssword123', '', '', 'Rakesh Kumar', NULL, '9334904141', 'computer.worldmuz@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 33, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 19:57:21', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (360, '9939090087', NULL, '7654353455', '', '0', '', 'Dr123456', '', '', 'Dr. Manoranjan Kumar', NULL, '7654353455', 'manoranjan1239@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 32, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:01:45', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (361, '7004983144', NULL, '9934018161', '', '0', '', 'C12345', '', '', 'Chandra Shekhar Tiwari', NULL, '9934018161', 'chandan18161@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 31, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:11:28', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (362, '9934018161', NULL, '9931103870', '', '0', '', 'S12345', '', '', 'RAGHVENDRA TIWARI', NULL, '9931103870', 'shwetiprabha4@g.mail', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 30, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,9934018161', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 20:16:32', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (363, '9905222899', NULL, '9128806623', '', '0', '', '1982', '', '', 'Kapileshwar jha', NULL, '9128806623', 'kapileshwarjha1325@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 29, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895,9905222899', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-08 21:59:05', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (364, '6207574162', NULL, '7634039847', '', '0', '', 'N12345', '', '', 'Naval Kumar', NULL, '7634039847', 'nabaldas34@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 28, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 08:50:02', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (365, '7634039847', NULL, '9525370899', '', '0', '', 'R12345', '', '', 'Rajesh Kumar', NULL, '9525370899', 'rajesh87220@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 27, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8210687557,6207574162,7634039847', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 08:57:05', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (366, '9097027327', NULL, '7903057185', '', '0', '', 'rajput', '', '', 'Nishab kumar', NULL, '7903057185', 'rajputnishab2005@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 26, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9097027327', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 11:07:03', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (367, '9939090087', NULL, '9708853302', '', '0', '', 'bh123456', '', '', 'Bharti Mishra', NULL, '9708853302', 'bharti0302@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 25, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 16:19:57', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (368, '7004983144', NULL, '6202116564', '', '0', '', 'S12345', '', '', 'Md Shakil', NULL, '6202116564', 'mdshakil08714@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 24, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-09 18:01:01', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (369, '7004983144', NULL, '7488764188', '', '0', '', '129110', '', '', 'Aditya Kumar', NULL, '7488764188', 'adityakaushik12911@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 23, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 08:36:05', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (370, '9939090087', NULL, '9708491927', '', '0', '', 'guru123456', '', '', 'Ashok kumar', NULL, '9708491927', 'ashokashok32877@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 22, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 14:57:39', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (371, '7992259617', NULL, '6203818802', '', '0', '', 'R12345', '', '', 'Ritesh Kumar', NULL, '6203818802', 'riteshkmr83cup@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 21, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 14:59:26', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (372, '6386476787', NULL, '9792465464', '', '0', '', 'kalim7878', '', '', 'Kalim Siddiqui', NULL, '9792465464', 'kalimarfeen78@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 20, 0, '0', '0', '8.325', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 15:28:44', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (373, '7004983144', NULL, '6299907015', '', '0', '', '6299907015', '', '', 'Akshay Kumar', NULL, '6299907015', 'ak1238496@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 19, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-10 22:07:20', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (374, '7488764188', NULL, '8102183836', '', '0', '', '12345', '', '', 'Ashutosh Kumar ', NULL, '8102183836', 'royalboysadi@gamsil.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 18, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,7488764188', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 08:14:13', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (375, '6386476787', NULL, '9305903970', '', '0', '', '7777777', '', '', 'Jai Prakash Kumar', NULL, '9305903970', 'jaiprakashkumar22051996@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 17, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 12:16:02', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (376, '8409394547', NULL, '7061012879', '', '0', '', '124355', '', '', 'Nidhi kumari', NULL, '7061012879', 'nidhikumari21091999@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 16, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 13:55:54', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (377, '7004983144', NULL, '8960941010', '', '0', '', 'Rahul@1993', '', '', 'Rahul Sharma', NULL, '8960941010', 'rahulsharma.srj@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 15, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:05:24', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (378, '7004983144', NULL, '7004990540', '', '0', '', 'Manish@8696', '', '', 'Vijayant Thakur', NULL, '7004990540', 'vijayantkumar15@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 14, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:54:40', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (379, '7061012879', NULL, '7352730408', '', '0', '', '124355', '', '', 'Vijay kumar', NULL, '7352730408', 'vijay.kmr1243@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 13, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547,7061012879', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 14:55:40', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (380, '8210179625', NULL, '9142879079', '', '0', '', 'fdsa123456', '', '', 'Rupesh kumar ', NULL, '9142879079', 'rupeshkumar.altos@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 12, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 16:13:21', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (381, '8409394547', NULL, '9162646022', '', '0', '', 'habib786', '', '', 'Md Habib Ansari', NULL, '9162646022', 'mdhansari87@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 11, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 17:04:33', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (382, '8052330561', NULL, '8299506513', '', '0', '', '8423956441', '', '', 'Amardeep kumar', NULL, '8299506513', 'amardeepkumar180@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 10, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7860683831,8419020475,8052330561', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 17:43:36', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (383, '8409394547', NULL, '9117759250', '', '0', '', '9117759250', '', '', 'Manikant singh', NULL, '9117759250', 'manikantsinggh@Gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 9, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 18:50:39', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (384, '7004983144', NULL, '7667702006', '', '0', '', 'L12345', '', '', 'Lal Babu prasad singh', NULL, '7667702006', 'lalbabu995565@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 8, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 20:07:53', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (385, '9162646022', NULL, '8757470705', '', '0', '', 'ravindra@123', '', '', 'Ravindra Kumar sah', NULL, '8757470705', 'ravindrakumarsah8901@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 7, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547,9162646022', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-11 22:32:11', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (386, '8960941010', NULL, '7897275730', '', '0', '', '231217', '', '', 'Mannu Kumar Singh', NULL, '7897275730', 'mannukumar18592@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 6, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144,8960941010', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 05:48:00', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (387, '8409394547', NULL, '8409888556', '', '0', '', '9097842091', '', '', 'Gudakesh', NULL, '8409888556', 'gudeshgupta@Gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 5, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617,9431650043,8409394547', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 16:47:59', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (388, '7992259617', NULL, '9334900495', '', '0', '', 'Ranavika@1', '', '', 'Rajesh G', NULL, '9334900495', 'rajeshappan@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 4, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7992259617', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 17:16:55', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (389, '8936064895', NULL, '7004982268', '', '0', '', '17october', '', '', 'Nayan Prakash', NULL, '7004982268', 'nayanprakash17@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 3, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,7979030395,8210179625,8936058495,8936064895', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 18:48:20', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (390, '9939090087', NULL, '9122181692', '', '0', '', 'ram08146', '', '', 'Ram Kumar', NULL, '9122181692', 'ram08146@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 2, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 19:39:14', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (391, '9939090087', NULL, '6204218979', '', '0', '', 'chhoti123', '', '', 'Bhabya Bharti ', NULL, '6204218979', 'Bhabyabharti953@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 1, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9939090087', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 20:06:51', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');
INSERT INTO `details` (`id`, `sponsor`, `upid`, `uid`, `mid`, `branch`, `staff`, `pass`, `pass1`, `pass2`, `name`, `fname`, `mob`, `email`, `dob`, `address`, `aadhar`, `pan`, `photo`, `doc_aadhar`, `doc_pan`, `luid`, `ruid`, `tlm`, `tlm1`, `tlm2`, `tlm3`, `wallet`, `wallet1`, `wallet2`, `wallet3`, `level`, `level1`, `level2`, `level3`, `status`, `status1`, `status2`, `status3`, `root`, `ac_holder`, `bank_name`, `branch_name`, `ifsc`, `ac_no`, `n_name`, `n_relation`, `n_address`, `n_dob`, `addon`, `updated`, `role`, `product`, `paym`, `kyc`, `gen`, `state`, `dist`, `pin`, `ac_type`, `pans`, `pr`, `binary1`, `upd_date`, `upd_date2`, `kyc2`, `smsd`, `logs`, `roya`, `kyc_message`, `popups`, `mt`, `per`) VALUES (392, '7004983144', NULL, '9572683083', '', '0', '', 'tryyuvraj4587.', '', '', 'Yuvraj anand', NULL, '9572683083', 'hiyuvraj123@gmail.com', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, '0', '0', '0', '0', 0, 0, 0, 0, 1, 1, 1, 0, ',8084940179,9939195269,9918508019,6386476787,7004983144', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-12 21:39:11', '2021-08-12 16:09:12', 0, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, '0', 0, NULL, '', 0, 0, '0');


#
# TABLE STRUCTURE FOR: districts
#

DROP TABLE IF EXISTS `districts`;

CREATE TABLE `districts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `state_id` int(11) NOT NULL,
  `name` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=646 DEFAULT CHARSET=latin1;

INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (1, 1, 'North Andaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (2, 1, 'South Andaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (3, 1, 'Nicobar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (4, 2, 'Adilabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (5, 2, 'Anantapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (6, 2, 'Chittoor');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (7, 2, 'East Godavari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (8, 2, 'Guntur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (9, 2, 'Hyderabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (10, 2, 'Karimnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (11, 2, 'Khammam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (12, 2, 'Krishna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (13, 2, 'Kurnool');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (14, 2, 'Mahbubnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (15, 2, 'Medak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (16, 2, 'Nalgonda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (17, 2, 'Nizamabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (18, 2, 'Prakasam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (19, 2, 'Ranga Reddy');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (20, 2, 'Srikakulam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (21, 2, 'Sri Potti Sri Ramulu Nellore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (22, 2, 'Vishakhapatnam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (23, 2, 'Vizianagaram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (24, 2, 'Warangal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (25, 2, 'West Godavari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (26, 2, 'Cudappah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (27, 3, 'Anjaw');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (28, 3, 'Changlang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (29, 3, 'East Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (30, 3, 'East Kameng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (31, 3, 'Kurung Kumey');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (32, 3, 'Lohit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (33, 3, 'Lower Dibang Valley');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (34, 3, 'Lower Subansiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (35, 3, 'Papum Pare');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (36, 3, 'Tawang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (37, 3, 'Tirap');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (38, 3, 'Dibang Valley');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (39, 3, 'Upper Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (40, 3, 'Upper Subansiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (41, 3, 'West Kameng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (42, 3, 'West Siang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (43, 4, 'Baksa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (44, 4, 'Barpeta');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (45, 4, 'Bongaigaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (46, 4, 'Cachar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (47, 4, 'Chirang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (48, 4, 'Darrang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (49, 4, 'Dhemaji');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (50, 4, 'Dima Hasao');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (51, 4, 'Dhubri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (52, 4, 'Dibrugarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (53, 4, 'Goalpara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (54, 4, 'Golaghat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (55, 4, 'Hailakandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (56, 4, 'Jorhat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (57, 4, 'Kamrup');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (58, 4, 'Kamrup Metropolitan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (59, 4, 'Karbi Anglong');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (60, 4, 'Karimganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (61, 4, 'Kokrajhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (62, 4, 'Lakhimpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (63, 4, 'Morigaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (64, 4, 'Nagaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (65, 4, 'Nalbari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (66, 4, 'Sivasagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (67, 4, 'Sonitpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (68, 4, 'Tinsukia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (69, 4, 'Udalguri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (70, 5, 'Araria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (71, 5, 'Arwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (72, 5, 'Aurangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (73, 5, 'Banka');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (74, 5, 'Begusarai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (75, 5, 'Bhagalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (76, 5, 'Bhojpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (77, 5, 'Buxar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (78, 5, 'Darbhanga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (79, 5, 'East Champaran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (80, 5, 'Gaya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (81, 5, 'Gopalganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (82, 5, 'Jamui');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (83, 5, 'Jehanabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (84, 5, 'Kaimur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (85, 5, 'Katihar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (86, 5, 'Khagaria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (87, 5, 'Kishanganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (88, 5, 'Lakhisarai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (89, 5, 'Madhepura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (90, 5, 'Madhubani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (91, 5, 'Munger');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (92, 5, 'Muzaffarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (93, 5, 'Nalanda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (94, 5, 'Nawada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (95, 5, 'Patna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (96, 5, 'Purnia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (97, 5, 'Rohtas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (98, 5, 'Saharsa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (99, 5, 'Samastipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (100, 5, 'Saran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (101, 5, 'Sheikhpura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (102, 5, 'Sheohar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (103, 5, 'Sitamarhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (104, 5, 'Siwan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (105, 5, 'Supaul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (106, 6, 'Chandigarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (107, 7, 'Bastar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (108, 7, 'Bijapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (109, 7, 'Bilaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (110, 7, 'Dantewada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (111, 7, 'Dhamtari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (112, 7, 'Durg');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (113, 7, 'Jashpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (114, 7, 'Janjgir-Champa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (115, 7, 'Korba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (116, 7, 'Koriya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (117, 7, 'Kanker');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (118, 7, 'Kabirdham (formerly Kawardha)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (119, 7, 'Mahasamund');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (120, 7, 'Narayanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (121, 7, 'Raigarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (122, 7, 'Rajnandgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (123, 7, 'Raipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (124, 7, 'Surguja');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (125, 8, 'Dadra and Nagar Haveli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (126, 9, 'Daman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (127, 9, 'Diu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (128, 10, 'Central Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (129, 10, 'East Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (130, 10, 'New Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (131, 10, 'North Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (132, 10, 'North East Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (133, 10, 'North West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (134, 10, 'South Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (135, 10, 'South West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (136, 10, 'West Delhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (137, 11, 'North Goa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (138, 11, 'South Goa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (139, 12, 'Ahmedabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (140, 12, 'Amreli district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (141, 12, 'Anand');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (142, 12, 'Banaskantha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (143, 12, 'Bharuch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (144, 12, 'Bhavnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (145, 12, 'Dahod');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (146, 12, 'The Dangs');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (147, 12, 'Gandhinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (148, 12, 'Jamnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (149, 12, 'Junagadh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (150, 12, 'Kutch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (151, 12, 'Kheda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (152, 12, 'Mehsana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (153, 12, 'Narmada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (154, 12, 'Navsari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (155, 12, 'Patan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (156, 12, 'Panchmahal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (157, 12, 'Porbandar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (158, 12, 'Rajkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (159, 12, 'Sabarkantha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (160, 12, 'Surendranagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (161, 12, 'Surat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (162, 12, 'Tapi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (163, 12, 'Vadodara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (164, 12, 'Valsad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (165, 13, 'Ambala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (166, 13, 'Bhiwani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (167, 13, 'Faridabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (168, 13, 'Fatehabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (169, 13, 'Gurgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (170, 13, 'Hissar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (171, 13, 'Jhajjar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (172, 13, 'Jind');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (173, 13, 'Karnal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (174, 13, 'Kaithal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (175, 13, 'Kurukshetra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (176, 13, 'Mahendragarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (177, 13, 'Mewat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (178, 13, 'Palwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (179, 13, 'Panchkula');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (180, 13, 'Panipat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (181, 13, 'Rewari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (182, 13, 'Rohtak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (183, 13, 'Sirsa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (184, 13, 'Sonipat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (185, 13, 'Yamuna Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (186, 14, 'Bilaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (187, 14, 'Chamba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (188, 14, 'Hamirpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (189, 14, 'Kangra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (190, 14, 'Kinnaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (191, 14, 'Kullu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (192, 14, 'Lahaul and Spiti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (193, 14, 'Mandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (194, 14, 'Shimla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (195, 14, 'Sirmaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (196, 14, 'Solan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (197, 14, 'Una');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (198, 15, 'Anantnag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (199, 15, 'Badgam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (200, 15, 'Bandipora');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (201, 15, 'Baramulla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (202, 15, 'Doda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (203, 15, 'Ganderbal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (204, 15, 'Jammu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (205, 15, 'Kargil');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (206, 15, 'Kathua');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (207, 15, 'Kishtwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (208, 15, 'Kupwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (209, 15, 'Kulgam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (210, 15, 'Leh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (211, 15, 'Poonch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (212, 15, 'Pulwama');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (213, 15, 'Rajouri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (214, 15, 'Ramban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (215, 15, 'Reasi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (216, 15, 'Samba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (217, 15, 'Shopian');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (218, 15, 'Srinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (219, 15, 'Udhampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (220, 16, 'Bokaro');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (221, 16, 'Chatra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (222, 16, 'Deoghar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (223, 16, 'Dhanbad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (224, 16, 'Dumka');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (225, 16, 'East Singhbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (226, 16, 'Garhwa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (227, 16, 'Giridih');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (228, 16, 'Godda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (229, 16, 'Gumla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (230, 16, 'Hazaribag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (231, 16, 'Jamtara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (232, 16, 'Khunti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (233, 16, 'Koderma');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (234, 16, 'Latehar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (235, 16, 'Lohardaga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (236, 16, 'Pakur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (237, 16, 'Palamu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (238, 16, 'Ramgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (239, 16, 'Ranchi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (240, 16, 'Sahibganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (241, 16, 'Seraikela Kharsawan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (242, 16, 'Simdega');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (243, 16, 'West Singhbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (244, 17, 'Bagalkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (245, 17, 'Bangalore Rural');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (246, 17, 'Bangalore Urban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (247, 17, 'Belgaum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (248, 17, 'Bellary');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (249, 17, 'Bidar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (250, 17, 'Bijapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (251, 17, 'Chamarajnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (252, 17, 'Chikkamagaluru');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (253, 17, 'Chikkaballapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (254, 17, 'Chitradurga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (255, 17, 'Davanagere');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (256, 17, 'Dharwad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (257, 17, 'Dakshina Kannada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (258, 17, 'Gadag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (259, 17, 'Gulbarga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (260, 17, 'Hassan');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (261, 17, 'Haveri district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (262, 17, 'Kodagu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (263, 17, 'Kolar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (264, 17, 'Koppal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (265, 17, 'Mandya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (266, 17, 'Mysore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (267, 17, 'Raichur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (268, 17, 'Shimoga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (269, 17, 'Tumkur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (270, 17, 'Udupi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (271, 17, 'Uttara Kannada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (272, 17, 'Ramanagara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (273, 17, 'Yadgir');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (274, 18, 'Alappuzha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (275, 18, 'Ernakulam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (276, 18, 'Idukki');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (277, 18, 'Kannur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (278, 18, 'Kasaragod');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (279, 18, 'Kollam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (280, 18, 'Kottayam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (281, 18, 'Kozhikode');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (282, 18, 'Malappuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (283, 18, 'Palakkad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (284, 18, 'Pathanamthitta');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (285, 18, 'Thrissur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (286, 18, 'Thiruvananthapuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (287, 18, 'Wayanad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (288, 19, 'Lakshadweep');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (289, 20, 'Agar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (290, 20, 'Alirajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (291, 20, 'Anuppur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (292, 20, 'Ashok Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (293, 20, 'Balaghat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (294, 20, 'Barwani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (295, 20, 'Betul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (296, 20, 'Bhind');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (297, 20, 'Bhopal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (298, 20, 'Burhanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (299, 20, 'Chhatarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (300, 20, 'Chhindwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (301, 20, 'Damoh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (302, 20, 'Datia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (303, 20, 'Dewas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (304, 20, 'Dhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (305, 20, 'Dindori');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (306, 20, 'Guna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (307, 20, 'Gwalior');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (308, 20, 'Harda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (309, 20, 'Hoshangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (310, 20, 'Indore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (311, 20, 'Jabalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (312, 20, 'Jhabua');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (313, 20, 'Katni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (314, 20, 'Khandwa (East Nimar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (315, 20, 'Khargone (West Nimar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (316, 20, 'Mandla');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (317, 20, 'Mandsaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (318, 20, 'Morena');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (319, 20, 'Narsinghpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (320, 20, 'Neemuch');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (321, 20, 'Panna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (322, 20, 'Raisen');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (323, 20, 'Rajgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (324, 20, 'Ratlam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (325, 20, 'Rewa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (326, 20, 'Sagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (327, 20, 'Satna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (328, 20, 'Sehore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (329, 20, 'Seoni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (330, 20, 'Shahdol');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (331, 20, 'Shajapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (332, 20, 'Sheopur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (333, 20, 'Shivpuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (334, 20, 'Sidhi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (335, 20, 'Singrauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (336, 20, 'Tikamgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (337, 20, 'Ujjain');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (338, 20, 'Umaria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (339, 20, 'Vidisha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (340, 21, 'Ahmednagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (341, 21, 'Akola');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (342, 21, 'Amravati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (343, 21, 'Aurangabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (344, 21, 'Beed');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (345, 21, 'Bhandara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (346, 21, 'Buldhana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (347, 21, 'Chandrapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (348, 21, 'Dhule');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (349, 21, 'Gadchiroli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (350, 21, 'Gondia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (351, 21, 'Hingoli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (352, 21, 'Jalgaon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (353, 21, 'Jalna');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (354, 21, 'Kolhapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (355, 21, 'Latur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (356, 21, 'Mumbai City');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (357, 21, 'Mumbai suburban');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (358, 21, 'Nanded');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (359, 21, 'Nandurbar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (360, 21, 'Nagpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (361, 21, 'Nashik');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (362, 21, 'Osmanabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (363, 21, 'Parbhani');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (364, 21, 'Pune');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (365, 21, 'Raigad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (366, 21, 'Ratnagiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (367, 21, 'Sangli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (368, 21, 'Satara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (369, 21, 'Sindhudurg');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (370, 21, 'Solapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (371, 21, 'Thane');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (372, 21, 'Wardha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (373, 21, 'Washim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (374, 21, 'Yavatmal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (375, 22, 'Bishnupur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (376, 22, 'Churachandpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (377, 22, 'Chandel');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (378, 22, 'Imphal East');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (379, 22, 'Senapati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (380, 22, 'Tamenglong');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (381, 22, 'Thoubal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (382, 22, 'Ukhrul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (383, 22, 'Imphal West');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (384, 23, 'East Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (385, 23, 'East Khasi Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (386, 23, 'Jaintia Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (387, 23, 'Ri Bhoi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (388, 23, 'South Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (389, 23, 'West Garo Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (390, 23, 'West Khasi Hills');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (391, 24, 'Aizawl');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (392, 24, 'Champhai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (393, 24, 'Kolasib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (394, 24, 'Lawngtlai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (395, 24, 'Lunglei');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (396, 24, 'Mamit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (397, 24, 'Saiha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (398, 24, 'Serchhip');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (399, 25, 'Dimapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (400, 25, 'Kiphire');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (401, 25, 'Kohima');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (402, 25, 'Longleng');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (403, 25, 'Mokokchung');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (404, 25, 'Mon');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (405, 25, 'Peren');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (406, 25, 'Phek');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (407, 25, 'Tuensang');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (408, 25, 'Wokha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (409, 25, 'Zunheboto');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (410, 26, 'Angul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (411, 26, 'Boudh (Bauda)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (412, 26, 'Bhadrak');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (413, 26, 'Balangir');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (414, 26, 'Bargarh (Baragarh)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (415, 26, 'Balasore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (416, 26, 'Cuttack');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (417, 26, 'Debagarh (Deogarh)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (418, 26, 'Dhenkanal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (419, 26, 'Ganjam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (420, 26, 'Gajapati');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (421, 26, 'Jharsuguda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (422, 26, 'Jajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (423, 26, 'Jagatsinghpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (424, 26, 'Khordha');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (425, 26, 'Kendujhar (Keonjhar)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (426, 26, 'Kalahandi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (427, 26, 'Kandhamal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (428, 26, 'Koraput');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (429, 26, 'Kendrapara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (430, 26, 'Malkangiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (431, 26, 'Mayurbhanj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (432, 26, 'Nabarangpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (433, 26, 'Nuapada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (434, 26, 'Nayagarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (435, 26, 'Puri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (436, 26, 'Rayagada');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (437, 26, 'Sambalpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (438, 26, 'Subarnapur (Sonepur)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (439, 26, 'Sundergarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (440, 27, 'Karaikal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (441, 27, 'Mahe');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (442, 27, 'Pondicherry');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (443, 27, 'Yanam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (444, 28, 'Amritsar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (445, 28, 'Barnala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (446, 28, 'Bathinda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (447, 28, 'Firozpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (448, 28, 'Faridkot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (449, 28, 'Fatehgarh Sahib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (450, 28, 'Fazilka[6]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (451, 28, 'Gurdaspur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (452, 28, 'Hoshiarpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (453, 28, 'Jalandhar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (454, 28, 'Kapurthala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (455, 28, 'Ludhiana');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (456, 28, 'Mansa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (457, 28, 'Moga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (458, 28, 'Sri Muktsar Sahib');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (459, 28, 'Pathankot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (460, 28, 'Patiala');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (461, 28, 'Rupnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (462, 28, 'Ajitgarh (Mohali)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (463, 28, 'Sangrur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (464, 28, 'Shahid Bhagat Singh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (465, 28, 'Tarn Taran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (466, 29, 'Ajmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (467, 29, 'Alwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (468, 29, 'Bikaner');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (469, 29, 'Barmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (470, 29, 'Banswara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (471, 29, 'Bharatpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (472, 29, 'Baran');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (473, 29, 'Bundi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (474, 29, 'Bhilwara');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (475, 29, 'Churu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (476, 29, 'Chittorgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (477, 29, 'Dausa');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (478, 29, 'Dholpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (479, 29, 'Dungapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (480, 29, 'Ganganagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (481, 29, 'Hanumangarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (482, 29, 'Jhunjhunu');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (483, 29, 'Jalore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (484, 29, 'Jodhpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (485, 29, 'Jaipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (486, 29, 'Jaisalmer');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (487, 29, 'Jhalawar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (488, 29, 'Karauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (489, 29, 'Kota');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (490, 29, 'Nagaur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (491, 29, 'Pali');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (492, 29, 'Pratapgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (493, 29, 'Rajsamand');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (494, 29, 'Sikar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (495, 29, 'Sawai Madhopur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (496, 29, 'Sirohi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (497, 29, 'Tonk');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (498, 29, 'Udaipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (499, 30, 'East Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (500, 30, 'North Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (501, 30, 'South Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (502, 30, 'West Sikkim');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (503, 31, 'Ariyalur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (504, 31, 'Chennai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (505, 31, 'Coimbatore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (506, 31, 'Cuddalore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (507, 31, 'Dharmapuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (508, 31, 'Dindigul');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (509, 31, 'Erode');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (510, 31, 'Kanchipuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (511, 31, 'Kanyakumari');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (512, 31, 'Karur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (513, 31, 'Krishnagiri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (514, 31, 'Madurai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (515, 31, 'Nagapattinam');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (516, 31, 'Nilgiris');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (517, 31, 'Namakkal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (518, 31, 'Perambalur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (519, 31, 'Pudukkottai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (520, 31, 'Ramanathapuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (521, 31, 'Salem');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (522, 31, 'Sivaganga');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (523, 31, 'Tirupur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (524, 31, 'Tiruchirappalli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (525, 31, 'Theni');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (526, 31, 'Tirunelveli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (527, 31, 'Thanjavur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (528, 31, 'Thoothukudi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (529, 31, 'Tiruvallur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (530, 31, 'Tiruvarur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (531, 31, 'Tiruvannamalai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (532, 31, 'Vellore');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (533, 31, 'Viluppuram');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (534, 31, 'Virudhunagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (535, 32, 'Dhalai');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (536, 32, 'North Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (537, 32, 'South Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (538, 32, 'Khowai[7]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (539, 32, 'West Tripura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (540, 33, 'Agra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (541, 33, 'Aligarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (542, 33, 'Allahabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (543, 33, 'Ambedkar Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (544, 33, 'Auraiya');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (545, 33, 'Azamgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (546, 33, 'Bagpat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (547, 33, 'Bahraich');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (548, 33, 'Ballia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (549, 33, 'Balrampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (550, 33, 'Banda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (551, 33, 'Barabanki');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (552, 33, 'Bareilly');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (553, 33, 'Basti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (554, 33, 'Bijnor');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (555, 33, 'Budaun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (556, 33, 'Bulandshahr');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (557, 33, 'Chandauli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (558, 33, 'Chhatrapati Shahuji Maharaj Nagar[8]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (559, 33, 'Chitrakoot');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (560, 33, 'Deoria');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (561, 33, 'Etah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (562, 33, 'Etawah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (563, 33, 'Faizabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (564, 33, 'Farrukhabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (565, 33, 'Fatehpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (566, 33, 'Firozabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (567, 33, 'Gautam Buddh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (568, 33, 'Ghaziabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (569, 33, 'Ghazipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (570, 33, 'Gonda');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (571, 33, 'Gorakhpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (572, 33, 'Hamirpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (573, 33, 'Hardoi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (574, 33, 'Hathras');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (575, 33, 'Jalaun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (576, 33, 'Jaunpur district');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (577, 33, 'Jhansi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (578, 33, 'Jyotiba Phule Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (579, 33, 'Kannauj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (580, 33, 'Kanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (581, 33, 'Kanshi Ram Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (582, 33, 'Kaushambi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (583, 33, 'Kushinagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (584, 33, 'Lakhimpur Kheri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (585, 33, 'Lalitpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (586, 33, 'Lucknow');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (587, 33, 'Maharajganj');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (588, 33, 'Mahoba');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (589, 33, 'Mainpuri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (590, 33, 'Mathura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (591, 33, 'Mau');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (592, 33, 'Meerut');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (593, 33, 'Mirzapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (594, 33, 'Moradabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (595, 33, 'Muzaffarnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (596, 33, 'Panchsheel Nagar district (Hapur)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (597, 33, 'Pilibhit');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (598, 33, 'Pratapgarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (599, 33, 'Raebareli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (600, 33, 'Ramabai Nagar (Kanpur Dehat)');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (601, 33, 'Rampur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (602, 33, 'Saharanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (603, 33, 'Sant Kabir Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (604, 33, 'Sant Ravidas Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (605, 33, 'Shahjahanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (606, 33, 'Shamli[9]');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (607, 33, 'Shravasti');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (608, 33, 'Siddharthnagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (609, 33, 'Sitapur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (610, 33, 'Sonbhadra');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (611, 33, 'Sultanpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (612, 33, 'Unnao');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (613, 33, 'Varanasi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (614, 34, 'Almora');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (615, 34, 'Bageshwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (616, 34, 'Chamoli');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (617, 34, 'Champawat');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (618, 34, 'Dehradun');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (619, 34, 'Haridwar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (620, 34, 'Nainital');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (621, 34, 'Pauri Garhwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (622, 34, 'Pithoragarh');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (623, 34, 'Rudraprayag');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (624, 34, 'Tehri Garhwal');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (625, 34, 'Udham Singh Nagar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (626, 34, 'Uttarkashi');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (627, 35, 'Bankura');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (628, 35, 'Bardhaman');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (629, 35, 'Birbhum');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (630, 35, 'Cooch Behar');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (631, 35, 'Dakshin Dinajpur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (632, 35, 'Darjeeling');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (633, 35, 'Hooghly');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (634, 35, 'Howrah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (635, 35, 'Jalpaiguri');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (636, 35, 'Kolkata');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (637, 35, 'Maldah');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (638, 35, 'Murshidabad');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (639, 35, 'Nadia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (640, 35, 'North 24 Parganas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (641, 35, 'Paschim Medinipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (642, 35, 'Purba Medinipur');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (643, 35, 'Purulia');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (644, 35, 'South 24 Parganas');
INSERT INTO `districts` (`id`, `state_id`, `name`) VALUES (645, 35, 'Uttar Dinajpur');


#
# TABLE STRUCTURE FOR: edd
#

DROP TABLE IF EXISTS `edd`;

CREATE TABLE `edd` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pin` int(11) NOT NULL,
  `esd` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `edd` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `es_days` int(11) NOT NULL,
  `es_hours` time NOT NULL,
  `ed_days` int(11) NOT NULL,
  `ed_hours` time NOT NULL,
  `addon` datetime NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: fund_transfer
#

DROP TABLE IF EXISTS `fund_transfer`;

CREATE TABLE `fund_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AccountName` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `AccountNumber` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ifsc` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resText` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `TxnId` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addon` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `kush` int(11) DEFAULT NULL,
  `wamt` float DEFAULT NULL,
  `utr` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uniq_id` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taddon` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (3, 'T419631', 'REJECT', 'KRISHNA KUMAR', '4890010000876', 'Barb0bhamuz', '300', 'Payment has been Rejected and Refund', '2712953803', '2021-06-09 11:26:37', 2, '300', '', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (5, 'T975959', 'Success', 'RAJAN KUMAR', '46340100002441', 'BARB0BHAMUZ', '670', 'Icici bank', '1544160525', '2021-06-22 10:12:34', 1, '670', '117310274598', '', '2021-06-22 10:22:54');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (6, 'T419631', 'Success', 'KRISHNA KUMAR', '4890010000876', 'Barb0bhamuz', '500', 'Icici bank', '2254788610', '2021-06-23 12:02:46', 1, '500', '117412107889', '', '2021-06-23 12:11:27');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (10, '68554781', 'SUCCESS', 'Gmart', '030605010185', 'ICIC0000306', '84', 'SUCCESS', '20210705010537', '2021-07-05 13:05:39', 1, '84', '118613729356', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (11, '52750067', 'SUCCESS', 'JANKI PHARMA', '50300200000049', 'BARB0MITHAN', '897', 'SUCCESS', '20210705075907', '2021-07-05 19:59:07', 1, '897', '118619489859', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (12, '68554781', 'SUCCESS', 'Gmart', '030605010185', 'ICIC0000306', '100', 'SUCCESS', '20210707035813', '2021-07-07 15:58:15', 1, '100', '118815459202', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (13, '43289158', '0', 'Santosh Art', '39006550381', 'SBIN0001519', '135', 'Accepted', '20210708015703', '2021-07-08 13:57:06', 1, '135', '', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (14, '15373482', 'SUCCESS', 'UMANG CLOTH', '38921126313', 'SBIN0001485', '1246', 'SUCCESS', '20210708061841', '2021-07-08 18:18:42', 1, '1246', '118918585921', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (15, '61376746', 'SUCCESS', 'Sulabh Sweets', '05750510000441', 'UCBA0000575', '250', 'SUCCESS', '20210713103939', '2021-07-13 10:39:41', 1, '250', '119410049414', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (16, '68554781', 'SUCCESS', 'Gmart', '030605010185', 'ICIC0000306', '50', 'SUCCESS', '20210714043720', '2021-07-14 16:37:25', 1, '50', '119516698420', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (17, '26698450', 'SUCCESS', 'Himalayan Drugs ', '30007538992', 'SBIN0001485', '359', 'SUCCESS', '20210715064258', '2021-07-15 18:43:02', 1, '359', '119618938579', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (18, '52750067', 'SUCCESS', 'JANKI PHARMA', '50300200000049', 'BARB0MITHAN', '880', 'SUCCESS', '20210722102211', '2021-07-22 10:22:13', 1, '880', '120310445430', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (19, '61376746', 'SUCCESS', 'Sulabh Sweets', '05750510000441', 'UCBA0000575', '1421', 'SUCCESS', '20210724060921', '2021-07-24 18:09:23', 1, '1421', '120518853646', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (20, '44316746', 'SUCCESS', 'KA Enterprises', '3048000100173296', 'PUNB0304800', '108', 'SUCCESS', '20210727012914', '2021-07-27 13:29:15', 1, '108', '120813435322', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (22, '8084940179', 'SUCCESS', 'Tryit India', '030605010185', 'ICIC0000306', '500', 'SUCCESS', '4479377834', '2021-07-29 17:49:05', 0, '10', '121114188795', '20210730085058', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (23, '68554781', '0', 'Gmart', '030605010185', 'ICIC0000306', '1330', 'Accepted', '20210803041614', '2021-08-03 16:16:16', 1, '1330', '', '', '');
INSERT INTO `fund_transfer` (`id`, `uid`, `status`, `AccountName`, `AccountNumber`, `ifsc`, `amount`, `resText`, `TxnId`, `addon`, `kush`, `wamt`, `utr`, `uniq_id`, `taddon`) VALUES (24, '68554781', '0', 'Gmart', '030605010185', 'ICIC0000306', '10', 'Accepted', '20210804022014', '2021-08-04 14:20:17', 1, '10', '', '', '');


#
# TABLE STRUCTURE FOR: level
#

DROP TABLE IF EXISTS `level`;

CREATE TABLE `level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(111) NOT NULL,
  `member` int(11) NOT NULL,
  `dsp` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `amt` int(11) NOT NULL,
  `prize` varchar(999) NOT NULL,
  `levelp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=latin1;

INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (1, 'Beiggner', 10, 1, 30, 20, 'T-Shirt', 1);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (2, 'Runner', 60, 2, 30, 30, 'Dinner Set', 2);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (3, 'Booster', 160, 3, 30, 40, 'Mobile', 3);
INSERT INTO `level` (`id`, `name`, `member`, `dsp`, `day`, `amt`, `prize`, `levelp`) VALUES (4, 'Bronze', 360, 5, 30, 90, 'LED TV', 4);


#
# TABLE STRUCTURE FOR: lottry
#

DROP TABLE IF EXISTS `lottry`;

CREATE TABLE `lottry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lottry_no` varchar(999) NOT NULL,
  `uid` varchar(999) NOT NULL,
  `amt` varchar(999) NOT NULL,
  `lgroup` varchar(999) NOT NULL,
  `addon` varchar(999) NOT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: message
#

DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` varchar(111) NOT NULL,
  `user` varchar(111) NOT NULL,
  `pass` varchar(111) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  `att` int(11) NOT NULL,
  `dtt` int(11) NOT NULL,
  `dutt` int(11) NOT NULL,
  `pay` int(11) NOT NULL,
  `sms` int(11) NOT NULL,
  `registration` int(11) NOT NULL,
  `enquery` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `message` (`id`, `sender_id`, `user`, `pass`, `addon`, `status`, `att`, `dtt`, `dutt`, `pay`, `sms`, `registration`, `enquery`) VALUES (1, '', '', '', '2019-07-05 07:24:00', 0, 1, 1, 1, 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: order1
#

DROP TABLE IF EXISTS `order1`;

CREATE TABLE `order1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `uid` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `pname` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `size` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `mrp` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `qty` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `total` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `totals` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `pt` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `pmode` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `mop` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `top` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `utr` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `addon` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: orders1
#

DROP TABLE IF EXISTS `orders1`;

CREATE TABLE `orders1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `uid` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `pname` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `size` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `mrp` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `pv` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `qty` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `total` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `totalpv` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `totals` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `tpv` varchar(11) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `addon` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

#
# TABLE STRUCTURE FOR: passbook
#

DROP TABLE IF EXISTS `passbook`;

CREATE TABLE `passbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `debit` varchar(999) DEFAULT NULL,
  `credit` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `pstatus` int(11) DEFAULT NULL,
  `pdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=479 DEFAULT CHARSET=latin1;

INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (1, '7050096409', 'Add Wallet by Paytm', '0', '1.00', '2021-07-20 20:39:50', 0, 0, '2021-07-20 15:09:50', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (2, '9939195269', 'Add Wallet by Paytm', '0', '14.7', '2021-07-21 09:02:44', 0, 0, '2021-07-21 03:32:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (3, '9939090087', 'Cash Wallet by Admin', '0', '718', '2021-07-21 15:44:41', 0, 0, '2021-07-21 10:14:41', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (4, '9939090087', 'Recharge Income', NULL, '0.735', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (5, '9939195269', 'Recharge Income 2 9939090087', NULL, '0.2205', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (6, '8084940179', 'Recharge Income 3 9939090087', NULL, '0.0735', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (7, '', 'Recharge Income 4 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (8, '', 'Recharge Income 5 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (9, '', 'Recharge Income 6 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (10, '', 'Recharge Income 7 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (11, '', 'Recharge Income 8 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (12, '', 'Recharge Income 9 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (13, '', 'Recharge Income 10 9939090087', NULL, '0.055125', '2021-07-21 17:43:27', NULL, NULL, '2021-07-21 12:13:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (14, '9939090087', 'Recharge Income', NULL, '0.585', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (15, '9939195269', 'Recharge Income 2 9939090087', NULL, '0.1755', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (16, '8084940179', 'Recharge Income 3 9939090087', NULL, '0.0585', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (17, '', 'Recharge Income 4 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (18, '', 'Recharge Income 5 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (19, '', 'Recharge Income 6 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (20, '', 'Recharge Income 7 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (21, '', 'Recharge Income 8 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (22, '', 'Recharge Income 9 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (23, '', 'Recharge Income 10 9939090087', NULL, '0.043875', '2021-07-21 17:51:07', NULL, NULL, '2021-07-21 12:21:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (24, '8084562474', 'Cash Wallet by Admin', '0', '3.94', '2021-07-21 19:28:09', 0, 0, '2021-07-21 13:58:09', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (25, '8092221370', 'Add Wallet by Paytm', '0', '1.00', '2021-07-23 20:27:31', 0, 0, '2021-07-23 14:57:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (26, '8092221370', 'Add Wallet by Paytm', '0', '1.00', '2021-07-24 04:12:24', 0, 0, '2021-07-23 22:42:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (27, '7004983144', 'Add Wallet by Paytm', '0', '9.8', '2021-07-24 07:04:03', 0, 0, '2021-07-24 01:34:03', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (28, '8084940179', 'Cash Wallet by Admin', '0', '1500', '2021-07-24 18:05:01', 0, 0, '2021-07-24 12:35:01', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (29, '8084940179', 'Transfer To Shop ID-61376746', '1500', '0', '2021-07-24 18:05:36', 0, 0, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (30, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (31, '8084940179', 'Repurchage Self Income', NULL, '60', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (32, '', 'Repurchage Income 1 8084940179', NULL, '12', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (33, NULL, 'Repurchage Income 2 8084940179', NULL, '6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (34, NULL, 'Repurchage Income 3 8084940179', NULL, '6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (35, '', 'Repurchage Income 4 8084940179', NULL, '6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (36, '', 'Repurchage Income 5 8084940179', NULL, '6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (37, '', 'Repurchage Income 6 8084940179', NULL, '3.6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (38, '', 'Repurchage Income 7 8084940179', NULL, '3.6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (39, '', 'Repurchage Income 8 8084940179', NULL, '3.6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (40, '', 'Repurchage Income 9 8084940179', NULL, '3.6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (41, '', 'Repurchage Income 10 8084940179', NULL, '3.6', '2021-07-24 18:05:36', NULL, NULL, '2021-07-24 12:35:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (42, '7277977659', 'Add Wallet by Paytm', '0', '10.00', '2021-07-25 13:24:40', 0, 0, '2021-07-25 07:54:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (43, '7277977659', 'Cash Wallet by Admin', '0', '249.73', '2021-07-26 07:42:52', 0, 0, '2021-07-26 02:12:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (44, '8235175667', 'Cash Wallet by Admin', '0', '434.40', '2021-07-26 07:43:57', 0, 0, '2021-07-26 02:13:57', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (45, '7992259617', 'Cash Wallet by Admin', '0', '291', '2021-07-26 07:51:33', 0, 0, '2021-07-26 02:21:33', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (46, '8210687557', 'Cash Wallet by Admin', '0', '85.94', '2021-07-26 07:59:48', 0, 0, '2021-07-26 02:29:48', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (47, '6207574162', 'Cash Wallet by Admin', '0', '54', '2021-07-26 08:00:17', 0, 0, '2021-07-26 02:30:17', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (48, '9798067920', 'Cash Wallet by Admin', '0', '2.36', '2021-07-26 08:00:57', 0, 0, '2021-07-26 02:30:57', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (49, '8084940179', 'Add Wallet by Paytm', '0', '20.00', '2021-07-26 08:07:49', 0, 0, '2021-07-26 02:37:49', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (50, '8210179625', 'Cash Wallet by Admin', '0', '242.36', '2021-07-26 11:15:48', 0, 0, '2021-07-26 05:45:48', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (51, '7371815641', 'Cash Wallet by Admin', '0', '43.90', '2021-07-26 11:16:47', 0, 0, '2021-07-26 05:46:47', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (52, '8936058495', 'Cash Wallet by Admin', '0', '51', '2021-07-26 11:25:32', 0, 0, '2021-07-26 05:55:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (53, '7369882648', 'Add Wallet by Paytm', '0', '196', '2021-07-26 11:58:24', 0, 0, '2021-07-26 06:28:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (54, '7369882648', 'Recharge Income', NULL, '2.235', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (55, '8210179625', 'Recharge Income 2 7369882648', NULL, '0.6705', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (56, '7979030395', 'Recharge Income 3 7369882648', NULL, '0.2235', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (57, '9939195269', 'Recharge Income 4 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (58, '8084940179', 'Recharge Income 5 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (59, '', 'Recharge Income 6 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (60, '', 'Recharge Income 7 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (61, '', 'Recharge Income 8 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (62, '', 'Recharge Income 9 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (63, '', 'Recharge Income 10 7369882648', NULL, '0.167625', '2021-07-26 12:13:30', NULL, NULL, '2021-07-26 06:43:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (64, '8084940179', 'Transfer To Shop ID-44316746', '120', '0', '2021-07-27 13:01:08', 0, 0, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (65, '9939195269', 'Repurchage Sponsor Income 44316746', NULL, '0', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (66, '8084940179', 'Repurchage Self Income', NULL, '4.8', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (67, '', 'Repurchage Income 1 8084940179', NULL, '0.96', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (68, NULL, 'Repurchage Income 2 8084940179', NULL, '0.48', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (69, NULL, 'Repurchage Income 3 8084940179', NULL, '0.48', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (70, '', 'Repurchage Income 4 8084940179', NULL, '0.48', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (71, '', 'Repurchage Income 5 8084940179', NULL, '0.48', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (72, '', 'Repurchage Income 6 8084940179', NULL, '0.288', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (73, '', 'Repurchage Income 7 8084940179', NULL, '0.288', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (74, '', 'Repurchage Income 8 8084940179', NULL, '0.288', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (75, '', 'Repurchage Income 9 8084940179', NULL, '0.288', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (76, '', 'Repurchage Income 10 8084940179', NULL, '0.288', '2021-07-27 13:01:08', NULL, NULL, '2021-07-27 07:31:08', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (77, '7562026045', 'Add Wallet by Paytm', '0', '10.00', '2021-07-28 09:36:44', 0, 0, '2021-07-28 04:06:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (78, '6386476787', 'Add Wallet by Paytm', '0', '40.00', '2021-07-28 13:07:23', 0, 0, '2021-07-28 07:37:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (79, '6386476787', 'Recharge Income', NULL, '0.315', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (80, '9918508019', 'Recharge Income 2 6386476787', NULL, '0.0945', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (81, '9939195269', 'Recharge Income 3 6386476787', NULL, '0.0315', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (82, '8084940179', 'Recharge Income 4 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (83, '', 'Recharge Income 5 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (84, '', 'Recharge Income 6 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (85, '', 'Recharge Income 7 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (86, '', 'Recharge Income 8 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (87, '', 'Recharge Income 9 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (88, '', 'Recharge Income 10 6386476787', NULL, '0.023625', '2021-07-28 13:23:50', NULL, NULL, '2021-07-28 07:54:05', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (89, '7992241588', 'Add Wallet by Paytm', '0', '10.00', '2021-07-29 13:05:21', 0, 0, '2021-07-29 07:35:21', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (90, '7992241588', 'Add Wallet by Paytm', '0', '10.00', '2021-07-29 13:05:34', 0, 0, '2021-07-29 07:35:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (91, '7992241588', 'Transfer To Shop ID-99305265', '20', '0', '2021-07-29 13:08:32', 0, 0, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (92, '8102811241', 'Repurchage Sponsor Income 99305265', NULL, '0', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (93, '7992241588', 'Repurchage Self Income', NULL, '2.4', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (94, '8235175667', 'Repurchage Income 1 7992241588', NULL, '0.48', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (95, '6204143525', 'Repurchage Income 2 7992241588', NULL, '0.24', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (96, '6201847968', 'Repurchage Income 3 7992241588', NULL, '0.24', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (97, '8873749286', 'Repurchage Income 4 7992241588', NULL, '0.24', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (98, '8102811241', 'Repurchage Income 5 7992241588', NULL, '0.24', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (99, '9122894111', 'Repurchage Income 6 7992241588', NULL, '0.144', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (100, '7979030395', 'Repurchage Income 7 7992241588', NULL, '0.144', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (101, '9939195269', 'Repurchage Income 8 7992241588', NULL, '0.144', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (102, '8084940179', 'Repurchage Income 9 7992241588', NULL, '0.144', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (103, '', 'Repurchage Income 10 7992241588', NULL, '0.144', '2021-07-29 13:08:32', NULL, NULL, '2021-07-29 07:38:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (112, '9939195269', 'Recharge Income', NULL, '2.985', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (111, '6201847968', 'Add Wallet by Paytm ORDS8627502', '0', '10.00', '2021-07-29 13:55:28', 0, 0, '2021-07-29 08:25:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (106, '8084940179', 'Add Wallet by Paytm', '0', '10.00', '2021-07-29 13:18:04', 0, 0, '2021-07-29 07:48:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (107, '6204143525', 'Add Wallet by Paytm', '0', '100.00', '2021-07-29 13:19:40', 0, 0, '2021-07-29 07:49:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (108, '8084940179', 'Add Wallet by Paytm ORDS67472637', '0', '1.00', '2021-07-29 13:35:36', 0, 0, '2021-07-29 08:05:36', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (109, '8084940179', 'Add Wallet by Paytm ORDS59728783', '0', '1.00', '2021-07-29 13:37:39', 0, 0, '2021-07-29 08:07:39', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (110, '8084940179', 'Add Wallet by Paytm ORDS32775581', '0', '1.00', '2021-07-29 13:38:47', 0, 0, '2021-07-29 08:08:47', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (113, '8084940179', 'Recharge Income 2 9939195269', NULL, '0.8955', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (114, '', 'Recharge Income 3 9939195269', NULL, '0.2985', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (115, NULL, 'Recharge Income 4 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (116, '', 'Recharge Income 5 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (117, '', 'Recharge Income 6 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (118, '', 'Recharge Income 7 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (119, '', 'Recharge Income 8 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (120, '', 'Recharge Income 9 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (121, '', 'Recharge Income 10 9939195269', NULL, '0.223875', '2021-07-29 14:06:32', NULL, NULL, '2021-07-29 08:36:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (122, '9939195269', 'Wallet to UID-7004983144-Abhishek Sharma', '2', '0', '2021-07-29 16:41:27', 0, 0, '2021-07-29 11:11:27', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (123, '7004983144', 'Wallet from -9939195269-Manoj Sharma', '0', '1', '2021-07-29 16:41:27', 0, 0, '2021-07-29 11:11:27', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (124, '8084940179', 'Wallet to UID-9939195269-Manoj Sharma', '2', '0', '2021-07-29 16:44:17', 0, 0, '2021-07-29 11:14:17', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (125, '9939195269', 'Wallet from -8084940179-Tryit India', '0', '1', '2021-07-29 16:44:17', 0, 0, '2021-07-29 11:14:17', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (126, '8010221234', 'Add Wallet by Paytm ORDS66673587', '0', '100.00', '2021-07-29 18:22:50', 0, 0, '2021-07-29 12:52:50', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (127, '9939195269', 'Cash Wallet by Admin', '0', '300', '2021-07-30 08:05:49', 0, 0, '2021-07-30 02:35:49', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (128, '9939195269', 'Transfer To Shop ID-61376746', '280', '0', '2021-07-30 08:07:52', 0, 0, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (129, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (130, '9939195269', 'Repurchage Self Income', NULL, '11.2', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (131, '8084940179', 'Repurchage Income 1 9939195269', NULL, '2.24', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (132, '', 'Repurchage Income 2 9939195269', NULL, '1.12', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (133, NULL, 'Repurchage Income 3 9939195269', NULL, '1.12', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (134, '', 'Repurchage Income 4 9939195269', NULL, '1.12', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (135, '', 'Repurchage Income 5 9939195269', NULL, '1.12', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (136, '', 'Repurchage Income 6 9939195269', NULL, '0.672', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (137, '', 'Repurchage Income 7 9939195269', NULL, '0.672', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (138, '', 'Repurchage Income 8 9939195269', NULL, '0.672', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (139, '', 'Repurchage Income 9 9939195269', NULL, '0.672', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (140, '', 'Repurchage Income 10 9939195269', NULL, '0.672', '2021-07-30 08:07:52', NULL, NULL, '2021-07-30 02:37:52', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (141, '8210179625', 'Recharge Income', NULL, '2.985', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (142, '7979030395', 'Recharge Income 2 8210179625', NULL, '0.8955', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (143, '9939195269', 'Recharge Income 3 8210179625', NULL, '0.2985', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (144, '8084940179', 'Recharge Income 4 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (145, '', 'Recharge Income 5 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (146, '', 'Recharge Income 6 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (147, '', 'Recharge Income 7 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (148, '', 'Recharge Income 8 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (149, '', 'Recharge Income 9 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (150, '', 'Recharge Income 10 8210179625', NULL, '0.223875', '2021-07-30 08:41:50', NULL, NULL, '2021-07-30 03:12:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (151, '8010221234', 'Transfer To Shop ID-26698450', '18', '0', '2021-07-30 18:06:13', 0, 0, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (152, '', 'Repurchage Sponsor Income 26698450', NULL, '0', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (153, '8010221234', 'Repurchage Self Income', NULL, '0.72', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (154, '9835153380', 'Repurchage Income 1 8010221234', NULL, '0.144', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (155, '9939195269', 'Repurchage Income 2 8010221234', NULL, '0.072', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (156, '8084940179', 'Repurchage Income 3 8010221234', NULL, '0.072', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (157, '', 'Repurchage Income 4 8010221234', NULL, '0.072', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (158, '', 'Repurchage Income 5 8010221234', NULL, '0.072', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (159, '', 'Repurchage Income 6 8010221234', NULL, '0.0432', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (160, '', 'Repurchage Income 7 8010221234', NULL, '0.0432', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (161, '', 'Repurchage Income 8 8010221234', NULL, '0.0432', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (162, '', 'Repurchage Income 9 8010221234', NULL, '0.0432', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (163, '', 'Repurchage Income 10 8010221234', NULL, '0.0432', '2021-07-30 18:06:13', NULL, NULL, '2021-07-30 12:36:13', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (164, '6386476787', 'Add Wallet by Paytm ORDS56344921', '0', '100.00', '2021-07-31 12:30:44', 0, 0, '2021-07-31 07:00:44', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (165, '6386476787', 'Recharge Income', NULL, '0.75', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (166, '9918508019', 'Recharge Income 2 6386476787', NULL, '0.225', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (167, '9939195269', 'Recharge Income 3 6386476787', NULL, '0.075', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (168, '8084940179', 'Recharge Income 4 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (169, '', 'Recharge Income 5 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (170, '', 'Recharge Income 6 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (171, '', 'Recharge Income 7 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (172, '', 'Recharge Income 8 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (173, '', 'Recharge Income 9 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (174, '', 'Recharge Income 10 6386476787', NULL, '0.05625', '2021-07-31 12:31:45', NULL, NULL, '2021-07-31 07:01:58', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (368, '', 'Recharge Income 8 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (367, '', 'Recharge Income 7 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (366, '', 'Recharge Income 6 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (178, '6386476787', 'Recharge Income', NULL, '0.765', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (179, '9918508019', 'Recharge Income 2 6386476787', NULL, '0.2295', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (180, '9939195269', 'Recharge Income 3 6386476787', NULL, '0.0765', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (181, '8084940179', 'Recharge Income 4 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (182, '', 'Recharge Income 5 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (183, '', 'Recharge Income 6 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (184, '', 'Recharge Income 7 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (185, '', 'Recharge Income 8 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (186, '', 'Recharge Income 9 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (187, '', 'Recharge Income 10 6386476787', NULL, '0.057375', '2021-07-31 20:08:29', NULL, NULL, '2021-07-31 14:38:40', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (188, '9142836671', 'Add Wallet by Paytm ORDS9659731', '0', '10.00', '2021-08-01 07:48:07', 0, 0, '2021-08-01 02:18:07', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (365, '', 'Recharge Income 5 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (364, '', 'Recharge Income 4 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (192, '7371815641', 'Recharge Income', NULL, '0.165', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (193, '7369882648', 'Recharge Income 2 7371815641', NULL, '0.0495', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (194, '8210179625', 'Recharge Income 3 7371815641', NULL, '0.0165', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (195, '7979030395', 'Recharge Income 4 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (196, '9939195269', 'Recharge Income 5 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (197, '8084940179', 'Recharge Income 6 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (198, '', 'Recharge Income 7 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (199, '', 'Recharge Income 8 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (200, '', 'Recharge Income 9 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (201, '', 'Recharge Income 10 7371815641', NULL, '0.012375', '2021-08-01 18:33:37', NULL, NULL, '2021-08-01 13:03:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (202, '9939195269', 'Transfer To Shop ID-61376746', '40', '0', '2021-08-01 19:31:32', 0, 0, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (203, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (204, '9939195269', 'Repurchage Self Income', NULL, '1.6', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (205, '8084940179', 'Repurchage Income 1 9939195269', NULL, '0.32', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (206, '', 'Repurchage Income 2 9939195269', NULL, '0.16', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (207, NULL, 'Repurchage Income 3 9939195269', NULL, '0.16', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (208, '', 'Repurchage Income 4 9939195269', NULL, '0.16', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (209, '', 'Repurchage Income 5 9939195269', NULL, '0.16', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (210, '', 'Repurchage Income 6 9939195269', NULL, '0.096', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (211, '', 'Repurchage Income 7 9939195269', NULL, '0.096', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (212, '', 'Repurchage Income 8 9939195269', NULL, '0.096', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (213, '', 'Repurchage Income 9 9939195269', NULL, '0.096', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (214, '', 'Repurchage Income 10 9939195269', NULL, '0.096', '2021-08-01 19:31:32', NULL, NULL, '2021-08-01 14:01:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (215, '9939090087', 'Recharge Income', NULL, '0.735', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (216, '9939195269', 'Recharge Income 2 9939090087', NULL, '0.2205', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (217, '8084940179', 'Recharge Income 3 9939090087', NULL, '0.0735', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (218, '', 'Recharge Income 4 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (219, '', 'Recharge Income 5 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (220, '', 'Recharge Income 6 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (221, '', 'Recharge Income 7 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (222, '', 'Recharge Income 8 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (223, '', 'Recharge Income 9 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (224, '', 'Recharge Income 10 9939090087', NULL, '0.055125', '2021-08-02 08:30:52', NULL, NULL, '2021-08-02 03:00:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (363, '8084940179', 'Recharge Income 3 9939090087', NULL, '0.03', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (362, '9939195269', 'Recharge Income 2 9939090087', NULL, '0.09', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (361, '9939090087', 'Recharge Income', NULL, '0.3', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (228, '8084940179', 'Share Holder Income', NULL, '1', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (229, '9939195269', 'Leader Ship Income', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (230, '9939195269', 'Delevry Commission', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (231, '9097027327', 'Self Repurchage Income', NULL, '5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (232, '9939195269', 'Repurchage Income Level 1 9097027327', NULL, '1', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (233, '8084940179', 'Repurchage Income Level 2 9097027327', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (234, '', 'Repurchage Income Level 3 9097027327', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (235, '', 'Repurchage Income Level 4 9097027327', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (236, '', 'Repurchage Income Level 5 9097027327', NULL, '0.5', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (237, '', 'Repurchage Income Level 6 9097027327', NULL, '0.3', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (238, '', 'Repurchage Income Level 7 9097027327', NULL, '0.3', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (239, '', 'Repurchage Income Level 8 9097027327', NULL, '0.3', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (240, '', 'Repurchage Income Level 9 9097027327', NULL, '0.3', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (241, '', 'Repurchage Income Level 10 9097027327', NULL, '0.3', '2021-08-03 14:58:12', NULL, NULL, '2021-08-03 09:28:12', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (242, '8084940179', 'Share Holder Income', NULL, '18.7', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (243, '9939195269', 'Leader Ship Income', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (244, '9939195269', 'Delevry Commission', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (245, '9835153380', 'Self Repurchage Income', NULL, '93.5', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (246, '9939195269', 'Repurchage Income Level 1 9835153380', NULL, '18.7', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (247, '8084940179', 'Repurchage Income Level 2 9835153380', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (248, '', 'Repurchage Income Level 3 9835153380', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (249, '', 'Repurchage Income Level 4 9835153380', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (250, '', 'Repurchage Income Level 5 9835153380', NULL, '9.35', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (251, '', 'Repurchage Income Level 6 9835153380', NULL, '5.61', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (252, '', 'Repurchage Income Level 7 9835153380', NULL, '5.61', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (253, '', 'Repurchage Income Level 8 9835153380', NULL, '5.61', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (254, '', 'Repurchage Income Level 9 9835153380', NULL, '5.61', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (255, '', 'Repurchage Income Level 10 9835153380', NULL, '5.61', '2021-08-03 15:43:14', NULL, NULL, '2021-08-03 10:13:14', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (256, '9939195269', 'Cash Wallet by Admin', '0', '2000', '2021-08-03 16:09:19', 0, 0, '2021-08-03 10:39:19', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (257, '9939195269', 'Transfer To Shop ID-68554781', '1920', '0', '2021-08-03 16:13:25', 0, 0, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (258, 'T450008', 'Repurchage Sponsor Income 68554781', NULL, '24', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (259, '9939195269', 'Repurchage Self Income', NULL, '288', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (260, '8084940179', 'Repurchage Income 1 9939195269', NULL, '57.6', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (261, '', 'Repurchage Income 2 9939195269', NULL, '28.8', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (262, NULL, 'Repurchage Income 3 9939195269', NULL, '28.8', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (263, '', 'Repurchage Income 4 9939195269', NULL, '28.8', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (264, '', 'Repurchage Income 5 9939195269', NULL, '28.8', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (265, '', 'Repurchage Income 6 9939195269', NULL, '17.28', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (266, '', 'Repurchage Income 7 9939195269', NULL, '17.28', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (267, '', 'Repurchage Income 8 9939195269', NULL, '17.28', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (268, '', 'Repurchage Income 9 9939195269', NULL, '17.28', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (269, '', 'Repurchage Income 10 9939195269', NULL, '17.28', '2021-08-03 16:13:25', NULL, NULL, '2021-08-03 10:43:25', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (270, '9939195269', 'Invest Sponsor Income 8210687557', NULL, '500', '2021-08-03 14:12:51', NULL, NULL, '2021-08-03 14:12:51', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (271, '8084940179', 'Invest Income 2 8210687557', NULL, '300', '2021-08-03 14:12:51', NULL, NULL, '2021-08-06 12:54:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (272, '', 'Invest Income 3 8210687557', NULL, '200', '2021-08-03 14:12:51', NULL, NULL, '2021-08-06 12:54:37', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (273, '7992259617', 'Recharge Income', NULL, '0.15', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (274, '9939195269', 'Recharge Income 2 7992259617', NULL, '0.045', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (275, '8084940179', 'Recharge Income 3 7992259617', NULL, '0.015', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (276, '', 'Recharge Income 4 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (277, '', 'Recharge Income 5 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (278, '', 'Recharge Income 6 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (279, '', 'Recharge Income 7 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (280, '', 'Recharge Income 8 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (281, '', 'Recharge Income 9 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (282, '', 'Recharge Income 10 7992259617', NULL, '0.01125', '2021-08-04 13:19:15', NULL, NULL, '2021-08-04 07:49:30', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (283, '7992259617', 'Recharge Income', NULL, '0.15', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (284, '9939195269', 'Recharge Income 2 7992259617', NULL, '0.045', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (285, '8084940179', 'Recharge Income 3 7992259617', NULL, '0.015', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (286, '', 'Recharge Income 4 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (287, '', 'Recharge Income 5 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (288, '', 'Recharge Income 6 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (289, '', 'Recharge Income 7 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (290, '', 'Recharge Income 8 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (291, '', 'Recharge Income 9 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (292, '', 'Recharge Income 10 7992259617', NULL, '0.01125', '2021-08-04 13:19:53', NULL, NULL, '2021-08-04 07:50:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (293, '9939195269', 'Transfer To Shop ID-61376746', '200', '0', '2021-08-04 17:54:45', 0, 0, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (294, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (295, '9939195269', 'Repurchage Self Income', NULL, '8', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (296, '8084940179', 'Repurchage Income 1 9939195269', NULL, '1.6', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (297, '', 'Repurchage Income 2 9939195269', NULL, '0.8', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (298, NULL, 'Repurchage Income 3 9939195269', NULL, '0.8', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (299, '', 'Repurchage Income 4 9939195269', NULL, '0.8', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (300, '', 'Repurchage Income 5 9939195269', NULL, '0.8', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (301, '', 'Repurchage Income 6 9939195269', NULL, '0.48', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (302, '', 'Repurchage Income 7 9939195269', NULL, '0.48', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (303, '', 'Repurchage Income 8 9939195269', NULL, '0.48', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (304, '', 'Repurchage Income 9 9939195269', NULL, '0.48', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (305, '', 'Repurchage Income 10 9939195269', NULL, '0.48', '2021-08-04 17:54:45', NULL, NULL, '2021-08-04 12:24:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (306, '8084940179', 'Transfer To Shop ID-68554781', '10', '0', '2021-08-04 22:40:00', 0, 0, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (307, 'T450008', 'Repurchage Sponsor Income 68554781', NULL, '0.125', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (308, '8084940179', 'Repurchage Self Income', NULL, '1.5', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (309, '', 'Repurchage Income 1 8084940179', NULL, '0.3', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (310, NULL, 'Repurchage Income 2 8084940179', NULL, '0.15', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (311, NULL, 'Repurchage Income 3 8084940179', NULL, '0.15', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (312, '', 'Repurchage Income 4 8084940179', NULL, '0.15', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (313, '', 'Repurchage Income 5 8084940179', NULL, '0.15', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (314, '', 'Repurchage Income 6 8084940179', NULL, '0.09', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (315, '', 'Repurchage Income 7 8084940179', NULL, '0.09', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (316, '', 'Repurchage Income 8 8084940179', NULL, '0.09', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (317, '', 'Repurchage Income 9 8084940179', NULL, '0.09', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (318, '', 'Repurchage Income 10 8084940179', NULL, '0.09', '2021-08-04 22:40:00', NULL, NULL, '2021-08-04 17:10:00', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (319, '9939195269', 'Invest Sponsor Income 9939090087', NULL, '250', '2021-08-05 09:45:57', NULL, NULL, '2021-08-05 09:45:57', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (320, '8084940179', 'Invest Income 2 9939090087', NULL, '150', '2021-08-05 09:45:57', NULL, NULL, '2021-08-06 12:54:42', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (321, '', 'Invest Income 3 9939090087', NULL, '100', '2021-08-05 09:45:57', NULL, NULL, '2021-08-06 12:54:47', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (322, '8936064895', 'Invest Sponsor Income 9905222899', NULL, '250', '2021-08-05 13:56:41', NULL, NULL, '2021-08-05 13:56:41', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (323, '8936058495', 'Invest Income 2 9905222899', NULL, '150', '2021-08-05 13:56:41', NULL, NULL, '2021-08-06 12:54:57', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (324, '8210179625', 'Invest Income 3 9905222899', NULL, '100', '2021-08-05 13:56:41', NULL, NULL, '2021-08-06 12:55:01', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (325, '8084940179', 'Transfer To Shop ID-61376746', '120', '0', '2021-08-06 09:33:34', 0, 0, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (326, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (327, '8084940179', 'Repurchage Self Income', NULL, '4.8', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (328, '', 'Repurchage Income 1 8084940179', NULL, '0.96', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (329, NULL, 'Repurchage Income 2 8084940179', NULL, '0.48', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (330, NULL, 'Repurchage Income 3 8084940179', NULL, '0.48', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (331, '', 'Repurchage Income 4 8084940179', NULL, '0.48', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (332, '', 'Repurchage Income 5 8084940179', NULL, '0.48', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (333, '', 'Repurchage Income 6 8084940179', NULL, '0.288', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (334, '', 'Repurchage Income 7 8084940179', NULL, '0.288', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (335, '', 'Repurchage Income 8 8084940179', NULL, '0.288', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (336, '', 'Repurchage Income 9 8084940179', NULL, '0.288', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (337, '', 'Repurchage Income 10 8084940179', NULL, '0.288', '2021-08-06 09:33:34', NULL, NULL, '2021-08-06 04:03:34', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (338, '8084940179', 'Transfer To Shop ID-61376746', '125', '0', '2021-08-06 16:35:29', 0, 0, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (339, '', 'Repurchage Sponsor Income 61376746', NULL, '0', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (340, '8084940179', 'Repurchage Self Income', NULL, '5', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (341, '', 'Repurchage Income 1 8084940179', NULL, '1', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (342, NULL, 'Repurchage Income 2 8084940179', NULL, '0.5', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (343, NULL, 'Repurchage Income 3 8084940179', NULL, '0.5', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (344, '', 'Repurchage Income 4 8084940179', NULL, '0.5', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (345, '', 'Repurchage Income 5 8084940179', NULL, '0.5', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (346, '', 'Repurchage Income 6 8084940179', NULL, '0.3', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (347, '', 'Repurchage Income 7 8084940179', NULL, '0.3', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (348, '', 'Repurchage Income 8 8084940179', NULL, '0.3', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (349, '', 'Repurchage Income 9 8084940179', NULL, '0.3', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (350, '', 'Repurchage Income 10 8084940179', NULL, '0.3', '2021-08-06 16:35:29', NULL, NULL, '2021-08-06 11:05:29', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (351, '8084940179', 'Recharge Income', NULL, '2.235', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (352, '', 'Recharge Income 2 8084940179', NULL, '0.6705', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (353, NULL, 'Recharge Income 3 8084940179', NULL, '0.2235', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (354, NULL, 'Recharge Income 4 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (355, '', 'Recharge Income 5 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (356, '', 'Recharge Income 6 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (357, '', 'Recharge Income 7 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (358, '', 'Recharge Income 8 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (359, '', 'Recharge Income 9 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (360, '', 'Recharge Income 10 8084940179', NULL, '0.167625', '2021-08-06 16:53:46', NULL, NULL, '2021-08-06 11:23:59', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (369, '', 'Recharge Income 9 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (370, '', 'Recharge Income 10 9939090087', NULL, '0.0225', '2021-08-07 12:48:22', NULL, NULL, '2021-08-07 07:18:31', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (371, '6386476787', 'Add Wallet by Paytm ORDS1284301', '0', '400.00', '2021-08-08 10:52:11', 0, 0, '2021-08-08 05:22:11', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (372, '6386476787', 'Recharge Income', NULL, '2.235', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (373, '9918508019', 'Recharge Income 2 6386476787', NULL, '0.6705', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (374, '9939195269', 'Recharge Income 3 6386476787', NULL, '0.2235', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (375, '8084940179', 'Recharge Income 4 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (376, '', 'Recharge Income 5 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (377, '', 'Recharge Income 6 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (378, '', 'Recharge Income 7 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (379, '', 'Recharge Income 8 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (380, '', 'Recharge Income 9 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (381, '', 'Recharge Income 10 6386476787', NULL, '0.167625', '2021-08-08 15:24:05', NULL, NULL, '2021-08-08 09:54:16', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (382, '6386476787', 'Recharge Income', NULL, '2.985', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (383, '9918508019', 'Recharge Income 2 6386476787', NULL, '0.8955', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (384, '9939195269', 'Recharge Income 3 6386476787', NULL, '0.2985', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (385, '8084940179', 'Recharge Income 4 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (386, '', 'Recharge Income 5 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (387, '', 'Recharge Income 6 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (388, '', 'Recharge Income 7 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (389, '', 'Recharge Income 8 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (390, '', 'Recharge Income 9 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (391, '', 'Recharge Income 10 6386476787', NULL, '0.223875', '2021-08-08 15:34:21', NULL, NULL, '2021-08-08 10:04:28', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (392, '9792465464', 'Add Wallet by Paytm ORDS47881343', '0', '555.00', '2021-08-10 15:39:07', 0, 0, '2021-08-10 10:09:07', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (393, '8084940179', 'Share Holder Income', NULL, '1.860000038147', '2021-08-10 15:57:04', NULL, NULL, '2021-08-10 10:27:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (394, '9939195269', 'Leader Ship Income', NULL, '0.93000001907349', '2021-08-10 15:57:04', NULL, NULL, '2021-08-10 10:27:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (395, '9835153380', 'Self Repurchage Income', NULL, '9.300000190734863', '2021-08-10 15:57:04', NULL, NULL, '2021-08-10 10:27:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (396, '9939195269', 'Repurchage Income Level 1 9835153380', NULL, '1.860000038147', '2021-08-10 15:57:04', NULL, NULL, '2021-08-10 10:27:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (397, '8084940179', 'Repurchage Income Level 2 9835153380', NULL, '0.93000001907349', '2021-08-10 15:57:04', NULL, NULL, '2021-08-10 10:27:04', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (398, '9792465464', 'Recharge Income', NULL, '8.325', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (399, '6386476787', 'Recharge Income 2 9792465464', NULL, '2.4975', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (400, '9918508019', 'Recharge Income 3 9792465464', NULL, '0.8325', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (401, '9939195269', 'Recharge Income 4 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (402, '8084940179', 'Recharge Income 5 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (403, '', 'Recharge Income 6 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (404, '', 'Recharge Income 7 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (405, '', 'Recharge Income 8 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (406, '', 'Recharge Income 9 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (407, '', 'Recharge Income 10 9792465464', NULL, '0.624375', '2021-08-10 16:28:10', NULL, NULL, '2021-08-10 10:58:24', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (408, '8084940179', 'Recharge Income', NULL, '1.935', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (409, '', 'Recharge Income 2 8084940179', NULL, '0.5805', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (410, NULL, 'Recharge Income 3 8084940179', NULL, '0.1935', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (411, NULL, 'Recharge Income 4 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (412, '', 'Recharge Income 5 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (413, '', 'Recharge Income 6 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (414, '', 'Recharge Income 7 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (415, '', 'Recharge Income 8 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (416, '', 'Recharge Income 9 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (417, '', 'Recharge Income 10 8084940179', NULL, '0.145125', '2021-08-11 08:36:46', NULL, NULL, '2021-08-11 03:06:55', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (418, '8052330561', 'Add Wallet by Paytm ORDS14563599', '0', '1000.00', '2021-08-11 10:05:26', 0, 0, '2021-08-11 04:35:26', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (419, '8052330561', 'Recharge Income', NULL, '1.875', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (420, '8419020475', 'Recharge Income 2 8052330561', NULL, '0.5625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (421, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.1875', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (422, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (423, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (424, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (425, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (426, '', 'Recharge Income 8 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (427, '', 'Recharge Income 9 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (428, '', 'Recharge Income 10 8052330561', NULL, '0.140625', '2021-08-11 11:43:38', NULL, NULL, '2021-08-11 06:13:53', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (429, '8052330561', 'Recharge Income', NULL, '3.735', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (430, '8419020475', 'Recharge Income 2 8052330561', NULL, '1.1205', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (431, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.3735', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (432, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (433, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (434, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (435, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (436, '', 'Recharge Income 8 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (437, '', 'Recharge Income 9 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (438, '', 'Recharge Income 10 8052330561', NULL, '0.280125', '2021-08-11 14:57:40', NULL, NULL, '2021-08-11 09:27:45', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (439, '8052330561', 'Recharge Income', NULL, '1.185', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (440, '8419020475', 'Recharge Income 2 8052330561', NULL, '0.3555', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (441, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.1185', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (442, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (443, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (444, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (445, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (446, '', 'Recharge Income 8 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (447, '', 'Recharge Income 9 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (448, '', 'Recharge Income 10 8052330561', NULL, '0.088875', '2021-08-11 15:30:11', NULL, NULL, '2021-08-11 10:00:23', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (449, '8052330561', 'Recharge Income', NULL, '2.985', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (450, '8419020475', 'Recharge Income 2 8052330561', NULL, '0.8955', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (451, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.2985', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (452, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (453, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (454, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (455, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (456, '', 'Recharge Income 8 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:32', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (457, '', 'Recharge Income 9 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:33', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (458, '', 'Recharge Income 10 8052330561', NULL, '0.223875', '2021-08-11 16:05:22', NULL, NULL, '2021-08-11 10:35:33', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (459, '8052330561', 'Recharge Income', NULL, '2.235', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (460, '8419020475', 'Recharge Income 2 8052330561', NULL, '0.6705', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (461, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.2235', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (462, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (463, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (464, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (465, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (466, '', 'Recharge Income 8 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (467, '', 'Recharge Income 9 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (468, '', 'Recharge Income 10 8052330561', NULL, '0.167625', '2021-08-11 17:58:01', NULL, NULL, '2021-08-11 12:28:10', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (469, '8052330561', 'Recharge Income', NULL, '2.235', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (470, '8419020475', 'Recharge Income 2 8052330561', NULL, '0.6705', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (471, '7860683831', 'Recharge Income 3 8052330561', NULL, '0.2235', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (472, '6386476787', 'Recharge Income 4 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (473, '9918508019', 'Recharge Income 5 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (474, '9939195269', 'Recharge Income 6 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (475, '8084940179', 'Recharge Income 7 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (476, '', 'Recharge Income 8 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (477, '', 'Recharge Income 9 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);
INSERT INTO `passbook` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `type`) VALUES (478, '', 'Recharge Income 10 8052330561', NULL, '0.167625', '2021-08-12 17:31:48', NULL, NULL, '2021-08-12 12:02:02', 0);


#
# TABLE STRUCTURE FOR: passbook1
#

DROP TABLE IF EXISTS `passbook1`;

CREATE TABLE `passbook1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `debit` float DEFAULT NULL,
  `credit` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `pstatus` int(11) DEFAULT NULL,
  `pdate` varchar(55) NOT NULL,
  `product` varchar(99) DEFAULT NULL,
  `txnid` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (1, '9939090087', 'Recharge to 9471076314', '49', '0', '2021-07-21 17:43:27', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (2, '9939090087', 'Recharge to 9708853302', '39', '0', '2021-07-21 17:51:07', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (3, '7369882648', 'Recharge to 8319184846', '149', '0', '2021-07-26 12:13:30', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (4, '6386476787', 'Recharge to 6386476787', '21', '0', '2021-07-28 13:23:50', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (5, '9939195269', 'Recharge to 7979030395', '199', '0', '2021-07-29 14:06:32', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (6, '8210179625', 'Recharge to 8210179625', '199', '0', '2021-07-30 08:41:50', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (7, '6386476787', 'Recharge to 8957031054', '50', '0', '2021-07-31 12:31:45', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (8, '6386476787', 'Recharge to 6386476787', '51', '0', '2021-07-31 20:08:29', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (9, '7371815641', 'Recharge to 7371815641', '11', '0', '2021-08-01 18:33:37', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (10, '9939090087', 'Recharge to 6209764476', '49', '0', '2021-08-02 08:30:52', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (11, '7992259617', 'Recharge to 9471042473', '10', '0', '2021-08-04 13:19:15', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (12, '7992259617', 'Recharge to 9031212699', '10', '0', '2021-08-04 13:19:53', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (13, '8084940179', 'Recharge to 8102689164', '149', '0', '2021-08-06 16:53:46', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (14, '9939090087', 'Recharge to 9939090087', '20', '0', '2021-08-07 12:48:22', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (15, '6386476787', 'Recharge to 7752864405', '149', '0', '2021-08-08 15:24:05', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (16, '6386476787', 'Recharge to 8418895400', '199', '0', '2021-08-08 15:34:21', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (17, '9792465464', 'Recharge to 6386476787', '555', '0', '2021-08-10 16:28:10', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (18, '8084940179', 'Recharge to 8084940179', '129', '0', '2021-08-11 08:36:46', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (19, '8052330561', 'Recharge to 6265757348', '125', '0', '2021-08-11 11:43:38', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (20, '8052330561', 'Recharge to 6389250677', '249', '0', '2021-08-11 14:57:40', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (21, '8052330561', 'Recharge to 9519602189', '79', '0', '2021-08-11 15:30:11', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (22, '8052330561', 'Recharge to 6386279579', '199', '0', '2021-08-11 16:05:22', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (23, '8052330561', 'Recharge to 7390013447', '149', '0', '2021-08-11 17:58:01', 0, 0, '', NULL, '');
INSERT INTO `passbook1` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`, `txnid`) VALUES (24, '8052330561', 'Recharge to 6261708460', '149', '0', '2021-08-12 17:31:48', 0, 0, '', NULL, '');


#
# TABLE STRUCTURE FOR: passbook3
#

DROP TABLE IF EXISTS `passbook3`;

CREATE TABLE `passbook3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `debit` float DEFAULT NULL,
  `credit` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `pstatus` int(11) DEFAULT NULL,
  `pdate` varchar(55) NOT NULL,
  `product` varchar(99) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `passbook3` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`) VALUES (1, '8084940179', 'Transfer to Bank Account', '500', '0', '2021-07-29 17:43:02', 0, 0, '', NULL);
INSERT INTO `passbook3` (`id`, `uid`, `note`, `debit`, `credit`, `addon`, `status`, `pstatus`, `pdate`, `product`) VALUES (2, '8084940179', 'Transfer to Bank Account', '500', '0', '2021-07-29 17:49:05', 0, 0, '', NULL);


#
# TABLE STRUCTURE FOR: passbook4
#

DROP TABLE IF EXISTS `passbook4`;

CREATE TABLE `passbook4` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(111) DEFAULT NULL,
  `note` varchar(111) DEFAULT NULL,
  `debit` float DEFAULT NULL,
  `credit` float DEFAULT NULL,
  `addon` varchar(99) NOT NULL,
  `status` int(11) DEFAULT NULL,
  `pstatus` int(11) DEFAULT NULL,
  `pdate` varchar(55) NOT NULL,
  `product` varchar(99) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payment
#

DROP TABLE IF EXISTS `payment`;

CREATE TABLE `payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mob` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `t_ad` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amt` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `txnid` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: payout
#

DROP TABLE IF EXISTS `payout`;

CREATE TABLE `payout` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `day2` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payout1
#

DROP TABLE IF EXISTS `payout1`;

CREATE TABLE `payout1` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `day2` int(11) NOT NULL,
  `level` varchar(111) DEFAULT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: payout2
#

DROP TABLE IF EXISTS `payout2`;

CREATE TABLE `payout2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `amt` int(11) NOT NULL,
  `day` int(11) NOT NULL,
  `day2` int(11) NOT NULL,
  `level` varchar(111) DEFAULT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  `fuid` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: paytm
#

DROP TABLE IF EXISTS `paytm`;

CREATE TABLE `paytm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `order_id` varchar(999) NOT NULL,
  `mode` varchar(999) NOT NULL,
  `amt` varchar(999) NOT NULL,
  `status` int(11) NOT NULL,
  `addon` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=latin1;

INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (1, 'ADMIN', 'ORDS95564129', '', '10', 0, '2021-07-14 02:23:05');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (2, 'ADMIN', 'ORDS18158579', '', '10', 0, '2021-07-14 02:24:04');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (3, 'ADMIN', 'ORDS46580012', '', '', 0, '2021-07-14 02:27:22');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (4, 'ADMIN', 'ORDS54678170', '', '10', 0, '2021-07-14 02:30:31');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (5, 'ADMIN', 'ORDS6131181', '', '1', 0, '2021-07-14 02:31:49');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (6, 'ADMIN', 'ORDS58113946', '', '1', 0, '2021-07-14 02:34:01');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (7, 'ADMIN', 'ORDS36158222', 'UPI', '1', 1, '2021-07-14 02:36:30');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (8, 'ADMIN', 'ORDS6256528', 'UPI', '1', 1, '2021-07-14 03:02:02');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (9, 'ADMIN', 'ORDS48400264', '', '1', 0, '2021-07-14 03:04:59');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (10, 'ADMIN', 'ORDS59294832', 'UPI', '1', 1, '2021-07-14 03:08:10');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (11, 'ADMIN', 'ORDS36590871', 'UPI', '5', 1, '2021-07-14 03:11:12');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (12, 'ADMIN', 'ORDS87334525', 'UPI', '1', 1, '2021-07-14 03:18:46');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (13, 'ADMIN', 'ORDS23517146', 'PPI', '1', 1, '2021-07-14 03:34:39');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (14, 'ADMIN', 'ORDS72510342', 'UPI', '1', 1, '2021-07-14 03:37:22');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (15, 'ADMIN', 'ORDS23207775', '', '', 0, '2021-07-14 03:40:29');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (16, 'T429805', 'ORDS54132394', 'PPI', '1', 1, '2021-07-14 03:40:29');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (17, 'ADMIN', 'ORDS47834391', '', '1', 0, '2021-07-14 03:40:57');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (18, 'T429805', 'ORDS7548818', '', '1', 0, '2021-07-14 03:51:06');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (19, 'T296557', 'ORDS42503554', '', '1', 0, '2021-07-14 03:51:42');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (20, 'T429805', 'ORDS18226425', '', '1', 0, '2021-07-14 03:57:10');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (21, 'T429805', 'ORDS63240730', '', '1', 0, '2021-07-14 04:01:08');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (22, 'T296557', 'ORDS49524321', '', '1', 0, '2021-07-14 04:01:26');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (23, 'ADMIN', 'ORDS47030396', '', '1', 0, '2021-07-14 04:02:13');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (24, 'ADMIN', 'ORDS44510397', '', '1', 0, '2021-07-14 04:06:05');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (25, 'ADMIN', 'ORDS18234595', '', '1', 0, '2021-07-14 04:07:04');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (26, 'T296557', 'ORDS90968333', '', '1', 0, '2021-07-14 04:11:47');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (27, 'ADMIN', 'ORDS63793699', '', '1', 0, '2021-07-14 05:28:40');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (28, 'ADMIN', 'ORDS16201267', '', '1', 0, '2021-07-14 05:40:10');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (29, '9939195269', 'ORDS64857795', '', '1', 0, '2021-07-18 01:34:24');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (30, '7979030395', 'ORDS36037297', '', '100', 0, '2021-07-19 07:29:34');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (31, '9939195269', 'ORDS27135281', '', '10', 0, '2021-07-19 09:40:32');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (32, '7050096409', 'ORDS74619271', 'UPI', '1', 1, '2021-07-20 08:39:03');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (33, '9939195269', 'ORDS75092586', '', '15', 0, '2021-07-21 09:00:01');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (34, '9939195269', 'ORDS77136921', 'PPI', '15', 1, '2021-07-21 09:02:06');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (35, '8084940179', 'ORDS44499652', '', '15', 0, '2021-07-21 02:17:12');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (36, '8084940179', 'ORDS81639176', '', '100', 0, '2021-07-22 11:07:34');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (37, '8340289850', 'ORDS27599814', '', '10', 0, '2021-07-22 03:38:06');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (38, '8092221370', 'ORDS42143667', 'UPI', '1', 1, '2021-07-23 08:26:15');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (39, '7004983144', 'ORDS931904', 'NB', '10', 1, '2021-07-24 07:03:12');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (40, '9939090087', 'ORDS80130453', '', '', 0, '2021-07-24 01:20:17');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (41, '9939090087', 'ORDS5170426', '', '10', 0, '2021-07-24 01:46:58');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (42, '6386476787', 'ORDS69908813', '', '100', 0, '2021-07-25 01:22:55');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (43, '7277977659', 'ORDS39913675', 'UPI', '10', 1, '2021-07-25 01:23:16');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (44, '8102811241', 'ORDS56703129', '', '10', 0, '2021-07-25 01:44:30');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (45, '8084940179', 'ORDS36228810', 'UPI', '20', 1, '2021-07-26 08:06:50');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (46, '7079700793', 'ORDS87038293', '', '100', 0, '2021-07-26 10:16:35');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (47, '7369882648', 'ORDS92607201', 'PPI', '200', 1, '2021-07-26 11:56:26');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (48, '7369882648', 'ORDS69330018', '', '200', 0, '2021-07-26 12:06:15');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (49, '8083760428', 'ORDS23482013', '', '10', 0, '2021-07-27 01:36:23');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (50, '7562026045', 'ORDS74633241', '', '10', 0, '2021-07-28 09:27:41');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (51, '7562026045', 'ORDS58508982', 'UPI', '10', 1, '2021-07-28 09:35:25');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (52, '6386476787', 'ORDS92017151', 'UPI', '40', 1, '2021-07-28 01:05:14');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (53, '8789638761', 'ORDS11084877', '', '10', 0, '2021-07-29 10:43:14');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (54, '7992241588', 'ORDS15029119', '', '100', 0, '2021-07-29 01:03:20');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (55, '7992241588', 'ORDS35375847', 'UPI', '10', 1, '2021-07-29 01:03:45');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (56, '6204143525', 'ORDS77369843', 'UPI', '100', 1, '2021-07-29 01:15:36');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (57, '8084940179', 'ORDS38473925', 'UPI', '10', 1, '2021-07-29 01:17:06');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (58, '6204143525', 'ORDS77487365', '', '50', 0, '2021-07-29 01:21:05');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (59, '8084940179', 'ORDS70993971', '', '10', 0, '2021-07-29 01:23:07');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (60, '8084940179', 'ORDS17409621', '', '10', 0, '2021-07-29 01:27:31');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (61, '8084940179', 'ORDS23359172', '', '10', 0, '2021-07-29 01:29:34');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (62, '8084940179', 'ORDS67472637', 'UPI', '1', 1, '2021-07-29 01:34:48');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (63, '8084940179', 'ORDS59728783', 'UPI', '1', 1, '2021-07-29 01:37:06');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (64, '8084940179', 'ORDS32775581', 'UPI', '1', 1, '2021-07-29 01:38:19');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (65, '6201847968', 'ORDS8627502', 'UPI', '10', 1, '2021-07-29 01:52:58');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (66, '6201847968', 'ORDS26826435', '', '', 0, '2021-07-29 01:59:28');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (67, '8010221234', 'ORDS66673587', 'UPI', '100', 1, '2021-07-29 06:20:49');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (68, '6386476787', 'ORDS56344921', 'UPI', '100', 1, '2021-07-31 12:29:20');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (69, '9031291591', 'ORDS85184325', '', '1', 0, '2021-07-31 04:16:13');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (70, '6386476787', 'ORDS48029570', '', '30', 0, '2021-07-31 08:03:51');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (71, '6386476787', 'ORDS92658379', '', '30', 0, '2021-07-31 08:05:59');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (72, '9142836671', 'ORDS18192289', '', '10', 0, '2021-08-01 07:41:26');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (73, '9142836671', 'ORDS34808283', '', '10', 0, '2021-08-01 07:43:24');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (74, '9142836671', 'ORDS35222370', '', '10', 0, '2021-08-01 07:45:33');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (75, '9142836671', 'ORDS9659731', 'UPI', '10', 1, '2021-08-01 07:46:32');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (76, '7004233679', 'ORDS92567448', '', '10', 0, '2021-08-01 09:15:50');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (77, '9939197125', 'ORDS24898171', '', '100', 0, '2021-08-01 02:15:47');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (78, '9142768216', 'ORDS21937255', '', '10', 0, '2021-08-06 08:01:20');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (79, '6386476787', 'ORDS24236997', '', '400', 0, '2021-08-08 09:30:57');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (80, '6386476787', 'ORDS1497866', '', '400', 0, '2021-08-08 09:32:41');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (81, '6386476787', 'ORDS43883776', '', '400', 0, '2021-08-08 09:37:16');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (82, '6386476787', 'ORDS1284301', 'UPI', '400', 1, '2021-08-08 10:50:21');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (83, '7860683831', 'ORDS2540221', '', '', 0, '2021-08-08 03:40:37');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (84, '7860683831', 'ORDS92380531', '', '5', 0, '2021-08-08 03:40:45');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (85, '7860683831', 'ORDS93687439', '', '5', 0, '2021-08-08 03:42:18');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (86, '8419020475', 'ORDS74305789', '', '500', 0, '2021-08-08 03:49:42');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (87, '6386476787', 'ORDS86699589', '', '300', 0, '2021-08-10 11:33:03');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (88, '9792465464', 'ORDS47881343', 'UPI', '555', 1, '2021-08-10 03:37:39');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (89, '8052330561', 'ORDS14563599', 'UPI', '1000', 1, '2021-08-11 10:04:08');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (90, '9305903970', 'ORDS61306709', '', '5000', 0, '2021-08-11 12:24:25');
INSERT INTO `paytm` (`id`, `uid`, `order_id`, `mode`, `amt`, `status`, `addon`) VALUES (91, '8299506513', 'ORDS78047705', '', '50', 0, '2021-08-11 05:45:13');


#
# TABLE STRUCTURE FOR: plan
#

DROP TABLE IF EXISTS `plan`;

CREATE TABLE `plan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `plan_b` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_c` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_d` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan2` int(11) NOT NULL,
  `plan3` int(11) NOT NULL,
  `plan4` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `plan` (`id`, `plan_b`, `plan_c`, `plan_d`, `plan2`, `plan3`, `plan4`) VALUES (1, '', '', '', 1, 1, 1);


#
# TABLE STRUCTURE FOR: product
#

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `p_name` varchar(111) NOT NULL,
  `mrp` varchar(111) NOT NULL,
  `pv` varchar(111) NOT NULL,
  `sponsor` varchar(111) NOT NULL,
  `capping` int(11) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(111) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO `product` (`id`, `p_name`, `mrp`, `pv`, `sponsor`, `capping`, `addon`, `type`, `status`) VALUES (14, 'MRP 150', '150', '1', '100', 4, '2020-05-20 19:30:08', 'Type 1', 0);
INSERT INTO `product` (`id`, `p_name`, `mrp`, `pv`, `sponsor`, `capping`, `addon`, `type`, `status`) VALUES (16, 'MRP 610', '610', '0', '0', 10, '2020-06-05 20:13:39', 'Type 3', 0);
INSERT INTO `product` (`id`, `p_name`, `mrp`, `pv`, `sponsor`, `capping`, `addon`, `type`, `status`) VALUES (26, 'MRP 1800', '1800', '', '', 0, '2021-04-08 07:36:16', '', 0);


#
# TABLE STRUCTURE FOR: products
#

DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pname` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `size` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `mrp` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL,
  `pv` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(999) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (2, 'JGS SEA BUCKTHORN JUICE', '500 ML', '1499.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (3, 'HALDI POWDER', '100 GMS', '25.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (4, 'RED CHILLIE POWDER', '100 GMS', '29.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (5, 'GARAM MASALA', '100 GMS', '53.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (6, 'SHAHI CHICKEN MASALA', '100 GMS', '72.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (7, 'DHABA MEAT MASALA', '100 GMS', '72.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (8, 'NAMKEEN CHHAT MASALA', '100 GMS', '24.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (9, 'HALDI POWDER', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (10, 'HALDI POWDER', '200 GMS', '48.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (11, 'HALDI POWDER', '500 GMS', '115.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (12, 'RED CHILLIE POWDER', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (13, 'RED CHILLIE POWDER', '200 GMS', '56.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (14, 'DHANIA POWDER', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (15, 'DHANIA POWDER', '100 GMS', '23.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (16, 'SABJI MASALA', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (17, 'SABJI MASALA', '100 GMS', '62.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (18, 'CHANA MASALA', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (19, 'CHANA MASALA', '100 GMS', '63.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (20, 'KITCHEN KING MASALA', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (21, 'KITCHEN KING MASALA', '100 GMS', '53.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (22, 'GARAM MASALA', '09 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (23, 'DHABA MEAT MASALA', '09 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (24, 'SHAHI CHICKEN MASALA', '09 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (25, 'MADHUBANI FISH CURRY MASALA', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (26, 'MADHUBANI FISH CURRY MASALA', '250 GMS', '125.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (27, 'DEGG KI MIRCH', '12 GMS', '5.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (28, 'DEGG KI MIRCH', '100 GMS', '59.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (29, 'JEERA SABUT', '100 GMS', '50.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (30, 'AJWAIN', '100 GMS', '57.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (31, 'KASHMIRI MIRCH POWDER', '100 GMS', '54.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (32, 'HYDERABADI DUM BIRYANI MASALA', '50 GMS', '70.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (33, 'TEA MASALA', '50 GMS', '38.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (34, 'CHICKEN MOMO MASALA', '50 GMS', '35.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (35, 'AMRITASARI PINDI CHHOLE MASALE', '100 GMS', '51.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (36, 'SHAHI PANEER MASALA', '50 GMS', '30.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (37, 'ANDHRA RASAM MASALA', '50 GMS', '30.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (38, 'LAKHNAVI KORMA MASALA', '50 GMS', '45.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (39, 'TANDOORI CHHAT MASALA', '50 GMS', '30.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (40, 'PUCHAKA MASALA', '50 GMS', '37.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (41, 'ADARAK POWDER', '50 GMS', '29.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (42, 'KALA NAMAK', '100 GMS', '12.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (43, 'SENDHA NAMAK', '1 KG', '45.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (44, 'KASOORI METHI', '50 GMS', '31.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (45, 'KASOORI METHI', '100 GMS', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (46, 'RAJAMA MASALA', '50 GMS', '30.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (47, 'BODY LOTION', '200 ML', '150.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (48, 'SCRUB', '50 GMS', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (49, 'SCEUB', '10 GMS', '12.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (50, 'FACE PACK', '50 GMS', '66.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (51, 'ROSE MIST TONER', '100 ML', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (52, 'CLEASING MILK', '100 ML', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (53, 'MASSAGE GEL', '50 GMS', '57.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (54, 'N & C  SHAMPOO', '120 ML', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (55, 'CLEARE SCALP ANTI HAIR FALL SHAMPOO', '120 ML', '60.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (56, 'SHOWER GEL PINK LOTUS', '110 ML', '55.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (57, 'SHOWER GEL STRABERRY', '110 ML', '55.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (58, 'SHOWER GEL WHITE MUSK', '110 ML', '55.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (59, 'SHOWER GEL LAVENDER', '110 ML', '55.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (60, 'HAND WASH PEACH', '500 ML', '105.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (61, 'HAND WASH ORANGE', '500 ML', '105.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (62, 'NAURASHING HAIR OIL', '100 ML', '50.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (63, 'NAURASHING HAIR OIL', '3 ML', '1.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (64, 'COOL OIL', '100 ML', '50.00', 0, '', '1');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (65, 'SOAP SWISS LAVENDER', '100 GMS', '40.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (66, 'WHITE SOAP', '40 GMS', '10.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (67, 'JGS CHARCOAL SOAP', '100 GMS', '115.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (68, 'JGS ALOVERA FACE WASH', '100 ML', '140.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (69, 'JGS CHARCOAL FACE WASH', '100 ML', '157.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (70, 'JGS TOILET CLEANER', '500 ML', '86.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (71, 'JGS BATHROOM CLEANER', '500 ML', '108', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (72, 'JGS DISH WASH', '200 ML', '77.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (73, 'HI TECH LOCK', '1 PIS', '1349.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (74, 'JGS TULSI', '20 ML', '189.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (75, 'JGS SANJIVANI RAS', '30 M;', '279.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (76, 'PROTINE POWDER', '200 GMS', '345.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (77, 'PROTIMEY', '200 GMS', '315.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (78, 'JGS GHAS TEL', '50 ML', '315.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (79, 'MUSALI CAPSULES', '60 PIS', '531.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (80, 'ASHWAGANDHA CAPSULES', '60 PIS', '306.00', 0, '', '0');
INSERT INTO `products` (`id`, `pname`, `size`, `mrp`, `type`, `pv`, `status`) VALUES (81, 'SHILAJIT CAPSULES', '60 PIS', '531.00', 0, '', '0');


#
# TABLE STRUCTURE FOR: recharge
#

DROP TABLE IF EXISTS `recharge`;

CREATE TABLE `recharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `number` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `oprator` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rrmarks` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txnid` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `addon` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bal` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (2, 'ADMIN', '9006865562', '6', '10', '', '', '1', '6350946065', '2021-05-20 20:52:33', '');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (3, 'ADMIN', '7255818469', '6', '10', 'SUCCESS', 'Recharge done successfully', '1', '6794411489', '2021-05-21 09:26:39', '');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (4, 'T288452', '7763996210', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '8038448774', '2021-05-24 21:54:35', '948.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (5, 'T288452', '9973061120', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '3856516436', '2021-05-24 22:12:52', '899.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (6, 'T758095', '8604357100', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '9977897168', '2021-05-25 06:52:29', '850.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (7, 'T786475', '9939874262', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '5779157762', '2021-05-29 08:50:36', '801.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (8, 'T429805', '9470027202', '37', '118', 'SUCCESS', 'Recharge done successfully', '1', '7654528546', '2021-05-30 14:20:18', '683.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (9, 'T478838', '8210179625', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '9767603024', '2021-06-01 07:50:54', '484.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (10, 'ADMIN', '7979030395', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '2264493000', '2021-06-03 11:12:45', '285.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (11, 'T288452', '8877686886', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '3403499876', '2021-06-04 15:36:04', '236.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (12, 'T419631', '6204767802', '15', '75', 'SUCCESS', 'Recharge done successfully', '1', '6842655719', '2021-06-04 19:28:35', '161.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (13, 'T296557', '7033280505', '37', '99', 'SUCCESS', 'Recharge done successfully', '1', '8586267527', '2021-06-07 16:21:36', '1100.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (14, 'T419631', '8235175667', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '3330575197', '2021-06-08 20:19:21', '1051.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (15, 'ADMIN', '7255818469', '6', '49', 'SUCCESS', 'Recharge done successfully', '1', '7982857245', '2021-06-09 09:33:47', '1002.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (16, 'T443025', '9451853046', '7', '75', 'SUCCESS', 'Recharge done successfully', '1', '9537876603', '2021-06-09 20:21:38', '927.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (17, 'T443025', '8543065516', '21', '149', 'SUCCESS', 'Recharge done successfully', '1', '6424838684', '2021-06-10 17:24:42', '778.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (18, 'T296557', '8544193889', '37', '106', 'SUCCESS', 'Recharge done successfully', '1', '9055909857', '2021-06-17 10:25:02', '672.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (19, 'T296557', '9155996999', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '8212709148', '2021-06-17 11:05:30', '623.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (20, 'ADMIN', '9122894111', '2', '129', 'SUCCESS', 'Recharge done successfully', '1', '3373573055', '2021-06-18 13:53:29', '494.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (21, 'T296557', '7992259617', '15', '21', 'SUCCESS', 'Recharge done successfully', '1', '3009558511', '2021-06-19 14:47:56', '473.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (22, 'T786475', '7004370005', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '2005300680', '2021-06-24 19:22:02', '274.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (23, 'T429805', '9470027202', '37', '118', 'SUCCESS', 'Recharge done successfully', '1', '7854599690', '2021-06-28 17:10:38', '156.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (24, 'T296557', '7033280505', '37', '118', 'SUCCESS', 'Recharge done successfully', '1', '7406651150', '2021-06-29 11:45:38', '38.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (25, 'T975959', '7277977659', '15', '149', 'SUCCESS', 'Recharge done successfully', '1', '4750875946', '2021-06-29 22:01:46', '927.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (26, 'T478838', '8210179625', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '4304090576', '2021-06-30 08:04:08', '728.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (27, 'T429805', '3017380754', '4', '100', 'SUCCESS', 'Recharge done successfully', '2', '5676237382', '2021-06-30 11:21:16', '628.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (28, 'ADMIN', '7979030395', '15', '21', 'SUCCESS', 'Recharge done successfully', '1', '6681930698', '2021-06-30 17:07:45', '607.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (29, 'ADMIN', '7979030395', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '8485913240', '2021-07-01 11:42:11', '408.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (30, 'T925378', '9199352019', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '4830394988', '2021-07-01 15:56:34', '359.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (31, 'T290834', '8084562474', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '1631645270', '2021-07-01 16:19:42', '310.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (32, 'T686636', '7004983144', '15', '599', 'SUCCESS', 'Recharge done successfully', '1', '8729572358', '2021-07-02 11:09:23', '749.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (33, 'T296557', '7979750839', '15', '149', 'SUCCESS', 'Recharge done successfully', '1', '4179453154', '2021-07-03 09:54:05', '600.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (34, 'T429805', '7979750839', '15', '21', 'SUCCESS', 'Recharge done successfully', '1', '7489113921', '2021-07-03 11:39:50', '579.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (35, 'T290834', '6202145567', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '2228025708', '2021-07-03 11:59:37', '380.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (36, 'T662640', '7654353455', '6', '219', 'SUCCESS', 'Recharge done successfully', '1', '7439339091', '2021-07-03 20:58:30', '161.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (37, 'T419631', '8235175667', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '4005955562', '2021-07-03 21:20:31', '112.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (38, 'T662640', '6201911709', '15', '98', 'SUCCESS', 'Recharge done successfully', '1', '5438245574', '2021-07-04 17:32:45', '2090.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (39, 'T296557', '9473276227', '37', '13', 'SUCCESS', 'Recharge done successfully', '1', '6885322269', '2021-07-07 17:19:07', '2077.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (40, '9798067920', '3005550948', '4', '375', 'SUCCESS', 'Recharge done successfully', '2', '8666607680', '2021-07-12 13:34:09', '1702.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (41, '9798067920', '7367043080', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '8958599969', '2021-07-13 21:08:25', '1653.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (42, 'T429805', '7033280715', '37', '49', 'SUCCESS', 'Recharge done successfully', '1', '9339027423', '2021-07-15 09:44:02', '1604.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (43, '8084940179', '9122894111', '2', '129', 'SUCCESS', 'Recharge done successfully', '1', '8527859145', '2021-07-17 18:20:15', '1475.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (44, '9939195269', '9199352019', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '7701177331', '2021-07-18 15:15:47', '1426.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (45, '9939195269', '9262535948', '2', '49', 'SUCCESS', 'Recharge done successfully', '1', '5279751949', '2021-07-18 15:16:46', '1377.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (46, '9939090087', '9471076314', '7', '49', 'SUCCESS', 'Recharge done successfully', '1', '2563364998', '2021-07-21 17:43:27', '1328.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (47, '9939090087', '9708853302', '6', '39', 'SUCCESS', 'Recharge done successfully', '1', '9812919488', '2021-07-21 17:51:07', '1289.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (48, '7369882648', '8319184846', '15', '149', 'SUCCESS', 'Recharge done successfully', '1', '7520300412', '2021-07-26 12:13:30', '1140.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (49, '6386476787', '6386476787', '15', '21', 'SUCCESS', 'Recharge done successfully', '1', '2871168369', '2021-07-28 13:23:50', '1119.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (50, '9939195269', '7979030395', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '9030374501', '2021-07-29 14:06:32', '920.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (51, '8210179625', '8210179625', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '8781503855', '2021-07-30 08:41:50', '721.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (52, '6386476787', '8957031054', '21', '50', 'SUCCESS', 'Recharge done successfully', '1', '2258645443', '2021-07-31 12:31:45', '671.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (53, '6386476787', '6386476787', '15', '51', 'SUCCESS', 'Recharge done successfully', '1', '7284897270', '2021-07-31 20:08:29', '620.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (54, '7371815641', '7371815641', '15', '11', 'SUCCESS', 'Recharge done successfully', '1', '9669916798', '2021-08-01 18:33:37', '609.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (55, '9939090087', '6209764476', '6', '49', 'SUCCESS', 'Recharge done successfully', '1', '6732113891', '2021-08-02 08:30:52', '560.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (56, '7992259617', '9471042473', '7', '10', 'SUCCESS', 'Recharge done successfully', '1', '3904660942', '2021-08-04 13:19:15', '550.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (57, '7992259617', '9031212699', '7', '10', 'SUCCESS', 'Recharge done successfully', '1', '8031390383', '2021-08-04 13:19:53', '540.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (58, '8084940179', '8102689164', '15', '149', 'SUCCESS', 'Recharge done successfully', '1', '5443569205', '2021-08-06 16:53:46', '391.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (59, '9939090087', '9939090087', '2', '20', 'SUCCESS', 'Recharge done successfully', '1', '5438153861', '2021-08-07 12:48:22', '371.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (60, '6386476787', '7752864405', '2', '149', 'SUCCESS', 'Recharge done successfully', '1', '4006481494', '2021-08-08 15:24:05', '429.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (61, '6386476787', '8418895400', '6', '199', 'SUCCESS', 'Recharge done successfully', '1', '3043979475', '2021-08-08 15:34:21', '230.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (62, '9792465464', '6386476787', '15', '555', 'SUCCESS', 'Recharge done successfully', '1', '6312807558', '2021-08-10 16:28:10', '1750.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (63, '8084940179', '8084940179', '2', '129', 'SUCCESS', 'Recharge done successfully', '1', '5543316059', '2021-08-11 08:36:46', '1621.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (64, '8052330561', '6265757348', '15', '125', 'SUCCESS', 'Recharge done successfully', '1', '9971524032', '2021-08-11 11:43:38', '1496.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (65, '8052330561', '6389250677', '21', '249', 'SUCCESS', 'Recharge done successfully', '1', '6662322170', '2021-08-11 14:57:40', '1247.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (66, '8052330561', '9519602189', '2', '79', 'SUCCESS', 'Recharge done successfully', '1', '2648080899', '2021-08-11 15:30:11', '1168.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (67, '8052330561', '6386279579', '15', '199', 'SUCCESS', 'Recharge done successfully', '1', '2049762724', '2021-08-11 16:05:22', '969.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (68, '8052330561', '7390013447', '2', '149', 'SUCCESS', 'Recharge done successfully', '1', '8629123154', '2021-08-11 17:58:01', '820.00000');
INSERT INTO `recharge` (`id`, `uid`, `number`, `oprator`, `amount`, `status`, `rrmarks`, `type`, `txnid`, `addon`, `bal`) VALUES (69, '8052330561', '6261708460', '15', '149', 'SUCCESS', 'Recharge done successfully', '1', '9526971208', '2021-08-12 17:31:48', '1706.00000');


#
# TABLE STRUCTURE FOR: records
#

DROP TABLE IF EXISTS `records`;

CREATE TABLE `records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(999) COLLATE utf8_unicode_ci DEFAULT NULL,
  `total` varchar(999) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `records` (`id`, `date`, `total`) VALUES (1, '2021-05-15', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (2, '2021-05-16', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (3, '2021-05-17', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (4, '2021-05-18', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (5, '2021-05-19', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (6, '2021-05-20', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (7, '2021-05-21', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (8, '2021-05-22', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (9, '2021-05-23', '7');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (10, '2021-05-24', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (11, '2021-05-25', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (12, '2021-05-26', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (13, '2021-05-27', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (14, '2021-05-28', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (15, '2021-05-29', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (16, '2021-05-30', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (17, '2021-05-31', '7');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (18, '2021-06-01', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (19, '2021-06-02', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (20, '2021-06-03', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (21, '2021-06-04', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (22, '2021-06-05', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (23, '2021-06-06', '7');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (24, '2021-06-07', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (25, '2021-06-08', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (26, '2021-06-09', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (27, '2021-06-10', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (28, '2021-06-11', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (29, '2021-06-12', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (30, '2021-06-13', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (31, '2021-06-15', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (32, '2021-06-16', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (33, '2021-06-18', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (34, '2021-06-19', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (35, '2021-06-21', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (36, '2021-06-22', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (37, '2021-06-24', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (38, '2021-06-25', '6');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (39, '2021-06-26', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (40, '2021-06-28', '4');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (41, '2021-07-01', '18');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (42, '2021-07-02', '2');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (43, '2021-07-03', '23');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (44, '2021-07-05', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (45, '2021-07-06', '13');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (46, '2021-07-08', '8');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (47, '2021-07-09', '32');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (48, '2021-07-11', '17');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (49, '2021-07-12', '17');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (50, '2021-07-13', '5');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (51, '2021-07-14', '9');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (52, '2021-07-15', '3');
INSERT INTO `records` (`id`, `date`, `total`) VALUES (53, '2021-07-16', '7');


#
# TABLE STRUCTURE FOR: reward
#

DROP TABLE IF EXISTS `reward`;

CREATE TABLE `reward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(999) NOT NULL,
  `reward` varchar(999) NOT NULL,
  `level` int(11) NOT NULL,
  `addon` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: royality
#

DROP TABLE IF EXISTS `royality`;

CREATE TABLE `royality` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `royal` varchar(999) COLLATE utf8_unicode_ci DEFAULT NULL,
  `royal1` varchar(999) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `royality` (`id`, `royal`, `royal1`) VALUES (1, '0', '0');


#
# TABLE STRUCTURE FOR: staff_bill_list
#

DROP TABLE IF EXISTS `staff_bill_list`;

CREATE TABLE `staff_bill_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_payment
#

DROP TABLE IF EXISTS `staff_payment`;

CREATE TABLE `staff_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `bill_no` varchar(999) DEFAULT NULL,
  `payid` varchar(999) DEFAULT NULL,
  `pre_amt` varchar(999) DEFAULT NULL,
  `paid` varchar(999) DEFAULT NULL,
  `dues` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_stock
#

DROP TABLE IF EXISTS `staff_stock`;

CREATE TABLE `staff_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `tps` int(11) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: staff_stock_list
#

DROP TABLE IF EXISTS `staff_stock_list`;

CREATE TABLE `staff_stock_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_no` varchar(999) DEFAULT NULL,
  `user_id` varchar(999) DEFAULT NULL,
  `pid` varchar(999) DEFAULT NULL,
  `size_id` varchar(999) DEFAULT NULL,
  `color_id` varchar(999) DEFAULT NULL,
  `mrp` varchar(999) DEFAULT NULL,
  `qty` varchar(999) DEFAULT NULL,
  `total` varchar(999) DEFAULT NULL,
  `tps` int(11) DEFAULT NULL,
  `status` varchar(999) DEFAULT NULL,
  `addon` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: state
#

DROP TABLE IF EXISTS `state`;

CREATE TABLE `state` (
  `StateID` int(11) NOT NULL AUTO_INCREMENT,
  `CountryID` int(11) NOT NULL,
  `StateName` varchar(50) NOT NULL,
  `Notes` longtext,
  `ChangedBy` varchar(50) DEFAULT NULL,
  `ChangeDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`StateID`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=latin1;

INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (36, 1, 'ANDHRA PRADESH', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (37, 1, 'ASSAM', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (38, 1, 'ARUNACHAL PRADESH', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (39, 1, 'GUJRAT', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (40, 1, 'BIHAR', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (41, 1, 'HARYANA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (42, 1, 'HIMACHAL PRADESH', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (43, 1, 'JAMMU & KASHMIR', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (44, 1, 'KARNATAKA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (45, 1, 'KERALA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (46, 1, 'MADHYA PRADESH', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (47, 1, 'MAHARASHTRA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (48, 1, 'MANIPUR', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (49, 1, 'MEGHALAYA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (50, 1, 'MIZORAM', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (51, 1, 'NAGALAND', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (52, 1, 'ORISSA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (53, 1, 'PUNJAB', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (54, 1, 'RAJASTHAN', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (55, 1, 'SIKKIM', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (56, 1, 'TAMIL NADU', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (57, 1, 'TRIPURA', NULL, 'Nieanjan', '2020-01-18 09:35:37');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (58, 1, 'UTTAR PRADESH', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (59, 1, 'WEST BENGAL', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (60, 1, 'DELHI', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (61, 1, 'GOA', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (62, 1, 'PONDICHERY', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (63, 1, 'LAKSHDWEEP', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (64, 1, 'DAMAN & DIU', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (65, 1, 'DADRA & NAGAR', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (66, 1, 'CHANDIGARH', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (67, 1, 'ANDAMAN & NICOBAR', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (68, 1, 'UTTARANCHAL', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (69, 1, 'JHARKHAND', NULL, 'Nieanjan', '2020-01-18 09:35:38');
INSERT INTO `state` (`StateID`, `CountryID`, `StateName`, `Notes`, `ChangedBy`, `ChangeDate`) VALUES (70, 1, 'CHATTISGARH', NULL, 'Nieanjan', '2020-01-18 09:35:38');


#
# TABLE STRUCTURE FOR: tbl_ad_slider
#

DROP TABLE IF EXISTS `tbl_ad_slider`;

CREATE TABLE `tbl_ad_slider` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(999) NOT NULL,
  `title` varchar(111) NOT NULL,
  `img` varchar(999) NOT NULL,
  `other` varchar(999) NOT NULL,
  `addon` datetime NOT NULL,
  `updt` datetime NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_ad_slider` (`id`, `link`, `title`, `img`, `other`, `addon`, `updt`, `status`) VALUES (1, 'https://www.tryitindia.com/product_special?id=2&type=end-category&mid=1', 'Raksha Bandhan Offer', 'ad_slider-1-210719111436.jpg', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);
INSERT INTO `tbl_ad_slider` (`id`, `link`, `title`, `img`, `other`, `addon`, `updt`, `status`) VALUES (2, 'https://www.tryitindia.com/product_special?id=2&type=end-category&mid=1', 'tset', 'ad_slider-2-210719111522.jpg', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1);


#
# TABLE STRUCTURE FOR: tbl_advertisement
#

DROP TABLE IF EXISTS `tbl_advertisement`;

CREATE TABLE `tbl_advertisement` (
  `adv_id` int(11) NOT NULL AUTO_INCREMENT,
  `adv_location` varchar(255) NOT NULL,
  `adv_type` varchar(100) NOT NULL,
  `adv_photo` varchar(255) NOT NULL,
  `adv_url` varchar(255) NOT NULL,
  `adv_adsense_code` text NOT NULL,
  PRIMARY KEY (`adv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_career
#

DROP TABLE IF EXISTS `tbl_career`;

CREATE TABLE `tbl_career` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(999) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cv` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tbl_category
#

DROP TABLE IF EXISTS `tbl_category`;

CREATE TABLE `tbl_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) NOT NULL,
  `category_slug` varchar(255) NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_color
#

DROP TABLE IF EXISTS `tbl_color`;

CREATE TABLE `tbl_color` (
  `color_id` int(11) NOT NULL AUTO_INCREMENT,
  `color_name` varchar(255) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`color_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`) VALUES (1, 'Test Color', 0);
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`) VALUES (2, 'Red', 1);
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`) VALUES (3, 'Blue', 1);
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`) VALUES (4, 'Black', 1);
INSERT INTO `tbl_color` (`color_id`, `color_name`, `status`) VALUES (5, 'Gray', 1);


#
# TABLE STRUCTURE FOR: tbl_contact_inq
#

DROP TABLE IF EXISTS `tbl_contact_inq`;

CREATE TABLE `tbl_contact_inq` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` varchar(9999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `status` int(11) NOT NULL,
  `ip_address` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `browser` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (1, 'Eric Jones', '555-555-12', 'eric.jones.z.mail@gmail.com', 'My name’s Eric and I just found your site tryitindia.com.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://jumboleadmagnet.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=tryitindia.com\r\n', '2022-01-10 04:33:59', 1, '181.215.88.161', 'Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36');
INSERT INTO `tbl_contact_inq` (`id`, `name`, `phone`, `email`, `message`, `addon`, `status`, `ip_address`, `browser`) VALUES (2, 'Jenny Hibbard', '9723748400', 'jenny@foremedia.net', 'Hey, I visited your site and I think that your content is amazing! It is really engaging and original, you must have worked so hard to generate such a quality content. We are ForeMedia and we help website owners with great websites to maximize the revenue they make from their website. I would love to buy Ad Spaces on your website and pay you per each impression of the ads on your site. We are Google Ad Exchange Premium partners and we work with more than 100 Ad Network & thousands of premium direct advertisers who would LOVE to buy Ads directly from your site and we can guarantee to increase your revenue by at least 45% compared to other advertising solutions you are currently using. You deserve to earn more for your content and maximize your earning potential and I will help you unlock that potential! There is no cost, you can register to our monetization platform for free on this link: https://foremedia.net/start I will be available for you on the Live Chat if you need any help, or you can email me back to: jenny@foremedia.net if you have any questions. I have at least 17 Premium Advertisers that have asked me to approach you because they would like to advertise on your website on Premium eCPM [cost per impressions] basis. Have a good day & feel free to ping me for any question! Click the link here for 1 minute registration to our platform [it\'s free!]: https://go.foremedia.net/u/start/', '2022-01-11 15:27:00', 1, '107.152.131.222', 'Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/65.0.3325.181 Safari/537.36');


#
# TABLE STRUCTURE FOR: tbl_country
#

DROP TABLE IF EXISTS `tbl_country`;

CREATE TABLE `tbl_country` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_name` varchar(100) NOT NULL DEFAULT '',
  `state_id` varchar(110) NOT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: tbl_coupon
#

DROP TABLE IF EXISTS `tbl_coupon`;

CREATE TABLE `tbl_coupon` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(999) DEFAULT NULL,
  `code` varchar(999) DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `addon` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `min_amt` float DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `uid` varchar(999) DEFAULT NULL,
  PRIMARY KEY (`coupon_id`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (72, 'Investor Coupon', '51524693', '500', '2022-07-12', '2022-08-11', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (71, 'Investor Coupon', '31037513', '500', '2022-06-11', '2022-07-11', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (70, 'Investor Coupon', '31178870', '500', '2022-05-11', '2022-06-10', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (69, 'Investor Coupon', '65387966', '500', '2022-04-10', '2022-05-10', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (68, 'Investor Coupon', '59879534', '500', '2022-03-10', '2022-04-09', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (67, 'Investor Coupon', '42210389', '500', '2022-02-07', '2022-03-09', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (66, 'Investor Coupon', '96504257', '500', '2022-01-07', '2022-02-06', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (65, 'Investor Coupon', '29750974', '500', '2021-12-07', '2022-01-06', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (64, 'Investor Coupon', '11371211', '500', '2021-11-06', '2021-12-06', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (63, 'Investor Coupon', '55690944', '500', '2021-10-06', '2021-11-05', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (62, 'Investor Coupon', '59127428', '500', '2021-09-05', '2021-10-05', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (61, 'Investor Coupon', '36618406', '500', '2021-08-05', '2021-09-04', '2021-08-05 13:56:41', 1, '499', 1, '9905222899');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (60, 'Investor Coupon', '53339878', '500', '2022-07-12', '2022-08-11', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (59, 'Investor Coupon', '50852846', '500', '2022-06-11', '2022-07-11', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (58, 'Investor Coupon', '37260752', '500', '2022-05-11', '2022-06-10', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (57, 'Investor Coupon', '93246318', '500', '2022-04-10', '2022-05-10', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (56, 'Investor Coupon', '63311552', '500', '2022-03-10', '2022-04-09', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (55, 'Investor Coupon', '62488601', '500', '2022-02-07', '2022-03-09', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (54, 'Investor Coupon', '39502628', '500', '2022-01-07', '2022-02-06', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (53, 'Investor Coupon', '90387034', '500', '2021-12-07', '2022-01-06', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (52, 'Investor Coupon', '86024238', '500', '2021-11-06', '2021-12-06', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (51, 'Investor Coupon', '56286446', '500', '2021-10-06', '2021-11-05', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (50, 'Investor Coupon', '34003239', '500', '2021-09-05', '2021-10-05', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (49, 'Investor Coupon', '11619093', '500', '2021-08-05', '2021-09-04', '2021-08-05 09:45:57', 1, '499', 1, '9939090087');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (37, 'Investor Coupon', '11188518', '1000', '2021-08-03', '2021-09-02', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (38, 'Investor Coupon', '78770153', '1000', '2021-09-03', '2021-10-03', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (39, 'Investor Coupon', '41162486', '1000', '2021-10-04', '2021-11-03', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (40, 'Investor Coupon', '36340410', '1000', '2021-11-04', '2021-12-04', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (41, 'Investor Coupon', '68441325', '1000', '2021-12-05', '2022-01-04', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (42, 'Investor Coupon', '65676074', '1000', '2022-01-05', '2022-02-04', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (43, 'Investor Coupon', '79665173', '1000', '2022-02-05', '2022-03-07', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (44, 'Investor Coupon', '81533968', '1000', '2022-03-08', '2022-04-07', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (45, 'Investor Coupon', '51097040', '1000', '2022-04-08', '2022-05-08', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (46, 'Investor Coupon', '48319258', '1000', '2022-05-09', '2022-06-08', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (47, 'Investor Coupon', '32804493', '1000', '2022-06-09', '2022-07-09', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');
INSERT INTO `tbl_coupon` (`coupon_id`, `title`, `code`, `percentage`, `start_date`, `end_date`, `addon`, `status`, `min_amt`, `type`, `uid`) VALUES (48, 'Investor Coupon', '15590772', '1000', '2022-07-10', '2022-08-09', '2021-08-03 14:12:51', 1, '999', 1, '8210687557');


#
# TABLE STRUCTURE FOR: tbl_customer
#

DROP TABLE IF EXISTS `tbl_customer`;

CREATE TABLE `tbl_customer` (
  `cust_id` int(11) NOT NULL AUTO_INCREMENT,
  `sponsor_id` varchar(999) NOT NULL,
  `cust_name` varchar(100) NOT NULL,
  `cust_cname` varchar(100) NOT NULL,
  `cust_email` varchar(100) NOT NULL,
  `cust_phone` varchar(50) NOT NULL,
  `cust_image` varchar(999) NOT NULL,
  `cust_country` int(11) NOT NULL,
  `cust_address` text NOT NULL,
  `cust_city` varchar(100) NOT NULL,
  `cust_state` varchar(100) NOT NULL,
  `cust_zip` varchar(30) NOT NULL,
  `cust_b_name` varchar(100) NOT NULL,
  `cust_b_cname` varchar(100) NOT NULL,
  `cust_b_phone` varchar(50) NOT NULL,
  `cust_b_country` int(11) NOT NULL,
  `cust_b_address` text NOT NULL,
  `cust_b_city` varchar(100) NOT NULL,
  `cust_b_state` varchar(100) NOT NULL,
  `cust_b_zip` varchar(30) NOT NULL,
  `cust_s_name` varchar(100) NOT NULL,
  `cust_s_cname` varchar(100) NOT NULL,
  `cust_s_phone` varchar(50) NOT NULL,
  `cust_s_country` int(11) NOT NULL,
  `cust_s_address` text NOT NULL,
  `cust_s_city` varchar(100) NOT NULL,
  `cust_s_state` varchar(100) NOT NULL,
  `cust_s_zip` varchar(30) NOT NULL,
  `cust_password` varchar(100) NOT NULL,
  `cust_token` varchar(255) NOT NULL,
  `cust_datetime` varchar(100) NOT NULL,
  `cust_timestamp` varchar(100) NOT NULL,
  `cust_status` int(1) NOT NULL,
  `code` int(11) NOT NULL,
  `cust_otp` varchar(99) NOT NULL,
  `uid` varchar(999) NOT NULL,
  `pass` varchar(999) NOT NULL,
  `user` varchar(999) NOT NULL,
  PRIMARY KEY (`cust_id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (1, '', 'TryIt India', '', 'manojpds07@gmail.com', '8084940179', 'Customer-1-1190066793.jpg', 0, '', 'MUZAFFARPUR', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', 1, 0, '', '8084940179', 'Abhishek@21574', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (2, '9939195269', 'Manoj Sharma', '', 'manojpds07@gmail.com', '9939195269', '', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '9d8ba16cb7e0f8d7e88e1e7fd5ac6b44', '2021-07-16 06:13:59', '1626439439', 1, 861129, '', '9939195269', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (8, '9939195269', 'AMAR SINGH', '', 'amarsingh101834@gmail.com', '7979030395', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e10adc3949ba59abbe56e057f20f883e', '31d2aa1a85e8b371bf31d729f84e3a81', '2021-07-19 07:26:18', '1626702978', 1, 369680, '', '7979030395', '123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (9, '9939195269', 'Manish kumar sharma', '', 'manishsharma873@gmail.com', '9918508019', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '75355f34ceeeda3705c1e00bdfdb7abc', 'd7b4921b117c79fc0d886f0f60f202a5', '2021-07-20 10:20:53', '1626756653', 1, 615407, '', '9918508019', 'imcool_manish1984', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (10, '9939195269', 'Vimal Kumar', '', 'biharbhakti.vimal@gmail.com', '7992259617', '', 0, '', '5', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '682324b7ac854a5ad7db003c2a860f8d', '9aa1fc32b9e9a06302a9942521ceae05', '2021-07-20 10:26:20', '1626756980', 1, 978834, '', '7992259617', 'v12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (11, '9918508019', 'Rohit Sharma', '', 'rohitfriends.rkt@gmail.com', '6386476787', 'Customer-11-2090688068.png', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '0f044049b972ae79e9e9cd4369cc4015', 'cffdce83061efba1852532e5a3b9e6dc', '2021-07-20 10:32:08', '1626757328', 1, 413724, '', '6386476787', 'Rohit@1819', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (12, '9939195269', 'Sanjay Kumar Mishra', '', 'skmishra951968@gmail.com', '9939090087', '', 0, '', '5', '1', '843108', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '1a7586585ca62f3e0b202024371acf2d', '1362c2debb2639e9cc52caaf37100643', '2021-07-20 10:33:42', '1626757422', 1, 764738, '', '9939090087', 'Sanjay123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (14, '6386476787', 'Abhishek Sharma', '', 'abhisheksharma.rkt@gmail.com', '7004983144', '', 0, '', '5', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '76e3e07d735e14de9d768d8fe05c39a8', '7d704dee25c7752cfe6a42bad6a6d3df', '2021-07-20 10:39:12', '1626757752', 1, 628, '', '7004983144', 'abhi1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (15, '9939195269', 'SANJEEV PANDEY ', '', 'Sanjeev.pds73@gmail.com', '9693287571', 'Customer-15-643254697.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4afd521d77158e02aed37e2274b90c9c', '6b052ba9fc0647a2f8d58f69fdc51d44', '2021-07-20 10:44:21', '1626758061', 1, 592666, '', '9693287571', '1977', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (17, '7004983144', 'Raghuraj Rai', '', 'abhiraat18@gmail.com', '9576684117', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '76e3e07d735e14de9d768d8fe05c39a8', 'f99f7a420745fab955ed7ffe23a29a69', '2021-07-20 10:48:56', '1626758336', 1, 911637, '', '9576684117', 'abhi1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (20, '7004983144', 'Manglam', '', 'manglamvats175@gmail.com', '9508253533', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'ed68caf95649dacf2b3d6fb2be8e1c38', 'cb7b3cdd7a8e679d5689f48cf38db9fe', '2021-07-20 10:52:31', '1626758551', 1, 421280, '', '9508253533', 'Manglam@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (23, '7004983144', 'Yash Rajpal', '', 'yashh.you@gmail.com', '7764898317', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c5647a098933d26fc3fbe20596bb8011', '53c02500a810a39207c0eb418462e0d6', '2021-07-20 10:56:10', '1626758770', 1, 389911, '', '7764898317', 'yash@tryit', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (24, '7004983144', 'kaushik srivastava', '', 'harshkaushik129@gmail.com', '7004779572', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'bcb108afd112c87e68ba9c965c9fcaf4', '006ded2c9ea74b3a541c966412078fab', '2021-07-20 11:44:56', '1626761696', 1, 482139, '', '7004779572', '77791sbp', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (26, '7004983144', 'Prince Raj Jha', '', 'vickyjha5078@gmail.com', '6201211018', 'Customer-26-1286245528.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c2b46bbac48d16dd46488d521185098b', 'eca7fc20e542c20ede80687949942d16', '2021-07-20 12:28:38', '1626764318', 1, 397599, '', '6201211018', '20376762473', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (27, '7004983144', 'Harshit Harsh', '', 'harshitharsh32@yahoo.com', '7301101143', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '045682aada4d6e6e6311c72166b23079', '90638f49c7097685e8117591be1bfe64', '2021-07-20 12:31:01', '1626764461', 1, 255761, '', '7301101143', 'steveroger007', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (28, '7979030395', 'Mithilesh Kumar', '', 'mithileshpds@gmail.com', '8210179625', 'Customer-28-570078389.jpg', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '79cfac6387e0d582f83a29a04d0bcdc4', '581328588c634f2d007dbb63e14538c7', '2021-07-20 01:18:21', '1626767301', 1, 768974, '', '8210179625', 'kumar', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (29, '7004983144', 'Aditya Raj', '', 'adityaraj001213@gmail.com', '9934748803', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'a42d9624b1b119acb7d796b0b8e3f4f6', '3d25049c9a20e09416c8b52bc25dbe47', '2021-07-20 01:42:22', '1626768742', 1, 386053, '', '9934748803', 'adi123...', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (30, '8210179625', 'Avanish Kumar', '', 'avkumar4321@gmail.com', '7369882648', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '070c7a93d40e4287f78def49e766b721', '88218b16ed5001678b624419df4a78dc', '2021-07-20 02:00:31', '1626769831', 1, 256564, 'MjkzMzc3', '7369882648', 'avanisH@9', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (31, '7004983144', 'Abhigyan kumar', '', 'abhigyan80@gmail.com', '9546177051', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c7426702ca0e0c228f97ceffbad4bdf8', '4875efba16f18a16b1e625c2277bbcb9', '2021-07-20 03:37:24', '1626775644', 1, 940612, '', '9546177051', '842002abhigyan', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (32, '9939090087', 'Amit Kumar', '', 'ajay.amit29@gmail.com', '7301536136', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '00a799d068901eb94a61d82db5ad1f4f', '52ea646b1401d7e57874a19670ad07ea', '2021-07-20 07:51:46', '1626790906', 1, 631989, '', '7301536136', 'Amit@2907', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (33, '7004983144', 'Umesh sharma', '', 'umeshvibha123@gmail.com', '9931667459', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c33367701511b4f6020ec61ded352059', '3a23a1bd69b15f3638ebed72c0abe6b7', '2021-07-20 08:05:54', '1626791754', 1, 513776, '', '9931667459', '654321', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (34, '9939090087', 'Abhishek Kumar', '', 'abhishek11178@yahoo.com', '7700841919', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e10adc3949ba59abbe56e057f20f883e', 'b9156bf8eade0c22ab7c86745fb89051', '2021-07-20 08:11:54', '1626792114', 1, 166436, '', '7700841919', '123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (35, '9931667459', 'Sidh Nath Tiwari', '', 'nathtiwarys@gmail.com', '9471668022', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', '43af14622820de5e616c2c87e9a6fc3d', '2021-07-20 08:16:00', '1626792360', 1, 296294, '', '9471668022', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (36, '9939090087', 'Surendra Bharti', '', 'bdm.surendra@gmail.com', '9955688371', 'Customer-36-230710225.jpg', 0, '', '5', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e41735e82f79de563136923bd72de508', '38ca809f0e22d29728b923e98781875c', '2021-07-20 08:19:38', '1626792578', 1, 417916, '', '9955688371', 'Info@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (37, '7004983144', 'Abhishek Kumar', '', 'akumarsit1989@gmail.com', '7050096409', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '797e125e9ff69b9ce515b4f446a49b49', 'b920952951c248e46e85cafa16ebc275', '2021-07-20 08:20:49', '1626792649', 1, 679339, '', '7050096409', 'Ab21021989@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (38, '6201211018', 'Pramod Kumar jha', '', 'pramodkumarjha38@gmail.com', '9798067920', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '86c2127bd6d81568d438020e50bbf4ad', '5942c6085176a6ae0cfd543362beb259', '2021-07-20 08:29:08', '1626793148', 1, 829192, 'MjA5NTQ2', '9798067920', 'Pramod 123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (39, '9939090087', 'Amresh kumar', '', 'oshoamresh94@gmail.com', '9939002200', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4a3e95a1f4df3fdd0f5b17a5aecc31a3', 'cf6598b877f1ae40e16c6d0b39a6e1b0', '2021-07-20 08:33:39', '1626793419', 1, 845962, '', '9939002200', 'amresh', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (40, '6201211018', 'Shalini mishra', '', 'shalinimishra8804@gmail.com', '8227973889', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '9c89d1b9feb0d397d453a62fd899a0e8', 'e41a4383ee958867eb3fa15d09004251', '2021-07-20 08:46:14', '1626794174', 1, 134478, '', '8227973889', 'passwordkumari', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (41, '9939090087', 'Surendra chaudhary', '', 'surendraflp74@gmail.com', '8084562474', '', 0, '', 'MUZAFFARPUR', '1', '843109', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '13a2e6fe7f9045a7ab1946b3ddcb377d', 'c2774b746afed10d62628d53fc62f3cf', '2021-07-20 08:50:56', '1626794456', 1, 344625, '', '8084562474', 'shobha', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (42, '7369882648', 'Shyam kumar', '', 'shyam7371@gmail.com', '7371815641', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '9da6a9c88cc370f1f1ee6b0f7305c5dc', '70f3d7e55fe0af02906309d7b48e5a09', '2021-07-20 10:02:55', '1626798775', 1, 935050, '', '7371815641', 'Shyam3115@kumar', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (43, '8210179625', 'Rajni', '', 'rspankhurig@gmail.com', '8936058495', 'Customer-43-1279442403.jpg', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '5d3cbc22c9d6fc71675572d0bc9fac7c', '5bef2b20be6bb133faf29b67375de064', '2021-07-20 10:23:47', '1626800027', 1, 469763, '', '8936058495', '181922', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (44, '7004983144', 'Hanuman Prasad Marodiya', '', 'mr.nagarwal27@rediffmail.com', '9334906149', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'eb0b491147737ff4804c38ae9c1e35f3', '99694ecd5f8cb3f05b26662f3de756f2', '2021-07-21 07:57:06', '1626834426', 1, 527140, '', '9334906149', 'Npa241116@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (45, '7004983144', 'Amod Kumar ', '', 'amod200584@gmail.com', '9155868679', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '964d180ea80d672a811ed3b56da0b05e', 'aaa4e6f78e3477e8df920ab35a642679', '2021-07-21 08:08:22', '1626835102', 1, 947984, '', '9155868679', '9693', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (46, '7004983144', 'Himanshu kumar singh', '', 'Himanshusinghrathore0000@gmail.com', '8789369583', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '0b975d446d3d8e8991d15be6b710ce81', '3ef8e1c50f5ba21b25e9be0750b4c2b2', '2021-07-21 08:38:16', '1626836896', 1, 234443, '', '8789369583', '9934033810', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (47, '9334906149', 'Pooja Agarwal', '', 'Poojakeshri07@gmail.com', '9199354154', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'eb0b491147737ff4804c38ae9c1e35f3', '705090c7c80f9f5c50c5dc1b9c749314', '2021-07-21 09:01:52', '1626838312', 1, 296914, '', '9199354154', 'Npa241116@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (48, '9199354154', 'Nikhil Kumar Agarwal', '', 'jaimatadi010413@gmail.com', '8603590717', '', 0, '', 'MUZAFFARPUR', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'eb0b491147737ff4804c38ae9c1e35f3', 'adb3c402f33a727fd50549e1f6dd5a9c', '2021-07-21 09:05:20', '1626838520', 1, 748639, '', '8603590717', 'Npa241116@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (49, '9334906149', 'Nikhil kumar Agarwal', '', 'jaimatadeetraders010410@gmail.com', '9199701755', '', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'eb0b491147737ff4804c38ae9c1e35f3', '2d6e3d9607c779a16d2e9a876c275914', '2021-07-21 09:10:29', '1626838829', 1, 322920, '', '9199701755', 'Npa241116@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (50, '9939090087', 'Raghavendra Kumar', '', 'raghavendrakrmishra@gmail.com', '7903515631', 'Customer-50-1547277924.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c87020c585b83a664239e19b9e85259b', '9df21736d0c73fe36615e767e216615b', '2021-07-21 09:36:26', '1626840386', 1, 540267, '', '7903515631', '9771123695', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (51, '6201211018', 'KÃRÃÑ kumar', '', 'karankumar37160@gmail.com', '7461099919', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '40aade019ae358b68129dd4f7071f2fa', '5e72b9342f15a171f2161a46fd4b48b1', '2021-07-21 10:06:22', '1626842182', 1, 290593, '', '7461099919', '746109', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (52, '7461099919', 'Jata shankar ', '', 'jatashankarzee@gmail', '8574681882', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '978610fa4fa34c0dff5c064897cd5996', 'dc1e4af288c2a176713771f2d65e580f', '2021-07-21 10:16:06', '1626842766', 1, 167813, '', '8574681882', 'jata shankar', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (53, '8210179625', 'Wipin kumar', '', 'prachi9955659959@gmail.com', '9955659959', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4c3b56f92b3d37be38a07dfce85890fe', '92f52547d71bbeb69a5952d01bd445fd', '2021-07-21 10:23:41', '1626843221', 1, 354516, '', '9955659959', 'prachi51', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (54, '9693287571', 'Sunny Pandey ', '', 'sunnypandey850@gmail.com', '9931220861', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '8fb8fe9997de44180dd32eb91e2b389e', '2021-07-21 10:27:08', '1626843428', 1, 808878, '', '9931220861', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (55, '9199701755', 'Nikhil kumar Agarwal', '', 'jaimatadi010413@rediffmail.com', '6201655088', '', 0, '', 'MUZAFFARPUR', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'eb0b491147737ff4804c38ae9c1e35f3', 'a54554b472bd14951067393de1df5717', '2021-07-21 10:40:06', '1626844206', 1, 834032, '', '6201655088', 'Npa241116@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (56, '8210179625', 'RAJEEV RANJAN MISHRA', '', 'rajiv@gmail.com', '8210687557', 'Customer-56-1899269817.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '4e1cc62e5de6e296a41d4119702b2641', '2021-07-21 10:52:29', '1626844949', 1, 646927, '', '8210687557', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (57, '8210179625', 'Manish kumar', '', 'mk14606@gmail.com', '9570641920', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '751808d04b73227d9bd0b93d9f740a1f', '4673f85aa1b79b6d36bf3ffe0fdc1e3a', '2021-07-21 01:43:46', '1626855226', 1, 773719, '', '9570641920', '7250164501', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (58, '9939090087', 'Ram kumar', '', 'ar586399@gmail.com', '9708773892', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4b1f5ddd8cbd320cf8fc8e56ae326d42', 'c3ccd25316fa2056327ad3c24a3149d3', '2021-07-21 01:46:28', '1626855388', 1, 498772, 'NjE0Mjg2', '9708773892', '27011996', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (59, '8210179625', 'Dilip kumar', '', 'dkjee5051@gmail.com', '9661725051', '', 0, '', '5', '1', 'dk5051', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c4754d687d6615439ae9d046353eb4e1', 'fa819560a11d355e75c38db9031e9689', '2021-07-21 02:34:06', '1626858246', 1, 153356, '', '9661725051', 'dk5051', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (60, '9939090087', 'Kaushlendra prasad singh', '', 'kaushlendra10bxdps3869n@gmail.com', '9708203929', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'b3c011bd23c32998e53be2fcfcaf6008', '9b36ac09d47ff2a890ed36886aaa4082', '2021-07-21 08:25:54', '1626879354', 1, 787338, '', '9708203929', 'Kpsingh123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (61, '8210179625', 'Jitendra kumar', '', 'jitendra_kumar008@yahoo.com', '9934919689', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '3d2172418ce305c7d16d4b05597c6a59', 'e91e4a116fcef361ebf3ed394e2a3676', '2021-07-21 08:43:08', '1626880388', 1, 551053, '', '9934919689', '22222', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (62, '8210687557', 'SURESH PRASAD SHAHI', '', 'suresh@gmail.com', '6207574162', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', 'b03d8f7299df211f106f23d82739e11a', '2021-07-21 08:57:30', '1626881250', 1, 556021, '', '6207574162', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (63, '8210687557', 'Kanhaiya Lal Singh', '', 'kl.singh86@gmail.com', '9708314717', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '272e5bb0575c1e7ef9bf838eee9587ea', '5f6765dc42db249cc3f72c9fd86ab282', '2021-07-21 09:10:00', '1626882000', 1, 100165, '', '9708314717', 'krity0', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (64, '7004983144', 'Pankaj Kumar ', '', 'pankajkumar02390@gmail.com', '7717790405', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e970f6843bb4138ca2e5ffbb82423880', '9f9ff22d96920a5857b5d628ede0efb3', '2021-07-21 10:10:51', '1626885651', 1, 727990, '', '7717790405', '9525093649', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (65, '9939090087', 'Abhilasha Kumari', '', 'abhilashapathak1999@gmail.com', '7563092302', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '175a46a4ec1622d1425a7f56b7948e80', '649e7251553dec23197b0c0b6f398e5a', '2021-07-21 10:27:36', '1626886656', 1, 211427, '', '7563092302', 'av1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (66, '8210179625', 'Deepak', '', 'deepakpappu9304@gmail.com', '9304292354', 'Customer-66-1998859519.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '498b5924adc469aa7b660f457e0fc7e5', 'fad84a17c51d68d21bdb816afa9272ad', '2021-07-22 12:35:41', '1626937541', 1, 744664, '', '9304292354', 'deepak', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (67, '7979030395', 'amar', '', 'amarsingh101834@gmail.com', '9122894111', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '6355f6adf1ccc57482536032fe1d0aaa', '2021-07-22 02:36:27', '1626944787', 1, 634276, '', '9122894111', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (68, '9122894111', 'AMAR SINGH', '', 'gmart.today@gmail.com', '8102811241', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '3f5ce89e7a5effe1a374b020ee1b3af9', '2021-07-22 02:38:19', '1626944899', 1, 503623, '', '8102811241', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (69, '9939195269', 'Chandni', '', 'ck8409678724@gmail.com', '8340289850', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '8eff94626ab54721bf2846ba9fdc4694', 'e5da7ebb509b4352fadb10f00605f0f7', '2021-07-22 03:36:05', '1626948365', 1, 227496, '', '8340289850', 'chandni@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (70, '9939195269', 'Gaurav', '', 'gauav.pandey@icicibank.com', '7991159941', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '9a79949abe1b72c8874b696b5001cef5', 'ba514d0b7cf804ce08f90dd11d8c899b', '2021-07-22 04:13:20', '1626950600', 1, 394667, '', '7991159941', 'Gaurav@12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (71, '7992259617', 'Atul Kumar', '', 'www.akumar6@gmail.com', '7033280505', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '80ee209e5264358302de001ca55d3c0f', 'c65c4138ae9524ebf93f9f32873ea263', '2021-07-22 06:18:32', '1626958112', 1, 979702, '', '7033280505', 'Atul123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (72, '8102811241', 'Team Teogther ', '', 'teamteogther2021@gmail.com', '8873749286', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4e14bb2666bb0639a5776122dcb8f355', 'bd96ce9fcc284c73c00a197904b1fea2', '2021-07-23 06:08:08', '1627043888', 1, 441671, 'OTUxNDc1', '8873749286', 'teamteogther2021', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (73, '8873749286', 'Team togther 1', '', 'teamtogther20211@gmail.com', '6201847968', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '79d5e162a17bb7c52e0e281cf4a4f06e', 'b4cf9c342c9aba077c98e8f59e21b4cb', '2021-07-23 06:38:46', '1627045726', 1, 619480, 'NTA0MjM3', '6201847968', 'rajkri', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (74, '6201847968', 'Team together 2', '', 'teamtogether20212@gmail.com', '6204143525', '', 0, '', 'MUZAFFARPUR', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '79d5e162a17bb7c52e0e281cf4a4f06e', 'a14f5352bba4e3adadff1760b82b3385', '2021-07-23 06:50:08', '1627046408', 1, 700418, '', '6204143525', 'rajkri', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (75, '8210179625', 'Kamlesh kumar', '', 'mithileshpds@gmail.com', '9835295896', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '1dcd3c1ad23a29302e4346ade2b1da75', '38ecb4c294f948e1ca021e6d7bcf838f', '2021-07-23 06:54:29', '1627046669', 1, 560749, '', '9835295896', 'k123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (76, '7004983144', 'Nandan Kumar', '', 'nandanonly4u@gmail.com', '8092221370', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '2c847364986a11ddeda1c6baf07a37bc', 'cb5a76cb1df8e3b2653e03a3fa10f14a', '2021-07-23 08:19:40', '1627051780', 1, 226853, '', '8092221370', 'N12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (77, '7004983144', 'Manoj Kumar Singh', '', 'manojksinghreal952@gmail.com', '9430409859', '', 0, '', 'MUZAFFARPUR', '1', '842005', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '184ef422f6d3dbc8ea08ae1ef9e945b2', '26d80140cb5fd6a692dd33e3c2664db5', '2021-07-23 08:23:35', '1627052015', 1, 366844, '', '9430409859', 'bcegkmqs', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (78, '6204143525', 'AKASH OJHA', '', 'rajojha22222@gmail.com', '6204736973', 'Customer-78-1032255703.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', 'cbef728c2818dbcaf9491b957569ff21', '2021-07-24 12:57:09', '1627111629', 1, 538368, '', '6204736973', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (79, '6204143525', 'Krishna Kumar', '', 'krishna.ke55@gmail.com', '8235175667', 'Customer-79-304752215.jpg', 0, '', 'MUZAFFARPUR', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '243bd1ce0387f18005abfc43b001646a', '1d791aeee527480c1b353e2497745a62', '2021-07-24 01:07:09', '1627112229', 1, 187165, 'Mjk1NjYz', '8235175667', 'krishna', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (80, '7004983144', 'Pooja sharma ', '', 'poojaabhisharma14@gmail.com', '8102689164', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '76e3e07d735e14de9d768d8fe05c39a8', '14ddecfd493a6cedc5efbdf1fc75f11f', '2021-07-24 03:27:17', '1627120637', 1, 426590, '', '8102689164', 'abhi1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (81, '8235175667', 'Abha Kumari', '', 'manishkumar88733954@gmail.com', '8873395437', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'b75abfdf5db9a6838d967b29b7fcd610', '3425e3a575e48d735f5142a024744d2e', '2021-07-25 08:22:01', '1627181521', 1, 335608, '', '8873395437', 'abha kumari', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (82, '6204143525', 'RAJAN KUMAR', '', 'rajan1995ca@gmail.com', '7277977659', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e10adc3949ba59abbe56e057f20f883e', 'ea15a884353a857467d8a5debc8b7f17', '2021-07-25 11:00:34', '1627191034', 1, 948809, '', '7277977659', '123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (83, '9939195269', 'Anand mohan', '', 'mohananand887@gmail.com', '9097027327', 'Customer-83-1192197321.jpg', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e9eac51fd9e942305d2ea2cfe47fc4e4', '23849d9fdf0ea061a3a7ad6b0f3e2313', '2021-07-25 10:12:28', '1627231348', 1, 691675, '', '9097027327', 'Guriya', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (84, '7371815641', 'Kunal kumar', '', 'kunalbabu3238@gmail.com', '7079700793', '', 0, '', 'MUZAFFARPUR', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4d9ea22dcc8d4095b9e74984c8178392', 'f185005798e9b7ce31c8011f5ac5983c', '2021-07-26 10:15:18', '1627274718', 1, 749616, '', '7079700793', 'Kunal@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (85, '7004983144', 'Gauri Shankar Chaudhary', '', 'advgauriji71@email.com', '7903332032', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '31e62402e5e2a2ed94d42ffad97025ad', '401654b817734358bd67c3d19d720702', '2021-07-26 04:29:27', '1627297167', 1, 608810, '', '7903332032', 'anadibabu71', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (86, '7004983144', 'Kamar Alam', '', 'qamar198280@gmail.com', '8083760428', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '96154701517e9e13f9bd2c61cd6e885d', '61a3affac599e6c78b184215e73772b5', '2021-07-27 12:28:19', '1627369099', 1, 119592, '', '8083760428', 'myname02QA', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (87, '8102811241', 'Alok kushwaha', '', 'alok.prolabs@gmail.com', '7905018718', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '7e30adb6c34ab830690f7acec9138256', '7272506ffc21bb0abd34ba4c530fa4a0', '2021-07-27 07:49:39', '1627395579', 1, 289073, '', '7905018718', 'tryitindia@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (88, '7004983144', 'Amod Kumar', '', 'srirambhoj@gmail.com', '9234659964', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '8724aa758c2f662d79952870ef486ea6', '9a0bdd7674e3f31ff9e77f7d6fc5d2c0', '2021-07-28 08:14:19', '1627440259', 1, 131569, '', '9234659964', 'A12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (89, '6207574162', 'Shantanu kumar', '', 'Shantanukumar7562@gmail.com', '7562026045', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '3edf87bce4f5dd21020011731a82d7da', 'e75da4af499ddd0439af5726ba9d9eae', '2021-07-28 09:17:42', '1627444062', 1, 120843, '', '7562026045', 's12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (90, '6386476787', 'Saroj Singh ', '', 'singhsaroj571@gmail.com', '7518496436', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '9b955e66eb9339b1eed4fce4ff893b9d', '316a034d6250b5abcbc277a312d6074a', '2021-07-28 01:58:51', '1627460931', 1, 534051, '', '7518496436', 'tryit123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (91, '8936058495', 'Amisha ', '', 'amishakumari828@gmail.com', '7654487814', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '832dbb9272d5154ae768870db688b208', '9a1b3dd64a11d9b7a45d4fc93266ad77', '2021-07-29 08:41:06', '1627528266', 1, 895926, '', '7654487814', 'aisha1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (92, '8936058495', 'Dhruv kumar', '', 'dhruvkumar.dk5@gmail.com', '7979835482', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c8be3be0fc661008ffa807e59f723b68', '01678fefc844c7325c0a90ada4bc4eb9', '2021-07-29 09:16:10', '1627530370', 1, 217886, '', '7979835482', '9852', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (93, '7004983144', 'Abhishek kartikya', '', 'abhi.shreemahimasteelandcrocry@gmail.com', '8789638761', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'fb87582825f9d28a8d42c5e5e5e8b23d', '5ab577ac9dbd29499403a40fe6521274', '2021-07-29 10:41:15', '1627535475', 1, 210371, '', '8789638761', '1982', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (94, '8235175667', 'MD SARFRAJ', '', 'mdsarfrajmuz1993@gmail.com', '7992241588', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '85ecb8d58893e95c7471e75f40004134', '31c85ee2ec1076f95adedd35f7e06c5b', '2021-07-29 12:57:00', '1627543620', 1, 423578, '', '7992241588', '001993', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (95, '9939195269', 'Lov Prakash', '', 'kushprakash92@gmail.com', '9835153380', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '2aacded2ccca4a4772e11c171f06f1ff', '5b1324f49c00be4354546372e53fae24', '2021-07-29 06:16:59', '1627562819', 1, 296607, '', '9835153380', '983515', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (96, '9835153380', 'Manish Kumar', '', 'manishmani116@gmail.com', '8010221234', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c75c5d7d22a59dcdcb16a4b9592796d6', '8a1b08bb2168a4bf054bde41699d1754', '2021-07-29 06:18:37', '1627562917', 1, 707241, '', '8010221234', '626474', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (97, '7004983144', 'Vikas singh', '', 'viks.singh62@gmail.com', '7903611039', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '310308784bb4869f0e9fdb12ef32ffd3', 'b4631505759b75116d628d38da32694c', '2021-07-30 07:02:45', '1627651965', 1, 724564, '', '7903611039', 'mack9852', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (98, '7004983144', 'Arjun singh ', '', 'arjun.sidhwalia@gmail.com', '9386254826', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '5ed093ae5b9ec62db11520b9fc37f105', 'd89d752411772a4369ed4da63582c969', '2021-07-31 07:02:40', '1627695160', 1, 505778, '', '9386254826', 'molu', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (99, '7050096409', 'Raja kumar', '', 'kritinayakk@gmail.com', '9031291591', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '65bb26411be9ec13bead7fa7bae621da', '7eb2886bfde507d07628f853b4c994b2', '2021-07-31 04:14:16', '1627728256', 1, 789455, '', '9031291591', 'k1r2i3t4i5', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (100, '7004983144', 'Shambhu Kumar', '', 'shambhu1976muz@gmail.com', '7004565299', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '5faacf4a9c83b6b26289db673969ad6a', '33fd7fd224253b0d2f255dc9ce1b82c7', '2021-07-31 07:02:33', '1627738353', 1, 842287, '', '7004565299', '777766', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (101, '9471668022', 'Raghvendra Tiwari', '', 'raghvendratiwari504@gmail.com', '9801037453', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '7fd36aa899208e3fad251802aa73d7b0', '2021-07-31 08:06:45', '1627742205', 1, 705105, '', '9801037453', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (102, '8936058495', 'Harsh Raj', '', 'hk1087752@gmail.com', '7352028508', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '822fdc7e05bff4e30ab25573a6cf8db0', '51c9fedfedc5aaa163693015ba03d3d0', '2021-07-31 08:24:51', '1627743291', 1, 949660, '', '7352028508', 'hk1087752', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (103, '7992259617', 'Sushmita kumari', '', 'sushmitakumari692@gmail.com', '9142836671', '', 0, '', '5', '1', '843108', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'd5b4075e6fcc1c2569f3c90de182e656', '453fb5bc4fe28a8010a0e061b663ac6a', '2021-08-01 07:35:28', '1627783528', 1, 363603, '', '9142836671', 'Sona1976@', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (104, '7992259617', 'Anand kumar', '', 'sonusinghanand01@gmail.com', '7004233679', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '58825cb05cf2694bac1da9318ef90091', 'a2c0f1ac15c5de25b171aa30b53c75c7', '2021-08-01 09:13:02', '1627789382', 1, 531526, '', '7004233679', '99318', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (105, '7004233679', 'Manish kumar ', '', 'Manishmahi818@gmail.com', '6204132224', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '90389d4d0f1b2f677989224209fe1ae2', '3988a682c059ddc87a5908beef104437', '2021-08-01 09:18:12', '1627789692', 1, 667117, '', '6204132224', 'manishmahi', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (106, '7004233679', 'SHIVAM', '', 'shivam1983muz@gmail.com', '7903214726', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '95e62984b87e90645a5cf77037395959', '2b4b0567d4f34d7a7793860383844cd6', '2021-08-01 09:53:49', '1627791829', 1, 288745, '', '7903214726', '5255', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (107, '7992259617', 'Sanjay kumar', '', 'skdmka@gmail.com', '9939197125', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '88f41496a56b480e785c331f2fdf138a', 'd15432eda404888e7e23534bddeb99d8', '2021-08-01 02:10:55', '1627807255', 1, 241300, '', '9939197125', 'skdmka@@@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (108, '8102811241', 'Raj Kumar', '', 'sksantoshart@gmail.com', '9852520379', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '0ec29ebfebc8170bf981e16247ca1298', 'd54fef0a303a316b910892b1c284603d', '2021-08-01 03:51:52', '1627813312', 1, 673099, '', '9852520379', '9554', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (109, '9142836671', 'Mahesh Pandit', '', 'maheshpandit6218@gmail.com', '9773957736', '', 0, '', 'MUZAFFARPUR', '1', '843108', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6f12bc14b36b1639188db25e8554992e', 'dba84dd8496d1610007d76c60a2aed70', '2021-08-01 08:29:47', '1627829987', 1, 942029, '', '9773957736', 'mahesh6218', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (110, '6204736973', 'suraj ojha', '', 'surajojha@gmail.com', '9128372179', '', 0, '', '5', '1', '842003', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '3612bd58b02213680b27cbeffede8ebb', '2021-08-02 02:17:47', '1627894067', 1, 690155, '', '9128372179', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (111, '7004983144', 'Kumari Seema', '', 'seemakumari02439@gmail.com', '7739531880', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', 'd8c159f2ff9d2f2204815ddb1ee14628', '2021-08-02 07:18:32', '1627912112', 1, 454666, '', '7739531880', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (112, '7004983144', 'md naushad', '', 'knaushad918@gmail.com', '7013657676', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'b79325b21ac7761aac0a0f88dfb1b39b', '43b7f28e0c5208e443218740e1d84f2b', '2021-08-03 11:18:31', '1627969711', 1, 488793, '', '7013657676', 'majhaulia', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (113, '8210687557', 'Ravi Shankar kumar', '', '9934469875', '7992282859', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '956eabadf552361478751d2ddac1d570', 'c026f4aba85e6fcfa7fa6347618ec5e9', '2021-08-04 04:35:49', '1628075149', 1, 979673, '', '7992282859', 'B12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (114, '7992259617', 'Sanjay Kumar ', '', 'sanjaykr12358@gmail.com', '9431650043', '', 0, '', 'MUZAFFARPUR', '1', '842002', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '079baf1457558b6808d61a9ecc9ddef8', 'b615071b7fcc2267d6f0e13eea1c5a95', '2021-08-05 07:46:23', '1628129783', 1, 169784, '', '9431650043', '1965sanjay', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (115, '9431650043', 'Braj kishor ranjan', '', 'bkranjansjfil@gmail.com', '8409394547', 'Customer-115-960427746.jpg', 0, '', '5', '1', '842004', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '1f325804986bffc9645a3c00b13d189d', 'db79f9db83551c562b371b5a662786b3', '2021-08-05 10:56:00', '1628141160', 1, 985849, '', '8409394547', 'bkranjan3155', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (116, '9835153380', 'Chandrabhushan Prakash', '', 'chandrabhushan1225@gmail.com', '9939527762', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', 'a0c2c50a926fe6c879df3a7587293f36', '2021-08-05 10:56:43', '1628141203', 1, 512294, '', '9939527762', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (117, '9939090087', 'Niraj Kumar', '', 'putul0433@gmail.com', '8210297807', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '2c847364986a11ddeda1c6baf07a37bc', '8528630e4c66ae94747d09866d415bf4', '2021-08-05 03:05:09', '1628156109', 1, 722322, '', '8210297807', 'N12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (118, '8210297807', 'RAJESH SAH', '', 'rksah97099@gmail.com', '8709725571', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '5bd1c3728af1a8939c923907c75e015e', '2021-08-05 03:35:36', '1628157936', 1, 667303, '', '8709725571', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (119, '7004983144', 'RANJIT KUMAR', '', 'ranjitkumarahuja@gmail.com', '9835229360', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '7845a93acd4ff5a5f2cbf495c143f80d', '2021-08-05 05:57:40', '1628166460', 1, 320664, '', '9835229360', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (120, '8936058495', 'Stuti Singh', '', 'mithileshsingh18814@yahoo.com', '8936064895', 'Customer-120-745408796.jpg', 0, '', '5', '1', '842001', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '79cfac6387e0d582f83a29a04d0bcdc4', '773fafd4b8cdef3b2b24eb4f56145013', '2021-08-05 06:27:45', '1628168265', 1, 404687, '', '8936064895', 'kumar', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (121, '8936064895', 'Akshra Singh', '', 'akshrasingh2210@yahoo.com', '9905222899', 'Customer-121-352657026.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '79cfac6387e0d582f83a29a04d0bcdc4', '4813334c6f0cbff828d1620e7ae0af6d', '2021-08-05 07:19:46', '1628171386', 1, 578603, '', '9905222899', 'kumar', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (122, '7004983144', 'Rajnish Kumar', '', 'rajnishkumar83455@gmail.com', '9905739033', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '049c68ad755ee8b1944b3e3236ee6c5f', '2021-08-05 08:14:34', '1628174674', 1, 611816, '', '9905739033', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (123, '7004983144', 'Govind Kumar', '', 'govind@gmail.com', '9693148039', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '743d9cab8bd44592343b3584b33e793d', 'b56272b38ade5e31d5262d1534eb4b78', '2021-08-06 07:34:02', '1628215442', 1, 504632, '', '9693148039', 'G12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (124, '8084940179', 'Govind Kumar', '', 'govind@gmail.com', '9693147039', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '743d9cab8bd44592343b3584b33e793d', '59d53695a840f122429d0aa861dbe024', '2021-08-06 07:39:28', '1628215768', 1, 8072, '', '9693147039', 'G12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (125, '7004983144', 'Rajput Karan', '', 'rajputkarancima@gmail.com', '9142768216', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'cc67c24cea1f0135666c417a9a2d4e75', '5b34a4d49bfc3b2c758ab87fc6535d6e', '2021-08-06 07:57:57', '1628216877', 1, 801156, '', '9142768216', '630630', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (126, '9939195269', 'Baba ji', '', 'babaji@gmail.com', '9801211629', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '956eabadf552361478751d2ddac1d570', '6aed3afdb88eebdcd67d36ef8ba2147a', '2021-08-06 10:38:42', '1628226522', 1, 135843, '', '9801211629', 'B12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (127, '9931667459', 'Mrityunjay Kumar', '', 'mrityunjaymuzaffarpur@gmail.com', '9939177039', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '653cd6f9efefe6d273e2c116d2a6b765', '34360deef4a5b09086ec45f0351cf582', '2021-08-06 11:54:41', '1628231081', 1, 418190, '', '9939177039', '8199', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (128, '7004983144', 'Shyam Sharma', '', 'atrisharma1@gmail.com', '9334543228', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', '4279e7d6cf64f32a8a0670d7af5c1a6b', '2021-08-06 02:11:30', '1628239290', 1, 205933, '', '9334543228', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (129, '9334543228', 'Ram Sharma', '', 'ramgungun94@gmail.com', '9631506226', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '1bd06fd7ebd49291a5cfd576e47391bb', '2021-08-06 02:19:13', '1628239753', 1, 973537, '', '9631506226', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (130, '9835153380', 'Chhotu kumar', '', 'chhotu5470india@gmail.com', '9576244038', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', 'dc82f0d51bb0411d144ac8b2044b9cd4', '2021-08-06 05:18:42', '1628250522', 1, 119738, '', '9576244038', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (131, '9431650043', 'Pramod Kumar', '', 'pramodkumarteacher73@gmail.com', '7979041485', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '463b064e0b3c5747dfca0a48d4f800f9', '2021-08-06 06:23:41', '1628254421', 1, 490451, '', '7979041485', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (132, '7004983144', 'Dilip Kumar Thakur', '', 'dilipthakur1234321@gmail.com', '8877877602', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'f6c9abd86b0602732633367e2bd84f35', '97f6fa00febdf62dbaa79e2dea92fbd8', '2021-08-07 11:00:57', '1628314257', 1, 403564, '', '8877877602', 'D12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (133, '7004983144', 'Phani Sinha', '', 'phanibksinha@gmail.com', '8789420986', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6c9b7d9fc8fbcc03777d47ca13d7a0b2', 'd341c769ff83d410087958e27e531fdc', '2021-08-07 03:21:22', '1628329882', 1, 216545, '', '8789420986', 'phani@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (134, '9905222899', 'Navin kumar', '', 'kantienterprisesauto@gmail.com', '7488006584', 'Customer-134-658640307.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '7bf018eed1a26c4a89f8fb7ecf499799', '047b956d4014f9582af9a1b74ebfa4d8', '2021-08-07 06:57:42', '1628342862', 1, 991350, '', '7488006584', 'nihal@2002', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (135, '8936064895', 'Nitin Kumar', '', 'nitin3791@gmail.com', '9964852841', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '99620a3187da0ae11f4266eea1cf4bcb', '622cb549053d112076de05cb43d1f1c8', '2021-08-08 09:36:46', '1628395606', 1, 767891, '', '9964852841', '9934886341', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (136, '8936064895', 'Akshay Kumar', '', 'akshays1191044@gmail.com', '7541984238', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'c2a383ed010c1fbd9a6b453471a3cb21', '46a0690eed53614aa977249b02875be1', '2021-08-08 10:00:48', '1628397048', 1, 873326, '', '7541984238', 'golu6004', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (137, '7541984238', 'Damini kumari', '', 'kumaridamini29@gmail.com', '8709438362', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'a29913c910d44644d4945275809262e7', 'f7bb961c4a27b1112447af78d84317f8', '2021-08-08 10:04:12', '1628397252', 1, 939556, '', '8709438362', '8709438362', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (138, '8936064895', 'SUDERSHAN SINGH', '', 'riya03821@gmail.com', '9334094589', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '25f9e794323b453885f5181f1b624d0b', '5650e2519c23bbf8595c243f2c448043', '2021-08-08 10:45:10', '1628399710', 1, 470681, '', '9334094589', '123456789', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (139, '8936064895', 'Arun kumar Sharma', '', 'arunkumar@gmail.com', '9709568770', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '491442df5f88c6aa018e86dac21d3606', 'a31d9805adee65c4b14d08fcf12b9d69', '2021-08-08 11:16:48', '1628401608', 1, 564242, '', '9709568770', '1203', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (140, '9964852841', 'Nitesh kumar', '', 'kumarnitesh.npti@gmail.com', '7069449125', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'd666f301aeff3ee2af7b3e7c82c3656a', 'e3c5af1a7384e4dc4c7496e7088bf129', '2021-08-08 11:38:52', '1628402932', 1, 728884, '', '7069449125', '9135141688', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (141, '9939090087', 'Navin kumar nishad', '', 'navilflp72@gmail.com', '9934982684', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '1ecf85ef76aaf70c31f3379b27996bab', 'e29f9431fed9c730d62342c9e444167b', '2021-08-08 12:36:37', '1628406397', 1, 314371, '', '9934982684', 'N123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (142, '9939090087', 'SHASHI RANJAN SRIVASTSVA', '', 'shashiranjanshrivastav745@gmel.come', '7324950411', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', 'fcfbd5eb40aff1fcd213262c14c4b467', '2021-08-08 01:07:07', '1628408227', 1, 110059, '', '7324950411', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (143, '6386476787', 'Amit kumar pathak', '', 'amitpathak231217@gmail.con', '7860683831', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6950aac2d7932e1f1a4c3cf6ada1316e', '4ac28ddde4880ce412d266ca20f3f7c2', '2021-08-08 03:34:46', '1628417086', 1, 730085, '', '7860683831', '0007', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (144, '7860683831', 'Apil ', '', 'apilkumarbhuiyan@gmail.com', '8419020475', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '5c526edee401a123db1b178d7db0c6e0', '8879e99282efc21b702d98fb6c2e1564', '2021-08-08 03:38:34', '1628417314', 1, 383110, '', '8419020475', '6394097561', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (145, '8419020475', 'Rajitram', '', 'rajitramnishad0@gmail.com', '8052330561', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '65051031ae134842c054c997ced3d0db', 'fe7c395804b701f63a65a493b6571efc', '2021-08-08 03:49:49', '1628417989', 1, 592896, '', '8052330561', 'rajit1234', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (146, '7992259617', 'Rakesh Kumar', '', 'computer.worldmuz@gmail.com', '9334904141', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '9546368a81dea9bfda8218b5873c4a7d', '2a07ae78e099adfa1f32749a38daacb9', '2021-08-08 07:57:22', '1628432842', 1, 755643, '', '9334904141', 'p@ssword123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (147, '9939090087', 'Dr. Manoranjan Kumar', '', 'manoranjan1239@gmail.com', '7654353455', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6513d684b67dde5b543b017b2d0546a3', '496f6ae223f53a628e3ec9283881d625', '2021-08-08 08:01:46', '1628433106', 1, 513181, '', '7654353455', 'Dr123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (148, '7004983144', 'Chandra Shekhar Tiwari', '', 'chandan18161@gmail.com', '9934018161', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '868031028d3aaa580a176b6146f3eb5a', 'c23fb3bd62b6593631ef71327190dcdd', '2021-08-08 08:11:29', '1628433689', 1, 268714, '', '9934018161', 'C12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (149, '9934018161', 'RAGHVENDRA TIWARI', '', 'shwetiprabha4@g.mail', '9931103870', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', 'bc93d1eb98a00dff329f59268f6ae302', '2021-08-08 08:16:32', '1628433992', 1, 821399, '', '9931103870', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (150, '9905222899', 'Kapileshwar jha', '', 'kapileshwarjha1325@gmail.com', '9128806623', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'fb87582825f9d28a8d42c5e5e5e8b23d', '2e73aa0bccd9810b0880c06ddc813475', '2021-08-08 09:59:06', '1628440146', 1, 211541, '', '9128806623', '1982', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (151, '6207574162', 'Naval Kumar', '', 'nabaldas34@gmail.com', '7634039847', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '2c847364986a11ddeda1c6baf07a37bc', '6978e66c34a138fb4544e2ff77d64b69', '2021-08-09 08:50:02', '1628479202', 1, 981055, '', '7634039847', 'N12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (152, '7634039847', 'Rajesh Kumar', '', 'rajesh87220@gmail.com', '9525370899', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', 'ff74055de6f8752435ff4d0726b82b1c', '2021-08-09 08:57:05', '1628479625', 1, 689445, '', '9525370899', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (153, '9097027327', 'Nishab kumar', '', 'rajputnishab2005@gmail.com', '7903057185', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'abfbea0ea09d07b4342c5cbc8fcd745f', 'c72500583ac01f76fbfbbe1337d35e15', '2021-08-09 11:07:03', '1628487423', 1, 706583, '', '7903057185', 'rajput', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (154, '9939090087', 'Bharti Mishra', '', 'bharti0302@gmail.com', '9708853302', '', 0, '', 'MUZAFFARPUR', '1', '843108', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '1df3bdf0971907fcc119c9e360363f04', '6d788f6d2e3424c1d21d15e443292dc5', '2021-08-09 04:19:59', '1628506199', 1, 110735, '', '9708853302', 'bh123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (155, '7004983144', 'Md Shakil', '', 'mdshakil08714@gmail.com', '6202116564', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '192404bede5083e4b75dfe508acf61d8', 'db979699e4511ce862ba27405c19251d', '2021-08-09 06:01:01', '1628512261', 1, 830559, '', '6202116564', 'S12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (156, '7004983144', 'Aditya Kumar', '', 'adityakaushik12911@gmail.com', '7488764188', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'd270cfe24271f8468168fa236279b836', '46ceab4de4bb1b1069ad429d5c741c59', '2021-08-10 08:36:06', '1628564766', 1, 916723, '', '7488764188', '129110', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (157, '9939090087', 'Ashok kumar', '', 'ashokashok32877@gmail.com', '9708491927', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'db5e775a0d8dc29f63225f927a84db5e', 'b9f4e5e6964c4cb4621f04b3509b1ad9', '2021-08-10 02:57:45', '1628587665', 1, 303142, '', '9708491927', 'guru123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (158, '7992259617', 'Ritesh Kumar', '', 'riteshkmr83cup@gmail.com', '6203818802', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '6fdbc3a741c43cd732cec970a2561041', '867002c91c2ec793aeab38ea2ce0b692', '2021-08-10 02:59:26', '1628587766', 1, 732495, '', '6203818802', 'R12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (159, '6386476787', 'Kalim Siddiqui', '', 'kalimarfeen78@gmail.com', '9792465464', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '26aa049a6fea138e275672cfe5ffe4e5', 'd210b64b8f5c1dc28f1973016159edfd', '2021-08-10 03:28:45', '1628589525', 1, 168459, '', '9792465464', 'kalim7878', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (160, '7004983144', 'Akshay Kumar', '', 'ak1238496@gmail.com', '6299907015', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'fdbaea5473c35a1de35ce96a47f65b80', 'b037f3ee3cbdb484422a7d5e56257bf6', '2021-08-10 10:07:21', '1628613441', 1, 390182, '', '6299907015', '6299907015', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (161, '7488764188', 'Ashutosh Kumar ', '', 'royalboysadi@gamsil.com', '8102183836', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '827ccb0eea8a706c4c34a16891f84e7b', '52e23c90532f9a4dfbe641879e37ac6f', '2021-08-11 08:14:13', '1628649853', 1, 702092, '', '8102183836', '12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (162, '6386476787', 'Jai Prakash Kumar', '', 'jaiprakashkumar22051996@gmail.com', '9305903970', 'Customer-162-812942801.jpg', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'dc0fa7df3d07904a09288bd2d2bb5f40', '860e0e267491dfe0ff2d1d7c8ce132f0', '2021-08-11 12:16:03', '1628664363', 1, 480414, '', '9305903970', '7777777', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (163, '8409394547', 'Nidhi kumari', '', 'nidhikumari21091999@gmail.com', '7061012879', 'Customer-163-1227428869.jpg', 0, '', '5', '1', '842004', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'b38dd82dda8d64945cbd5897cafb1368', '70afc6f5b489e6cf1d1ba04fe8dcacb0', '2021-08-11 01:55:54', '1628670354', 1, 689080, '', '7061012879', '124355', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (164, '7004983144', 'Rahul Sharma', '', 'rahulsharma.srj@gmail.com', '8960941010', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4e955f5d12f29c4941a12b5eeae0f5cd', '7d357a50f0ec21f9dd6d416dea94369c', '2021-08-11 02:05:25', '1628670925', 1, 290988, '', '8960941010', 'Rahul@1993', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (165, '7004983144', 'Vijayant Thakur', '', 'vijayantkumar15@gmail.com', '7004990540', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '764c8ff9f6329a713fc2c2fccda8b14e', '08a9bd15de4089d455d5989af0bc82e1', '2021-08-11 02:54:42', '1628673882', 1, 761075, '', '7004990540', 'Manish@8696', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (166, '7061012879', 'Vijay kumar', '', 'vijay.kmr1243@gmail.com', '7352730408', '', 0, '', '5', '1', '842004', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'b38dd82dda8d64945cbd5897cafb1368', '2f5c7b3c96d62eda214d8d4206ba3234', '2021-08-11 02:55:43', '1628673943', 1, 313449, '', '7352730408', '124355', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (167, '8210179625', 'Rupesh kumar ', '', 'rupeshkumar.altos@gmail.com', '9142879079', '', 0, '', '5', '1', '843119', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '40a5f56c32b0f7427a496aa29bbcc33e', '45f833d3cf9462dbef42548e3daec854', '2021-08-11 04:13:22', '1628678602', 1, 952912, '', '9142879079', 'fdsa123456', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (168, '8409394547', 'Md Habib Ansari', '', 'mdhansari87@gmail.com', '9162646022', 'Customer-168-2003922469.jpg', 0, '', 'MUZAFFARPUR', '1', '843119', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '7bc58d32a8ac55a216d6c22f5901ec9a', '7507fd0046f19b404c578239b8b33a93', '2021-08-11 05:04:34', '1628681674', 1, 572371, '', '9162646022', 'habib786', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (169, '8052330561', 'Amardeep kumar', '', 'amardeepkumar180@gmail.com', '8299506513', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'f5cb30f30949e2f2b73be789d94ff698', '70f038e96421ee917a5d846450840260', '2021-08-11 05:43:37', '1628684017', 1, 417029, '', '8299506513', '8423956441', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (170, '8409394547', 'Manikant singh', '', 'manikantsinggh@Gmail.com', '9117759250', '', 0, '', 'MUZAFFARPUR', '1', '843323', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '802b9711ca299ba2cf0d9228ef2bcfb2', '91e7f6b164d571d38d7bf048f616b0b2', '2021-08-11 06:50:40', '1628688040', 1, 939004, '', '9117759250', '9117759250', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (171, '7004983144', 'Lal Babu prasad singh', '', 'lalbabu995565@gmail.com', '7667702006', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'a30f14412323492be7144234b6f8ab1b', 'f65cb43675c9fb964832f588c7ff14a3', '2021-08-11 08:07:53', '1628692673', 1, 506232, '', '7667702006', 'L12345', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (172, '9162646022', 'Ravindra Kumar sah', '', 'ravindrakumarsah8901@gmail.com', '8757470705', '', 0, '', 'MUZAFFARPUR', '1', '844111', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '675ddb5feceb0cca831737589bc3886d', 'b17e4bbf39cd9c52be90a64cc95862d4', '2021-08-11 10:32:11', '1628701331', 1, 430978, '', '8757470705', 'ravindra@123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (173, '8960941010', 'Mannu Kumar Singh', '', 'mannukumar18592@gmail.com', '7897275730', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '4699b0d3844bf829f9a535bb52f6a90f', '9f880ee7e80ac7652b0414c7c1fbc0b6', '2021-08-12 05:48:00', '1628727480', 1, 176269, '', '7897275730', '231217', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (174, '8409394547', 'Gudakesh', '', 'gudeshgupta@Gmail.com', '8409888556', 'Customer-174-2041182155.jpg', 0, '', 'MUZAFFARPUR', '1', '842004', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', 'e705461f5c2b635a889888babee9a91f', '4e786eeff75ae7a55fad74f4070f7bec', '2021-08-12 04:48:00', '1628767080', 1, 836412, '', '8409888556', '9097842091', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (175, '7992259617', 'Rajesh G', '', 'rajeshappan@gmail.com', '9334900495', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '976eeb8740e8024a9cd0ac5f6f7d7363', '71625f994d940803b72857c30fdf5384', '2021-08-12 05:16:55', '1628768815', 1, 113463, '', '9334900495', 'Ranavika@1', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (176, '8936064895', 'Nayan Prakash', '', 'nayanprakash17@gmail.com', '7004982268', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '634da612afdb04919cca4cd292bf678f', '5f30cb14dfe912e9f4b336e1371701bb', '2021-08-12 06:48:21', '1628774301', 1, 193545, '', '7004982268', '17october', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (177, '9939090087', 'Ram Kumar', '', 'ram08146@gmail.com', '9122181692', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '198368666f0b3a2c489a5e2bdc8332bd', '6f661f039fad0a38113f31cb25d9f20a', '2021-08-12 07:39:14', '1628777354', 1, 639539, '', '9122181692', 'ram08146', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (178, '9939090087', 'Bhabya Bharti ', '', 'Bhabyabharti953@gmail.com', '6204218979', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '472e00ccca9e607a730919f62f6144d9', 'f9ef5b3f9e9659b99e514c2bd0a1642d', '2021-08-12 08:06:52', '1628779012', 1, 325839, '', '6204218979', 'chhoti123', '1');
INSERT INTO `tbl_customer` (`cust_id`, `sponsor_id`, `cust_name`, `cust_cname`, `cust_email`, `cust_phone`, `cust_image`, `cust_country`, `cust_address`, `cust_city`, `cust_state`, `cust_zip`, `cust_b_name`, `cust_b_cname`, `cust_b_phone`, `cust_b_country`, `cust_b_address`, `cust_b_city`, `cust_b_state`, `cust_b_zip`, `cust_s_name`, `cust_s_cname`, `cust_s_phone`, `cust_s_country`, `cust_s_address`, `cust_s_city`, `cust_s_state`, `cust_s_zip`, `cust_password`, `cust_token`, `cust_datetime`, `cust_timestamp`, `cust_status`, `code`, `cust_otp`, `uid`, `pass`, `user`) VALUES (179, '7004983144', 'Yuvraj anand', '', 'hiyuvraj123@gmail.com', '9572683083', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '', '', '', 0, '', '', '', '', '824245801460da35aa346dba4d409922', '2b348ba6e90c5881514d14a6528636b2', '2021-08-12 09:39:12', '1628784552', 1, 773777, '', '9572683083', 'tryyuvraj4587.', '1');


#
# TABLE STRUCTURE FOR: tbl_customer_message
#

DROP TABLE IF EXISTS `tbl_customer_message`;

CREATE TABLE `tbl_customer_message` (
  `customer_message_id` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `order_detail` text NOT NULL,
  `cust_id` int(11) NOT NULL,
  PRIMARY KEY (`customer_message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_delivery_address
#

DROP TABLE IF EXISTS `tbl_delivery_address`;

CREATE TABLE `tbl_delivery_address` (
  `delivery_address_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(99) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(999) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pin_code` int(11) NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `addon` datetime NOT NULL,
  `updated` datetime NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`delivery_address_id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (1, '2', 'Kush Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842001, 'AT Tower Juran Chhapra Muzaffarpur', '2021-07-16 06:59:24', '2021-07-16 06:59:24', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (2, '3', 'Ram ji', '9939195269', 'Bihar', 'MUZAFFARPUR', 842002, 'Vill post karaundi soraon allahabad', '2021-07-18 06:04:04', '2021-07-18 06:04:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (3, '1', 'TryIt India', '8084940179', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-07-17 04:05:04', '2021-07-17 04:05:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (4, '5', 'Manish kr', '9711002470', 'Bihar', 'MUZAFFARPUR', 842001, '85 B, LALA KI SARAI, TELIYARGANJ', '2021-07-17 04:38:04', '2021-07-17 04:38:04', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (5, '28', 'MITHILESH KUMAR', '08210179625', 'Bihar', '', 842001, 'Majhauliya,Shivpuri colony  lane no-2 muzaffarpur,near parmanand smriti bhawan', '2021-07-25 09:13:41', '2021-07-25 09:13:41', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (6, '14', 'Abhishek Sharma', '7004983144', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzafafrpur', '2021-08-03 01:15:33', '2021-08-03 01:15:33', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (15, '95', 'Lov Prakash', '9835153380', 'Bihar', 'MUZAFFARPUR', 842002, 'Muzaffarpur', '2021-08-03 02:52:55', '2021-08-03 02:52:55', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (16, '83', 'Anand mohan', '9097027327', 'Bihar', 'MUZAFFARPUR', 842001, ' Ahiyapur Dharmkanta Hanuman mandir road near brahmsthan chakmohamad Muzaffarpur\n', '2021-08-03 02:25:02', '2021-08-03 02:25:02', 1);
INSERT INTO `tbl_delivery_address` (`delivery_address_id`, `user_id`, `name`, `phone`, `state`, `district`, `pin_code`, `address`, `addon`, `updated`, `status`) VALUES (17, '10', 'Vimal Kumar', '7992259617', 'Bihar', 'MUZAFFARPUR', 842002, 'Ram saikil niwas\nJanglimai colony, mithanpura\nMuzaffarpur', '2021-08-03 08:02:53', '2021-08-03 08:02:53', 1);


#
# TABLE STRUCTURE FOR: tbl_district
#

DROP TABLE IF EXISTS `tbl_district`;

CREATE TABLE `tbl_district` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `state` varchar(999) DEFAULT NULL,
  `district` varchar(999) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (3, '1', 'Patna', 1);
INSERT INTO `tbl_district` (`id`, `state`, `district`, `status`) VALUES (5, '1', 'MUZAFFARPUR', 1);


#
# TABLE STRUCTURE FOR: tbl_end_category
#

DROP TABLE IF EXISTS `tbl_end_category`;

CREATE TABLE `tbl_end_category` (
  `ecat_id` int(11) NOT NULL AUTO_INCREMENT,
  `ecat_pic` varchar(111) NOT NULL,
  `ecat_name` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `tcat_id` int(11) NOT NULL,
  `mcat_id` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  `status_home` int(1) NOT NULL,
  PRIMARY KEY (`ecat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (2, 'end_category-2.png', 'Vegetable', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (3, '', 'Fruits', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (4, '', 'Foodgrains, Oil & Masala', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (6, '', 'Snacks & Foods', 1, 1, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (7, '', 'Detergent Powder, Liquid & Cake', 1, 7, 1, 1);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (8, '', 'Spices ( मसालें )', 1, 1, 1, 0);
INSERT INTO `tbl_end_category` (`ecat_id`, `ecat_pic`, `ecat_name`, `tcat_id`, `mcat_id`, `status`, `status_home`) VALUES (9, '', 'Salt / Sugar / Jaggery ( नमक / चीनी / गुड़ )', 1, 1, 1, 1);


#
# TABLE STRUCTURE FOR: tbl_enquiry
#

DROP TABLE IF EXISTS `tbl_enquiry`;

CREATE TABLE `tbl_enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `property_id` varchar(999) DEFAULT NULL,
  `name` varchar(999) DEFAULT NULL,
  `phone` varchar(999) DEFAULT NULL,
  `email` varchar(999) DEFAULT NULL,
  `user_message` varchar(999) DEFAULT NULL,
  `addon` datetime DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `term_policy` varchar(99) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_faq
#

DROP TABLE IF EXISTS `tbl_faq`;

CREATE TABLE `tbl_faq` (
  `faq_id` int(11) NOT NULL AUTO_INCREMENT,
  `faq_title` varchar(255) NOT NULL,
  `faq_content` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`faq_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_language
#

DROP TABLE IF EXISTS `tbl_language`;

CREATE TABLE `tbl_language` (
  `lang_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(255) NOT NULL,
  `lang_value` text NOT NULL,
  PRIMARY KEY (`lang_id`)
) ENGINE=MyISAM AUTO_INCREMENT=164 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (1, 'Currency', '&#8377;');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (2, 'Search Product', 'Search Product');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (3, 'Search', 'Search');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (4, 'Submit', 'Submit');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (5, 'Update', 'Update');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (6, 'Read More', 'Read More');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (7, 'Serial', 'Serial');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (8, 'Photo', 'Photo');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (9, 'Login', 'Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (10, 'Customer Login', 'Customer Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (11, 'Click here to login', 'Click here to login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (12, 'Back to Login Page', 'Back to Login');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (13, 'Logged in as', 'Logged in as');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (14, 'Logout', 'Logout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (15, 'Register', 'Register');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (16, 'Customer Registration', 'Customer Registration');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (17, 'Registration Successful', 'Registration Successful');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (18, 'Cart', 'Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (19, 'View Cart', 'View Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (20, 'Update Cart', 'Update Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (21, 'Back to Cart', 'Back to Cart');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (22, 'Checkout', 'Checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (23, 'Proceed to Checkout', 'Proceed to Checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (24, 'Orders', 'Orders');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (25, 'Order History', 'Order History');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (26, 'Order Details', 'Order Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (27, 'Payment Date and Time', 'Payment Date and Time');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (28, 'Transaction ID', 'Transaction ID');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (29, 'Paid Amount', 'Paid Amount');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (30, 'Payment Status', 'Payment Status');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (31, 'Payment Method', 'Payment Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (32, 'Payment ID', 'Payment ID');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (33, 'Payment Section', 'Payment Section');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (34, 'Select Payment Method', 'Select Payment Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (35, 'Select a Method', 'Select a Method');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (36, 'PayPal', 'PayPal');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (37, 'Stripe', 'Stripe');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (38, 'Bank Deposit', 'Bank Deposit');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (39, 'Card Number', 'Card Number');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (40, 'CVV', 'CVV');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (41, 'Month', 'Month');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (42, 'Year', 'Year');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (43, 'Send to this Details', 'Send to this Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (44, 'Transaction Information', 'Transaction Information');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (45, 'Include transaction id and other information correctly', 'Include transaction id and other information correctly');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (46, 'Pay Now', 'Pay Now');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (47, 'Product Name', 'Product Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (48, 'Product Details', 'Product Details');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (49, 'Categories', 'Categories');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (50, 'Category:', 'Category:');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (51, 'All Products Under', 'All Products Under');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (52, 'Select Size', 'Select Size');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (53, 'Select Color', 'Select Color');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (54, 'Product Price', 'Product Price');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (55, 'Quantity', 'Quantity');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (56, 'Out of Stock', 'Out of Stock');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (57, 'Share This', 'Share This');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (58, 'Share This Product', 'Share This Product');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (59, 'Product Description', 'Product Description');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (60, 'Features', 'Features');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (61, 'Conditions', 'Conditions');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (62, 'Return Policy', 'Return Policy');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (63, 'Reviews', 'Reviews');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (64, 'Review', 'Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (65, 'Give a Review', 'Give a Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (66, 'Write your comment (Optional)', 'Write your comment (Optional)');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (67, 'Submit Review', 'Submit Review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (68, 'You already have given a rating!', 'You already have given a rating!');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (69, 'You must have to login to give a review', 'You must have to login to give a review');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (70, 'No description found', 'No description found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (71, 'No feature found', 'No feature found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (72, 'No condition found', 'No condition found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (73, 'No return policy found', 'No return policy found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (74, 'No Review is Found', 'No Review is Found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (75, 'Customer Name', 'Customer Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (76, 'Comment', 'Comment');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (77, 'Comments', 'Comments');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (78, 'Rating', 'Rating');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (79, 'Previous', 'Previous');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (80, 'Next', 'Next');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (81, 'Sub Total', 'Sub Total');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (82, 'Total', 'Total');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (83, 'Action', 'Action');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (84, 'Shipping Cost', 'Shipping Cost');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (85, 'Continue Shipping', 'Continue Shipping');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (86, 'Update Billing Address', 'Update Billing Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (87, 'Update Shipping Address', 'Update Shipping Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (88, 'Update Billing and Shipping Info', 'Update Billing and Shipping Info');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (89, 'Dashboard', 'Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (90, 'Welcome to the Dashboard', 'Welcome to the Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (91, 'Back to Dashboard', 'Back to Dashboard');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (92, 'Subscribe', 'Subscribe');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (93, 'Subscribe To Our Newsletter', 'Subscribe To Our Newsletter');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (94, 'Email Address', 'Email Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (95, 'Enter Your Email Address', 'Enter Your Email Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (96, 'Password', 'Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (97, 'Forget Password', 'Forget Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (98, 'Retype Password', 'Retype Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (99, 'Update Password', 'Update Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (100, 'New Password', 'New Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (101, 'Retype New Password', 'Retype New Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (102, 'Full Name', 'Full Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (103, 'Company Name', 'Company Name');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (104, 'Phone Number', 'Phone Number');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (105, 'Address', 'Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (106, 'Country', 'Country');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (107, 'City', 'City');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (108, 'State', 'State');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (109, 'Zip Code', 'Zip Code');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (110, 'About Us', 'About Us');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (111, 'Featured Posts', 'Featured Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (112, 'Popular Posts', 'Popular Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (113, 'Recent Posts', 'Recent Posts');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (114, 'Contact Information', 'Contact Information');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (115, 'Contact Form', 'Contact Form');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (116, 'Our Office', 'Our Office');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (117, 'Update Profile', 'Update Profile');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (118, 'Send Message', 'Send Message');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (119, 'Message', 'Message');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (120, 'Find Us On Map', 'Find Us On Map');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (121, 'Congratulation! Payment is successful.', 'Congratulation! Payment is successful.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (122, 'Billing and Shipping Information is updated successfully.', 'Billing and Shipping Information is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (123, 'Customer Name can not be empty.', 'Customer Name can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (124, 'Phone Number can not be empty.', 'Phone Number can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (125, 'Address can not be empty.', 'Address can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (126, 'You must have to select a country.', 'You must have to select a country.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (127, 'City can not be empty.', 'City can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (128, 'State can not be empty.', 'State can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (129, 'Zip Code can not be empty.', 'Zip Code can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (130, 'Profile Information is updated successfully.', 'Profile Information is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (131, 'Email Address can not be empty', 'Email Address can not be empty');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (132, 'Email and/or Password can not be empty.', 'Email and/or Password can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (133, 'Email Address does not match.', 'Email Address does not match.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (134, 'Email address must be valid.', 'Email address must be valid.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (135, 'You email address is not found in our system.', 'You email address is not found in our system.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (136, 'Please check your email and confirm your subscription.', 'Please check your email and confirm your subscription.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (137, 'Your email is verified successfully. You can now login to our website.', 'Your email is verified successfully. You can now login to our website.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (138, 'Password can not be empty.', 'Password can not be empty.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (139, 'Passwords does not match.', 'Password does not match.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (140, 'Please enter new and retype passwords.', 'Please enter new and retype passwords.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (141, 'Password is updated successfully.', 'Password is updated successfully.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (142, 'To reset your password, please click on the link below.', 'To reset your password, please click on the link below.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (143, 'PASSWORD RESET REQUEST - YOUR WEBSITE.COM', 'PASSWORD RESET REQUEST - YOUR WEBSITE.COM');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (144, 'The password reset email time (24 hours) has expired. Please again try to reset your password.', 'The password reset email time (24 hours) has expired. Please again try to reset your password.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (145, 'A confirmation link is sent to your email address. You will get the password reset information in there.', 'A confirmation link is sent to your email address. You will get the password reset information in there.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (146, 'Password is reset successfully. You can now login.', 'Password is reset successfully. You can now login.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (147, 'Email Address Already Exists', 'Email Address Already Exists.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (148, 'Sorry! Your account is inactive. Please contact to the administrator.', 'Sorry! Your account is inactive. Please contact to the administrator.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (149, 'Change Password', 'Change Password');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (150, 'Registration Email Confirmation for YOUR WEBSITE', 'Registration Email Confirmation for YOUR WEBSITE.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (151, 'Thank you for your registration! Your account has been created. To active your account click on the link below:', 'Thank you for your registration! Your account has been created. To active your account click on the link below:');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (152, 'Your registration is completed. Please check your email address to follow the process to confirm your registration.', 'Your registration is completed. Please check your email address to follow the process to confirm your registration.');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (153, 'No Product Found', 'No Product Found');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (154, 'Add to Cart', 'Buy Now');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (155, 'Related Products', 'Related Products');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (156, 'See all related products from below', 'See all the related products from below');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (157, 'Size', 'Size');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (158, 'Color', 'Color');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (159, 'Price', 'Price');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (160, 'Please login as customer to checkout', 'Please login as customer to checkout');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (161, 'Billing Address', 'Billing Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (162, 'Shipping Address', 'Shipping Address');
INSERT INTO `tbl_language` (`lang_id`, `lang_name`, `lang_value`) VALUES (163, 'Rating is Submitted Successfully!', 'Rating is Submitted Successfully!');


#
# TABLE STRUCTURE FOR: tbl_mid_category
#

DROP TABLE IF EXISTS `tbl_mid_category`;

CREATE TABLE `tbl_mid_category` (
  `mcat_id` int(11) NOT NULL AUTO_INCREMENT,
  `mcat_pic` varchar(111) NOT NULL,
  `mcat_name` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `tcat_id` int(11) NOT NULL,
  `status` int(1) NOT NULL,
  `status_home` int(1) NOT NULL,
  PRIMARY KEY (`mcat_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (1, 'mid_category-1.jpg', 'Grocery', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (2, 'mid_category-2.png', 'Beauty', 1, 0, 0);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (3, 'mid_category-3.png', 'Garments', 1, 0, 0);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (4, 'mid_category-4.png', 'Electronics', 1, 0, 0);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (5, 'mid_category-5.png', 'HomeCare', 1, 1, 1);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (6, 'mid_category-6.png', 'HelthCare', 1, 0, 0);
INSERT INTO `tbl_mid_category` (`mcat_id`, `mcat_pic`, `mcat_name`, `tcat_id`, `status`, `status_home`) VALUES (7, '', 'Cloth Care', 1, 0, 0);


#
# TABLE STRUCTURE FOR: tbl_order
#

DROP TABLE IF EXISTS `tbl_order`;

CREATE TABLE `tbl_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `size` varchar(100) NOT NULL,
  `color` varchar(100) NOT NULL,
  `quantity` varchar(50) NOT NULL,
  `unit_price` double NOT NULL,
  `mrp_price` float NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `pv` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (1, 495, '??? (Potato)', '1Kg', 'Red', '5', '20', '20', '1627980907', '1');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (2, 657, 'Tea Masala', '50g', '', '5', '38', '38', '1627982040', '5.7');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (3, 660, 'Sprinkalz Lucknowi Korma Masala', '50g', '', '3', '45', '45', '1627982040', '6.75');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (4, 661, 'Sprinkalz Chana Masala', '50g', '', '5', '33', '33', '1627982040', '4.95');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (5, 668, 'Sprinklz Mumbai Pav Bhaji Masala', '50g', '', '5', '27', '27', '1627982040', '4');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (6, 671, 'Sprinklz Ajwain', '100g', '', '5', '57', '57', '1627982579', '8.5');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (7, 673, 'Sprinklz Kashmiri Mirch Powder', '100g', '', '5', '54', '54', '1627982579', '8');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (8, 670, 'Sprinklz Udupi Sambhar Masala', '50g', '', '5', '27', '27', '1627982579', '4');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (9, 13, '???? ( Banana )', '1 dozen', '', '1', '35', '40', '1628001195', '5');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (10, 267, 'Maggi Hot & Sweet Tomato Chilli Sauce Bottle', '1Kg', '', '1', '95', '100', '1628001195', '5');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (11, 491, '????? (onion)', '1Kg', 'Red', '1', '40', '40', '1628001195', '2');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (12, 495, '??? (Potato)', '1Kg', 'Red', '1', '20', '20', '1628001195', '1');
INSERT INTO `tbl_order` (`id`, `product_id`, `product_name`, `size`, `color`, `quantity`, `unit_price`, `mrp_price`, `payment_id`, `pv`) VALUES (13, 509, '????? ( Tomato )', '500g', 'Red', '1', '40', '40', '1628001195', '2');


#
# TABLE STRUCTURE FOR: tbl_page
#

DROP TABLE IF EXISTS `tbl_page`;

CREATE TABLE `tbl_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `about_title` varchar(255) NOT NULL,
  `about_content` text NOT NULL,
  `about_banner` varchar(255) NOT NULL,
  `about_meta_title` varchar(255) NOT NULL,
  `about_meta_keyword` text NOT NULL,
  `about_meta_description` text NOT NULL,
  `faq_title` varchar(255) NOT NULL,
  `faq_banner` varchar(255) NOT NULL,
  `faq_meta_title` varchar(255) NOT NULL,
  `faq_meta_keyword` text NOT NULL,
  `faq_meta_description` text NOT NULL,
  `blog_title` varchar(255) NOT NULL,
  `blog_banner` varchar(255) NOT NULL,
  `blog_meta_title` varchar(255) NOT NULL,
  `blog_meta_keyword` text NOT NULL,
  `blog_meta_description` text NOT NULL,
  `contact_title` varchar(255) NOT NULL,
  `contact_banner` varchar(255) NOT NULL,
  `contact_meta_title` varchar(255) NOT NULL,
  `contact_meta_keyword` text NOT NULL,
  `contact_meta_description` text NOT NULL,
  `pgallery_title` varchar(255) NOT NULL,
  `pgallery_banner` varchar(255) NOT NULL,
  `pgallery_meta_title` varchar(255) NOT NULL,
  `pgallery_meta_keyword` text NOT NULL,
  `pgallery_meta_description` text NOT NULL,
  `vgallery_title` varchar(255) NOT NULL,
  `vgallery_banner` varchar(255) NOT NULL,
  `vgallery_meta_title` varchar(255) NOT NULL,
  `vgallery_meta_keyword` text NOT NULL,
  `vgallery_meta_description` text NOT NULL,
  `terms_title` varchar(999) NOT NULL,
  `terms_content` mediumtext NOT NULL,
  `terms_meta_title` varchar(999) NOT NULL,
  `terms_meta_keyword` varchar(999) NOT NULL,
  `terms_meta_description` varchar(999) NOT NULL,
  `privacy_policy_title` varchar(999) NOT NULL,
  `privacy_policy_content` text NOT NULL,
  `privacy_policy_meta_title` varchar(999) NOT NULL,
  `privacy_policy_meta_keyword` varchar(999) NOT NULL,
  `privacy_policy_meta_description` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_page` (`id`, `about_title`, `about_content`, `about_banner`, `about_meta_title`, `about_meta_keyword`, `about_meta_description`, `faq_title`, `faq_banner`, `faq_meta_title`, `faq_meta_keyword`, `faq_meta_description`, `blog_title`, `blog_banner`, `blog_meta_title`, `blog_meta_keyword`, `blog_meta_description`, `contact_title`, `contact_banner`, `contact_meta_title`, `contact_meta_keyword`, `contact_meta_description`, `pgallery_title`, `pgallery_banner`, `pgallery_meta_title`, `pgallery_meta_keyword`, `pgallery_meta_description`, `vgallery_title`, `vgallery_banner`, `vgallery_meta_title`, `vgallery_meta_keyword`, `vgallery_meta_description`, `terms_title`, `terms_content`, `terms_meta_title`, `terms_meta_keyword`, `terms_meta_description`, `privacy_policy_title`, `privacy_policy_content`, `privacy_policy_meta_title`, `privacy_policy_meta_keyword`, `privacy_policy_meta_description`) VALUES (1, 'About Us', '<p><span style=\"font-size: 14.4px;\">Welcome to Tryit India, your number one source for all things product. We\'re dedicated to giving you the very best of product, with a focus on tryit store, jajba gharse , service&nbsp;</span><br></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\">Founded in 2018 year by Manoj Sharma, Tryit India has come a long way from its beginnings in Muzaffarpur Bihar. When Manoj Sharma first started , passion for brand \"products\" drove them to action: quit the job, do tons of research, so that Tryit India can offer you competitive differentiator -&nbsp; \"the world\'s most advanced services\". We now serve customers all over , and are thrilled that we\'re able to turn our passion into own website.</span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\">we hope you enjoy products as much as enjoy offering them to you. If you have any questions or comments, please don\'t hesitate to contact.</span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Arial\"><span style=\"font-size: 14.4px;\"><br></span></font></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><br></p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px; font-size: 11pt; font-family: Arial; white-space: pre-wrap;\">Sincerely,</p><p style=\"box-sizing: inherit; text-rendering: geometricprecision; margin-bottom: 0px;\"><font face=\"Roboto, sans-serif\"><span style=\"font-size: 13px;\"><b>Tryit India</b></span></font><br></p><p><br></p>\r\n', 'about-banner.jpg', 'About Us || Tryit India', 'Tryit India', 'This is a page where we have described details about Tryit India', 'FAQ', 'faq-banner.jpg', 'FAQ', 'Fresh Sabji Wala', 'Fresh Sabji Wala', 'Blog', 'blog-banner.jpg', 'Ecommerce - Blog', '', '', 'Contact Us', 'contact-banner.jpg', ' Contact Us || Tryit India', 'Tryit India', 'Tryit India', 'Photo Gallery', 'pgallery-banner.jpg', 'Ecommerce - Photo Gallery', '', '', 'Video GalleryÅ«', 'vgallery-banner.jpeg', 'Ecommerce  - Video Gallery', '', '', 'Terms & Conditions', '<p><b style=\"border: 0px; margin: 0px 0px 20px; padding: 0px; font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" line-height:=\"\" 1.2em;=\"\" color:=\"\" rgb(58,=\"\" 58,=\"\" 58);=\"\" text-align:=\"\" center;\"=\"\"><span style=\"color: rgb(58, 58, 58);>Last updated:Â&nbsp;</span><span class=\" date\"=\"\">Last Updated : 2020-11-17</span></b></p><p>\r\n\r\n</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">1</span>.&nbsp;<span style=\"font-weight: 700;\">Introduction</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Welcome to Tryit India!</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">These Terms of Service govern your use of our website located at&nbsp;</font><span style=\"color: rgb(58, 58, 58); font-size: 14.4px;\">Tryit India</span><font color=\"#3a3a3a\">. (together or individually operated by&nbsp;</font><span style=\"color: rgb(58, 58, 58); font-size: 14.4px;\">Tryit India</span><span style=\"color: rgb(58, 58, 58); font-size: 0.9rem;\">.</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Our Privacy Policy also governs your use of our Service and explains how we collect, safeguard, and disclose information that results from your use of our web pages.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Your agreement with us includes these Terms and our Privacy Policy (term &amp; condition). You acknowledge that you have read and understood Agreements, and agree to be bound by them.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">If you do not agree with (or cannot comply with) Agreements, then you may not use the Service, but please let us know by emailing at&nbsp;<b>support@</b></font><span style=\"font-weight: 600; color: rgb(58, 58, 58); text-align: left;\">tryitindia.com</span><font color=\"#3a3a3a\">&nbsp;so we can try to find a solution. These Terms apply to all visitors, users, and others who wish to access or use Service.</font></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">2</span>.&nbsp;<span style=\"font-weight: 700;\">Communications</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">By using our Service, you agree to subscribe to newsletters, marketing or promotional materials, and other information we may send. However, you may opt out of receiving any, or all, of these communications from us by following the unsubscribe link or by emailing at&nbsp;<span class=\"email\" style=\"border: 0px; margin: 0px; padding: 0px;\">support@</span><span style=\"font-weight: 600; font-size: 0.9rem; text-align: left;\">tryitindia.com</span></p><div id=\"purchases\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">3</span>.&nbsp;<span style=\"font-weight: 700;\">Purchases</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">If you wish to purchase any product or service made available through Service (sale or purchase or services), you may be asked to supply certain information relevant to your Purchase including but not limited to, your credit or debit card number, the expiration date of your card, your billing address, and your shipping information.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You represent and warrant that: (i) you have the legal right to use any card(s) or other payment methods (s) in connection with any Purchase; and that (ii) the information you supply to us is true, correct, and complete.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We may employ the use of third-party services for the purpose of facilitating payment and the completion of Purchases. By submitting your information, you grant us the right to provide the information to these third parties subject to our Privacy Policy.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse or cancel your order at any time for reasons including but not limited to product or service availability, errors in the description or price of the product or service, error in your order, or other reasons.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse or cancel your order if fraud or an unauthorized or illegal transaction is suspected.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">4</span>.&nbsp;<span style=\"font-weight: 700;\">Contests, Sweepstakes, and Promotions</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Any contests, sweepstakes or other promotions (collectively) made available through Service may be governed by rules that are separate from these Terms of Service. If you participate in any Promotions, please review the applicable rules as well as our Privacy Policy. If the rules for a Promotion conflict with these Terms of Service, Promotion rules will apply.</p><div id=\"subscriptions\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"></div><div id=\"refunds\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">5</span>.&nbsp;<span style=\"font-weight: 700;\">Refunds</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We issue refunds for Contracts within&nbsp;<span style=\"font-weight: 700;\"><span class=\"refund-days\" style=\"border: 0px; margin: 0px; padding: 0px;\">1</span>&nbsp;day</span>&nbsp;of the original purchase of the Contract.</p></div><div id=\"tc-content\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">6</span>.&nbsp;<span style=\"font-weight: 700;\">Content</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">The content found on or through this Service are the property of Jajba Gharse&nbsp; or used with this permission. You may not distribute, modify, transmit, reuse, download, repost, copy, or use said Content, whether in whole or in part, for commercial purposes or for personal gain, without express advance written permission from us.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">7</span>.&nbsp;<span style=\"font-weight: 700;\">Prohibited Uses</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You may use Service only for lawful purposes and in accordance with Terms. You agree not to use Service:</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.1. In any way that violates any applicable national or international law or regulation.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.2. For the purpose of exploiting, harming, or attempting to exploit or harm minors in any way by exposing them to inappropriate content or otherwise.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.3. To transmit, or procure the sending of, any advertising or promotional material, including any junk mail, chain letter, spam, or any other similar solicitation.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.4. To impersonate or attempt to impersonate Company, a Company employee, another user, or any other person or entity.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.5. In any way that infringes upon the rights of others, or in any way is illegal, threatening, fraudulent, or harmful, or in connection with any unlawful, illegal, fraudulent, or harmful purpose or activity.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.6. To engage in any other conduct that restricts or inhibits anyone use or enjoyment of Service, or which, as determined by us, may harm or offend Company or users of Service or expose them to liability.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Additionally, you agree not to:</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.1. Use Service in any manner that could disable, overburden, damage, or impair Service or interfere with any other party use of Service, including their ability to engage in real-time activities through Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.2. Use any robot, spider, or other automatic devices, process, or means to access Service for any purpose, including monitoring or copying any of the material on Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.3. Use any manual process to monitor or copy any of the material on Service or for any other unauthorized purpose without our prior written consent.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.4. Use any device, software, or routine that interferes with the proper working of Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.5. Introduce any viruses, trojan horses, worms, logic bombs, or other material which is malicious or technologically harmful.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.6. Attempt to gain unauthorized access to, interfere with, damage, or disrupt any parts of Service, the server on which Service is stored, or any server, computer, or database connected to Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.7. Attack Service via a denial-of-service attack or a distributed denial-of-service attack.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.8. Take any action that may damage or falsify the Company rating.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.9. Otherwise attempt to interfere with the proper working of Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">8</span>.&nbsp;<span style=\"font-weight: 700;\">Analytics</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We may use third-party Service Providers to monitor and analyze the use of our Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">9</span>.&nbsp;<span style=\"font-weight: 700;\">No Use By Minors</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Service is intended only for access and use by individuals at least eighteen (18) years old. By accessing or using Service, you warrant and represent that you are at least eighteen (18) years of age and with the full authority, right, and capacity to enter into this agreement and abide by all of the terms and conditions of Terms. If you are not at least eighteen (18) years old, you are prohibited from both the access and usage of Service.</p><div id=\"account\" style=\"border: 0px; margin: 0px; padding: 0px; color: rgb(58, 58, 58); font-family: \" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">10</span>.&nbsp;<span style=\"font-weight: 700;\">Accounts</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">When you create an account with us, you guarantee that you are above the age of 18 and that the information you provide us is accurate, complete, and current at all times. Inaccurate, incomplete, or obsolete information may result in the immediate termination of your account on Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You are responsible for maintaining the confidentiality of your account and password, including but not limited to the restriction of access to your computer and/or account. You agree to accept responsibility for any and all activities or actions that occur under your account and/or password, whether your password is with our Service or a third-party service. You must notify us immediately upon becoming aware of any breach of security or unauthorized use of your account.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">You may not use as a username the name of another person or entity or that is not lawfully available for use, a name or trademark that is subject to any rights of another person or entity other than you, without appropriate authorization. You may not use as a username any name that is offensive, vulgar, or obscene.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\">We reserve the right to refuse service, terminate accounts, remove or edit content, or cancel orders at our sole discretion.</p></div><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">11</span>.&nbsp;<span style=\"font-weight: 700;\">Intellectual Property</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Service and its original content (excluding Content provided by users), features, and functionality are and will remain the exclusive property of Jajba Gharse&nbsp; and its licensors. Service is protected by copyright, trademark, and other laws of&nbsp;<span class=\"country\" style=\"border: 0px; margin: 0px; padding: 0px;\"></span>and foreign countries. Our trademarks may not be used in connection with any product or service without the prior written consent of&nbsp;<span style=\"font-size: 0.9rem;\">Jajba Gharse</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">12</span>.&nbsp;<span style=\"font-weight: 700;\">Copyright Policy</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We respect the intellectual property rights of others. It is our policy to respond to any claim that Content posted on Service infringes on the copyright or other intellectual property rights (Infringement) of any person or entity.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">If you are a copyright owner or authorized on behalf of one, and you believe that the copyrighted work has been copied in a way that constitutes copyright infringement, please submit your claim via email to&nbsp;<span class=\"email\" style=\"border: 0px; margin: 0px; padding: 0px;\">support@</span><span style=\"font-weight: 600; text-align: left;\">tryitindia.com</span>, with the subject line: Copyright Infringement and include in your claim a detailed description of the alleged Infringement as detailed below, under DMCA Notice and Procedure for Copyright Infringement Claims</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You may be held accountable for damages (including costs and attorneys fees) for misrepresentation or bad-faith claims on the infringement of any Content found on and/or through Service on your copyright.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">13</span>.&nbsp;<span style=\"font-weight: 700;\">DMCA Notice and Procedure for Copyright Infringement Claims</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You may submit a notification pursuant to the Digital Millennium Copyright Act (DMCA) by providing our Copyright Agent with the following information in writing (see 17 U.S.C 512(c)(3) for further detail):</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.1. an electronic or physical signature of the person authorized to act on behalf of the owner of the copyright interest;</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.2. a description of the copyrighted work that you claim has been infringed, including the URL (i.e., web page address) of the location where the copyrighted work exists or a copy of the copyrighted work;</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.3. identification of the URL or other specific location on Service where the material that you claim is infringing is located;</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.4. your address, telephone number, and email address;</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.5. a statement by you that you have a good faith belief that the disputed use is not authorized by the copyright owner, its agent, or the law;</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">0.6. a statement by you, made under penalty of perjury, that the above information in your notice is accurate and that you are the copyright owner or authorized to act on the copyright owner behalf.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You can contact our Copyright Agent via email at&nbsp;<span class=\"email\" style=\"border: 0px; margin: 0px; padding: 0px;\">support@</span><span style=\"font-weight: 600; text-align: left;\">tryitindia.com</span>.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">14</span>.&nbsp;<span style=\"font-weight: 700;\">Error Reporting and Feedback</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">You may provide us either directly at&nbsp;<span class=\"email\" style=\"border: 0px; margin: 0px; padding: 0px;\">support@</span><span style=\"font-weight: 600; text-align: left;\">tryitindia.com&nbsp;</span>&nbsp;or via third-party sites and tools with information and feedback concerning errors, suggestions for improvements, ideas, problems, complaints, and other matters related to our Service (Feedback). You acknowledge and agree that: (i) you shall not retain, acquire or assert any intellectual property right or other rights, title or interest in or to the Feedback; (ii) Company may have developed ideas similar to the Feedback; (iii) Feedback does not contain confidential information or proprietary information from you or any third party, and (iv) Company is not under any obligation of confidentiality with respect to the Feedback. In the event the transfer of the ownership to the Feedback is not possible due to applicable mandatory laws, you grant Company and its affiliates an exclusive, transferable, irrevocable, free-of-charge, sub-licensable, unlimited, and perpetual right to use (including copy, modify, create derivative works, publish, distribute and commercialize) Feedback in any manner and for any purpose.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">15</span>.&nbsp;<span style=\"font-weight: 700;\">Links To Other Web Sites</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Our Service may contain links to third-party websites or services that are not owned or controlled by&nbsp;<span style=\"font-size: 0.9rem;\">Jajba Gharse</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span style=\"font-size: 0.9rem;\">Jajba Gharse&nbsp;</span>&nbsp;has no control over and assumes no responsibility for the content, privacy policies, or practices of any third-party websites or services. We do not warrant the offerings of any of these entities/individuals or their websites.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">For example, the outlined&nbsp;<a href=\"https://policymaker.io/terms-and-conditions/\" style=\"border: 0px; margin: 0px; padding: 0px; transition: color 0.1s ease-in-out 0s, background-color 0.1s ease-in-out 0s; color: inherit;\">Terms of Use</a>&nbsp;have been created using&nbsp;<a href=\"https://policymaker.io/\" style=\"border: 0px; margin: 0px; padding: 0px; transition: color 0.1s ease-in-out 0s, background-color 0.1s ease-in-out 0s; color: inherit;\">PolicyMaker.io</a>, a free web application for generating high-quality legal documents. PolicyMaker&nbsp;<a href=\"https://policymaker.io/terms-and-conditions/\" style=\"border: 0px; margin: 0px; padding: 0px; transition: color 0.1s ease-in-out 0s, background-color 0.1s ease-in-out 0s; color: inherit;\">Terms and Conditions generator</a>&nbsp;is an easy-to-use free tool for creating an excellent standard Terms of Service template for a website, blog, e-commerce store, or app.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">YOU ACKNOWLEDGE AND AGREE THAT COMPANY SHALL NOT BE RESPONSIBLE OR LIABLE, DIRECTLY OR INDIRECTLY, FOR ANY DAMAGE OR LOSS CAUSED OR ALLEGED TO BE CAUSED BY OR IN CONNECTION WITH USE OF OR RELIANCE ON ANY SUCH CONTENT, GOODS OR SERVICES AVAILABLE ON OR THROUGH ANY SUCH THIRD-PARTY WEB SITES OR SERVICES.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">WE STRONGLY ADVISE YOU TO READ THE TERMS OF SERVICE AND PRIVACY POLICIES OF ANY THIRD-PARTY WEB SITES OR SERVICES THAT YOU VISIT.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">16</span>.&nbsp;<span style=\"font-weight: 700;\">Disclaimer Of Warranty</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">THESE SERVICES ARE PROVIDED BY COMPANY ON AN AS IS AND AS AVAILABLE BASIS. COMPANY MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, AS TO THE OPERATION OF THEIR SERVICES, OR THE INFORMATION, CONTENT OR MATERIALS INCLUDED THEREIN. YOU EXPRESSLY AGREE THAT YOUR USE OF THESE SERVICES, THEIR CONTENT, AND ANY SERVICES OR ITEMS OBTAINED FROM US IS AT YOUR SOLE RISK.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">NEITHER COMPANY NOR ANY PERSON ASSOCIATED WITH COMPANY MAKES ANY WARRANTY OR REPRESENTATION WITH RESPECT TO THE COMPLETENESS, SECURITY, RELIABILITY, QUALITY, ACCURACY, OR AVAILABILITY OF THE SERVICES. WITHOUT LIMITING THE FOREGOING, NEITHER COMPANY NOR ANYONE ASSOCIATED WITH COMPANY REPRESENTS OR WARRANTS THAT THE SERVICES, THEIR CONTENT, OR ANY SERVICES OR ITEMS OBTAINED THROUGH THE SERVICES WILL BE ACCURATE, RELIABLE, ERROR-FREE, OR UNINTERRUPTED, THAT DEFECTS WILL BE CORRECTED, THAT THE SERVICES OR THE SERVER THAT MAKES IT AVAILABLE ARE FREE OF VIRUSES OR OTHER HARMFUL COMPONENTS OR THAT THE SERVICES OR ANY SERVICES OR ITEMS OBTAINED THROUGH THE SERVICES WILL OTHERWISE MEET YOUR NEEDS OR EXPECTATIONS.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">COMPANY HEREBY DISCLAIMS ALL WARRANTIES OF ANY KIND, WHETHER EXPRESS OR IMPLIED, STATUTORY, OR OTHERWISE, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT, AND FITNESS FOR PARTICULAR PURPOSE.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">THE FOREGOING DOES NOT AFFECT ANY WARRANTIES WHICH CANNOT BE EXCLUDED OR LIMITED UNDER APPLICABLE LAW.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">17</span>.&nbsp;<span style=\"font-weight: 700;\">Limitation Of Liability</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">EXCEPT AS PROHIBITED BY LAW, YOU WILL HOLD US AND OUR OFFICERS, DIRECTORS, EMPLOYEES, AND AGENTS HARMLESS FOR ANY INDIRECT, PUNITIVE, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGE, HOWEVER IT ARISES (INCLUDING ATTORNEYS FEES AND ALL RELATED COSTS AND EXPENSES OF LITIGATION AND ARBITRATION, OR AT TRIAL OR ON APPEAL, IF ANY, WHETHER OR NOT LITIGATION OR ARBITRATION IS INSTITUTED), WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE, OR OTHER TORTIOUS ACTION, OR ARISING OUT OF OR IN CONNECTION WITH THIS AGREEMENT, INCLUDING WITHOUT LIMITATION ANY CLAIM FOR PERSONAL INJURY OR PROPERTY DAMAGE, ARISING FROM THIS AGREEMENT AND ANY VIOLATION BY YOU OF ANY FEDERAL, STATE, OR LOCAL LAWS, STATUTES, RULES, OR REGULATIONS, EVEN IF COMPANY HAS BEEN PREVIOUSLY ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. EXCEPT AS PROHIBITED BY LAW, IF THERE IS LIABILITY FOUND ON THE PART OF COMPANY, IT WILL BE LIMITED TO THE AMOUNT PAID FOR THE PRODUCTS AND/OR SERVICES, AND UNDER NO CIRCUMSTANCES WILL THERE BE CONSEQUENTIAL OR PUNITIVE DAMAGES. SOME STATES DO NOT ALLOW THE EXCLUSION OR LIMITATION OF PUNITIVE, INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO THE PRIOR LIMITATION OR EXCLUSION MAY NOT APPLY TO YOU.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">18</span>.&nbsp;<span style=\"font-weight: 700;\">Termination</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We may terminate or suspend your account and bar access to Service immediately, without prior notice or liability, under our sole discretion, for any reason whatsoever and without limitation, including but not limited to a breach of Terms.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">If you wish to terminate your account, you may simply discontinue using Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">All provisions of Terms which by their nature should survive termination shall survive termination, including, without limitation, ownership provisions, warranty disclaimers, indemnity and limitations of liability.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">19</span>.&nbsp;<span style=\"font-weight: 700;\">Governing Law</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">These Terms shall be governed and construed in accordance with the laws of&nbsp;<span class=\"country-name\" style=\"border: 0px; margin: 0px; padding: 0px;\">india (Bihar)</span>, which governing law applies to agreement without regard to its conflict of law provisions.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Our failure to enforce any right or provision of these Terms will not be considered a waiver of those rights. If any provision of these Terms is held to be invalid or unenforceable by a court, the remaining provisions of these Terms will remain in effect. These Terms constitute the entire agreement between us regarding our Service and supersede and replace any prior agreements we might have had between us regarding Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">20</span>.&nbsp;<span style=\"font-weight: 700;\">Changes To Service</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We reserve the right to withdraw or amend our Service, and any service or material we provide via Service, in our sole discretion without notice. We will not be liable if for any reason all or any part of Service is unavailable at any time or for any period. From time to time, we may restrict access to some parts of Service, or the entire Service, to users, including registered users.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">21</span>.&nbsp;<span style=\"font-weight: 700;\">Amendments To Terms</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">We may amend Terms at any time by posting the amended terms on this site. It is your responsibility to review these Terms periodically.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">Your continued use of the Platform following the posting of revised Terms means that you accept and agree to the changes. You are expected to check this page frequently so you are aware of any changes, as they are binding on you.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">By continuing to access or use our Service after any revisions become effective, you agree to be bound by the revised terms. If you do not agree to the new terms, you are no longer authorized to use Service.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">22</span>.&nbsp;<span style=\"font-weight: 700;\">Waiver And Severability</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">No waiver by Company of any term or condition set forth in Terms shall be deemed a further or continuing waiver of such term or condition or a waiver of any other term or condition, and any failure of Company to assert a right or provision under Terms shall not constitute a waiver of such right or provision.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">If any provision of Terms is held by a court or other tribunal of competent jurisdiction to be invalid, illegal or unenforceable for any reason, such provision shall be eliminated or limited to the minimum extent such that the remaining provisions of Terms will continue in full force and effect.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">23</span>.&nbsp;<span style=\"font-weight: 700;\">Acknowledgement</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\">BY USING SERVICE OR OTHER SERVICES PROVIDED BY THE US, YOU ACKNOWLEDGE THAT YOU HAVE READ THESE TERMS OF SERVICE AND AGREE TO BE BOUND BY THEM.</p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px; color: rgb(58, 58, 58);\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><span class=\"num\" style=\"border: 0px; margin: 0px; padding: 0px;\">24</span>.&nbsp;<span style=\"font-weight: 700;\">Contact Us</span></p><p style=\"text-align: justify; border: 0px; margin-bottom: 1.5em; padding: 0px;\" open=\"\" sans\",=\"\" sans-serif;=\"\" font-size:=\"\" 17px;\"=\"\"><font color=\"#3a3a3a\">Please send your feedback, comments, requests for technical support by email:&nbsp;<b>support@</b></font><span style=\"text-align: left;\"><font color=\"#3a3a3a\"><b>tryitindia.com</b></font></span></p>', 'Terms & Conditions || Tryit India', 'Terms & Conditions,Terms & Conditions || Tryit India', 'Welcome to Tryit India!\r\nThese terms and conditions outline the rules and regulations for the use of Tryit India\'s Website, located at https://www.shop.tryitindia.com', 'PRIVCY POLICY || Tryit India', '<p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><span style=\"margin: 0px; padding: 0px;\">Privacy Policy</span></p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We value the trust you place in us and recognize the importance of secure transactions and information privacy. This Privacy Policy describes how Jajba Gharse and its affiliates (collectively “tryit, we, our, us”) collect, use, share or otherwise process your personal information through Tryit website&nbsp;<a href=\"http://www.flipkart.com/\" style=\"margin: 0px; padding: 0px; color: inherit; border: none; outline: none;\">www.tryitindia.com</a>, its mobile application, and m-site (hereinafter referred to as the “Platform”).</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">While you may be able to browse certain sections of the Platform without registering with us, however, please note we do not offer any product/service under this Platform outside India. By visiting this Platform, providing your information or availing out product/service, you expressly agree to be bound by the terms and conditions of this Privacy Policy, the&nbsp;<a href=\"https://www.flipkart.com/pages/terms\" style=\"margin: 0px; padding: 0px; color: inherit; border: none; outline: none;\">Terms of Use</a>&nbsp;and the applicable service/product terms and conditions, and agree to be governed by the laws of India including but not limited to the laws applicable to data protection and privacy. If you do not agree please do not use or access our Platform.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><span style=\"margin: 0px; padding: 0px;\">1. Collection of Your Information</span></p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">When you use our Platform, we collect and store your information which is provided by you from time to time. In general, you can browse the Platform without telling us who you are or revealing any personal information about yourself. Once you give us your personal information, you are not anonymous to us. Where possible, we indicate which fields are required and which fields are optional. You always have the option to not provide information by choosing not to use a particular service, product or feature on the Platform.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We may track your buying behavior, preferences, and other information that you choose to provide on our Platform. We use this information to do internal research on our users\' demographics, interests, and behavior to better understand, protect and serve our users. This information is compiled and analyses on an aggregated basis. This information may include the URL that you just came from (whether this URL is on our Platform or not), which URL you next go to (whether this URL is on our Platform or not), your computer browser information, and your IP address.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">We collect personal information (such as email address, delivery address, name, phone number, credit card/debit card and other payment instrument details) from you when you set up an account or transact with us. While you can browse some sections of our Platform without being a registered member, certain activities (such as placing an order or consuming our online content or services) do require registration. We do use your contact information to send you offers based on your previous orders and your interests.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">If you choose to post messages on our message boards, chat rooms or other message areas or leave feedback or if you use voice commands to shop on the Platform, we will collect that information you provide to us. We retain this information as necessary to resolve disputes, provide customer support and troubleshoot problems as permitted by law.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\">If you send us personal correspondence, such as emails or letters, or if other users or third parties send us correspondence about your activities or postings on the Platform, we may collect such information into a file specific to you.</p><p style=\"margin: 15px 0px 0px; padding: 0px; line-height: 1.5; color: rgb(33, 33, 33); font-family: Roboto, Arial, sans-serif; font-size: 14px;\"><br></p><p>PRIVACY POLICY || Tryit India<br></p>', 'PRIVCY POLICY || Tryit India', 'PRIVACY POLICY || Tryit India', 'PRIVACY POLICY || Tryit India');


#
# TABLE STRUCTURE FOR: tbl_payment
#

DROP TABLE IF EXISTS `tbl_payment`;

CREATE TABLE `tbl_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `payment_date` varchar(50) NOT NULL,
  `txnid` varchar(255) NOT NULL,
  `paid_amount` int(11) NOT NULL,
  `card_number` varchar(50) NOT NULL,
  `card_cvv` varchar(10) NOT NULL,
  `card_month` varchar(10) NOT NULL,
  `card_year` varchar(10) NOT NULL,
  `bank_transaction_info` text NOT NULL,
  `payment_method` varchar(20) NOT NULL,
  `payment_status` varchar(25) NOT NULL,
  `shipping_status` varchar(20) NOT NULL,
  `shipping_date` varchar(999) NOT NULL,
  `delivery_date` varchar(999) NOT NULL,
  `cancelled_date` varchar(999) NOT NULL,
  `returned_date` varchar(999) NOT NULL,
  `payment_id` varchar(255) NOT NULL,
  `add_time` varchar(999) NOT NULL,
  `tpv` float NOT NULL,
  `db_id` varchar(999) NOT NULL,
  `dcode` varchar(999) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (1, 83, 'Anand mohan', 'mohananand887@gmail.com', '2021-08-03 14:25:07', '', 150, 'Dues', '', '', '', 'This Booking By COD. At 03 Aug 2021 02:25:03 PM.  ', 'COD', 'Completed', 'Delivered', '2021-08-03 14:41:23', '2021-08-03 14:58:12', '', '', '1627980907', '', '5', '9939195269', '7818');
INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (2, 95, 'Lov Prakash', 'kushprakash92@gmail.com', '2021-08-03 14:44:00', '', 625, 'Dues', '', '', '', 'This Booking By COD. At 03 Aug 2021 02:43:52 PM.  ', 'COD', 'Completed', 'Delivered', '2021-08-03 15:27:31', '2021-08-03 15:43:14', '', '', '1627982040', '', '93.5', '9939195269', '1235');
INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (3, 95, 'Lov Prakash', 'kushprakash92@gmail.com', '2021-08-03 14:52:59', '', 190, 'Dues', '', '', '', 'This Booking By COD. At 03 Aug 2021 02:52:11 PM.  ', 'COD', 'Completed', 'Arrive', '2021-08-03 15:43:24', '', '', '', '1627982579', '', '102.5', '9939195269', '5399');
INSERT INTO `tbl_payment` (`id`, `customer_id`, `customer_name`, `customer_email`, `payment_date`, `txnid`, `paid_amount`, `card_number`, `card_cvv`, `card_month`, `card_year`, `bank_transaction_info`, `payment_method`, `payment_status`, `shipping_status`, `shipping_date`, `delivery_date`, `cancelled_date`, `returned_date`, `payment_id`, `add_time`, `tpv`, `db_id`, `dcode`) VALUES (4, 10, 'Vimal Kumar', 'biharbhakti.vimal@gmail.com', '2021-08-03 20:03:15', '', 230, 'Dues', '', '', '', 'This Booking By COD. At 03 Aug 2021 08:03:03 PM.  ', 'COD', 'Completed', 'Cancelled', '', '', '2021-08-04 05:27:50', '', '1628001195', '', '15', '', '9885');


#
# TABLE STRUCTURE FOR: tbl_photo
#

DROP TABLE IF EXISTS `tbl_photo`;

CREATE TABLE `tbl_photo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `caption` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `title` varchar(111) DEFAULT NULL,
  `link` varchar(111) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_pin
#

DROP TABLE IF EXISTS `tbl_pin`;

CREATE TABLE `tbl_pin` (
  `pin_id` int(11) NOT NULL AUTO_INCREMENT,
  `pin` int(11) NOT NULL,
  `addon` datetime NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`pin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (1, 842001, '2021-07-16 18:56:35', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (2, 842002, '2021-07-16 18:56:45', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (3, 842003, '2021-07-16 18:56:53', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (4, 842004, '2021-07-22 14:54:00', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (5, 842005, '2021-07-22 14:54:12', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (6, 843108, '2021-07-22 14:54:29', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (7, 843113, '2021-07-22 14:56:39', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (8, 843147, '2021-07-22 14:57:00', 1);
INSERT INTO `tbl_pin` (`pin_id`, `pin`, `addon`, `status`) VALUES (9, 843165, '2021-07-22 14:57:38', 1);


#
# TABLE STRUCTURE FOR: tbl_post
#

DROP TABLE IF EXISTS `tbl_post`;

CREATE TABLE `tbl_post` (
  `post_id` int(11) NOT NULL AUTO_INCREMENT,
  `post_title` varchar(255) NOT NULL,
  `post_slug` varchar(255) NOT NULL,
  `post_content` text NOT NULL,
  `post_date` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `category_id` int(11) NOT NULL,
  `total_view` int(11) NOT NULL,
  `meta_title` varchar(255) NOT NULL,
  `meta_keyword` text NOT NULL,
  `meta_description` text NOT NULL,
  PRIMARY KEY (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tbl_product
#

DROP TABLE IF EXISTS `tbl_product`;

CREATE TABLE `tbl_product` (
  `p_id` int(11) NOT NULL AUTO_INCREMENT,
  `p_name` varchar(255) CHARACTER SET utf8mb4 NOT NULL,
  `tags` text CHARACTER SET utf8mb4 NOT NULL,
  `p_keyword` text CHARACTER SET utf8mb4 NOT NULL,
  `p_old_price` varchar(10) NOT NULL,
  `p_current_price` varchar(10) NOT NULL,
  `p_qty` int(10) NOT NULL,
  `p_featured_photo` varchar(255) NOT NULL,
  `p_description` text NOT NULL,
  `p_short_description` text NOT NULL,
  `p_feature` text NOT NULL,
  `p_condition` text NOT NULL,
  `p_return_policy` text NOT NULL,
  `p_total_view` int(11) NOT NULL,
  `p_is_featured` int(1) NOT NULL,
  `p_is_active` int(1) NOT NULL,
  `p_is_active_home` int(11) NOT NULL,
  `todays_best_deal` int(11) NOT NULL,
  `tcat_id` int(11) NOT NULL,
  `mcat_id` int(11) NOT NULL,
  `ecat_id` int(11) NOT NULL,
  `user` varchar(110) NOT NULL,
  `p_type` int(11) DEFAULT NULL,
  `sett` int(110) NOT NULL,
  PRIMARY KEY (`p_id`)
) ENGINE=InnoDB AUTO_INCREMENT=699 DEFAULT CHARSET=latin1;

INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (11, 'Anar/ अनार / Pomegranate', 'Anar/ अनार / Pomegranate', 'Anar/ अनार / Pomegranate', '', '100', 1, 'product-featured-11.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 35, 1, 1, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (13, 'केला ( Banana )', 'केला ( Banana )', 'केला ( Banana )', '', '', 1, 'product-featured-13.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 41, 0, 1, 0, 1, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (14, 'Kiwi', 'Kiwi', 'Kiwi', '', '', 0, 'product-featured-14.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 23, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (15, 'Kashmiri Apple', 'Kashmiri Apple', 'Kashmiri Apple', '', '', 0, 'product-featured-15.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 17, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (16, 'Himachal Apple ', 'Himachal Apple ', 'Himachal Apple ', '', '', 0, 'product-featured-16.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 19, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (17, 'Shimla Apple', 'Shimla Apple', 'Shimla Apple', '', '', 0, 'product-featured-17.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 19, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (18, 'Red Gold Apple', 'Red Gold Apple', 'Red Gold Apple', '', '', 0, 'product-featured-18.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 85, 1, 0, 1, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (20, 'Mosammi', 'Mosammi', 'Mosammi', '', '', 0, 'product-featured-20.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 14, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (21, 'Papaya', 'Papaya', 'Papaya', '', '', 2, 'product-featured-21.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 47, 1, 0, 1, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (22, 'Orange', 'Orange', 'Orange', '', '', 1, 'product-featured-22.png', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 32, 1, 0, 1, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (23, 'Tender Coconut', 'Tender Coconut', 'Tender Coconut', '', '', 0, 'product-featured-23.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 38, 1, 0, 1, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (24, ' MALDE / Mango', ' MALDE / Mango', ' MALDE / Mango', '', '', 0, 'product-featured-24.png', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 22, 1, 0, 1, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (25, 'Guava', 'Guava', 'Guava', '', '', 0, 'product-featured-25.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 18, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (26, 'Litchi', 'Litchi', 'Litchi', '', '', 0, 'product-featured-26.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 27, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (27, 'Watermelon', 'Watermelon', 'Watermelon', '', '', 0, 'product-featured-27.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 14, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (28, 'Muskmelon', 'Muskmelon', 'Muskmelon', '', '', 0, 'product-featured-28.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (30, 'Grapes', 'Grapes', 'Grapes', '', '', 0, 'product-featured-30.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 94, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (31, 'Black Grapes', 'Black Grapes', 'Black Grapes', '', '', 0, 'product-featured-31.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 12, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (32, 'Pear', 'Pear', 'Pear', '', '', 0, 'product-featured-32.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (33, 'Pomelo ( Gagal)', 'Pomelo ( Gagal)', 'Pomelo ( Gagal)', '', '', 0, 'product-featured-33.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 22, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (34, 'BlackBerry', 'BlackBerry', 'BlackBerry', '', '', 0, 'product-featured-34.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 28, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (35, 'Sugar Apple', 'Sugar Apple', 'Sugar Apple', '', '', 0, 'product-featured-35.jpeg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 21, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (36, 'Malta', 'Malta', 'Malta', '', '', 0, 'product-featured-36.png', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 44, 0, 0, 0, 0, 1, 1, 3, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (38, 'Beetroot / Chukandar / चुकंदर', 'Beetroot / Chukandar / चुकंदर', 'Beetroot / Chukandar / चुकंदर', '', '', 0, 'product-featured-38.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 26, 1, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (40, 'Horlicks Classic Malt', 'Horlicks Classic Malt', 'Horlicks Classic Malt', '', '', 1, 'product-featured-40.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 16, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (41, 'Bournvita', 'Bournvita', 'Bournvita', '', '', 0, 'product-featured-41.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (42, 'Complan Chocolate', 'Complan Chocolate', 'Complan Chocolate', '', '', 0, 'product-featured-42.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 17, 1, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (43, 'Chocolate Syrup Hershey\'s', 'Chocolate Syrup Hershey\'s', 'Chocolate Syrup Hershey\'s', '', '', 0, 'product-featured-43.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (45, 'Horlicks Classic Malt 2 Kg', 'Horlicks Classic Malt 2 Kg', 'Horlicks Classic Malt 2 Kg', '', '', 0, 'product-featured-45.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (46, 'PediaSure Premium Chocolate', 'PediaSure Premium Chocolate', 'PediaSure Premium Chocolate', '', '', 0, 'product-featured-46.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (47, 'Badam Flavour Horlicks Lite', 'Badam Flavour Horlicks Lite', 'Badam Flavour Horlicks Lite', '', '', 0, 'product-featured-47.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (48, 'Regular Malt jar', 'Regular Malt jar', 'Regular Malt jar', '', '', 0, 'product-featured-48.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (49, 'Chocolate Delight Horlicks', 'Chocolate Delight Horlicks', 'Chocolate Delight Horlicks', '', '', 0, 'product-featured-49.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 10, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (50, 'Women Horlicks', 'Women Horlicks', 'Women Horlicks', '', '', 0, 'product-featured-50.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (51, 'Bournvita Jar', 'Bournvita Jar', 'Bournvita Jar', '', '', 0, 'product-featured-51.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 22, 1, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (52, 'Nestle Nangrow 2-5 years', 'Nestle Nangrow 2-5 years', 'Nestle Nangrow 2-5 years', '', '', 0, 'product-featured-52.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 19, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (53, 'Protinex Tasty Chocolate Flavour', 'Protinex Tasty Chocolate Flavour', 'Protinex Tasty Chocolate Flavour', '', '', 0, 'product-featured-53.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (54, 'Glucose D Jar', 'Glucose D Jar', 'Glucose D Jar', '', '', 0, 'product-featured-54.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (55, 'Boost Jar', 'Boost Jar', 'Boost Jar', '', '', 0, 'product-featured-55.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (56, 'Glucose D Jar', 'Glucose D Jar', 'Glucose D Jar', '', '', 0, 'product-featured-56.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (57, 'Horlicks Protein+ Vanilla', 'Horlicks Protein+ Vanilla', 'Horlicks Protein+ Vanilla', '', '', 0, 'product-featured-57.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (59, 'Red Lebel Tea', 'Red Lebel Tea', 'Red Lebel Tea', '', '', 0, 'product-featured-59.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (60, 'Bisleri Mineral Water', 'Bisleri Mineral Water', 'Bisleri Mineral Water', '', '', 1, 'product-featured-60.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (61, 'TATA Gold', 'TATA Gold', 'TATA Gold', '', '', 0, 'product-featured-61.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (62, 'Mineral Water Bisleri', 'Mineral Water Bisleri', 'Mineral Water Bisleri', '', '', 0, 'product-featured-62.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (63, 'Mineral Water Bisleri', 'Mineral Water Bisleri', 'Mineral Water Bisleri', '', '', 0, 'product-featured-63.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (65, 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', '', '', 0, 'product-featured-65.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (66, 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', '', '', 0, 'product-featured-66.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (67, 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', 'Aqwafina Packed Drinking Water', '', '', 0, 'product-featured-67.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (68, 'Aqwafina 12', 'Aqwafina 12', 'Aqwafina 12', '', '', 0, 'product-featured-68.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (69, 'Aqwafina 500ml 24 pieces', 'Aqwafina 500ml 24 pieces', 'Aqwafina 500ml 24 pieces', '', '', 0, 'product-featured-69.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (70, 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', '', '', 0, 'product-featured-70.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (71, 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', '', '', 0, 'product-featured-71.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (72, 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', 'Kinley Water with Added Minerals', '', '', 0, 'product-featured-72.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (73, 'Tea - Nature care', 'Tea - Nature care', 'Tea - Nature care', '', '', 0, 'product-featured-73.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (74, 'Tea', 'Tea', 'Tea', '', '', 0, 'product-featured-74.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (75, 'Wagh Bakri Premium', 'Wagh Bakri Premium', 'Wagh Bakri Premium', '', '', 0, 'product-featured-75.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (76, 'TATA Tea kanan devan', 'TATA Tea kanan devan', 'TATA Tea kanan devan', '', '', 0, 'product-featured-76.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (77, 'Tea - Golden Leaf', 'Tea - Golden Leaf', 'Tea - Golden Leaf', '', '', 0, 'product-featured-77.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (78, 'TATA Tea - Strong', 'TATA Tea - Strong', 'TATA Tea - Strong', '', '', 0, 'product-featured-78.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (79, 'Tata Tea Premium , 1 Kg', 'Tata Tea Premium , 1 Kg', 'Tata Tea Premium , 1 Kg', '', '', 0, 'product-featured-79.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (80, 'Honey Lemon Green Tea Bag 35g (25 Bag 1.4g Each', 'Honey Lemon Green Tea Bag 35g (25 Bag 1.4g Each', 'Honey Lemon Green Tea Bag 35g (25 Bag 1.4g Each', '', '', 0, 'product-featured-80.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (81, 'Darjiling Tea ', 'Darjiling Tea ', 'Darjiling Tea ', '', '', 0, 'product-featured-81.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (82, 'Sprite Soft Drink', 'Sprite Soft Drink', 'Sprite Soft Drink', '', '', 0, 'product-featured-82.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 12, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (83, 'Sprite Soft Drink', 'Sprite Soft Drink', 'Sprite Soft Drink', '', '', 1, 'product-featured-83.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (84, 'Dust Tea', 'Dust Tea', 'Dust Tea', '', '', 0, 'product-featured-84.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (85, 'Thums Up 2L Bottle', 'Thums Up 2L Bottle', 'Thums Up 2L Bottle', '', '', 0, 'product-featured-85.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (86, 'Thums Up 750ml Bottle', 'Thums Up 750ml Bottle', 'Thums Up 750ml Bottle', '', '', 0, 'product-featured-86.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (87, 'Thums Up 1.25L Bottle', 'Thums Up 1.25L Bottle', 'Thums Up 1.25L Bottle', '', '', 0, 'product-featured-87.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (88, 'Thums Up  300ml Can', 'Thums Up  300ml Can', 'Thums Up  300ml Can', '', '', 0, 'product-featured-88.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (89, 'Mountain Dew 250ml Can', 'Mountain Dew 250ml Can', 'Mountain Dew 250ml Can', '', '', 0, 'product-featured-89.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (90, 'Instant Coffee -  200g. Pouch', 'Instant Coffee -  200g. Pouch', 'Instant Coffee -  200g. Pouch', '', '', 0, 'product-featured-90.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (91, 'Pepsi 250ml Can', 'Pepsi 250ml Can', 'Pepsi 250ml Can', '', '', 0, 'product-featured-91.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (92, 'Pepsi 250ml Can', 'Pepsi 250ml Can', 'Pepsi 250ml Can', '', '', 0, 'product-featured-92.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (93, 'Classic Coffee  - Glass Jar', 'Classic Coffee  - Glass Jar', 'Classic Coffee  - Glass Jar', '', '', 0, 'product-featured-93.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (94, '7Up 2.25 L Bottle', '7Up 2.25 L Bottle', '7Up 2.25 L Bottle', '', '', 0, 'product-featured-94.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (95, 'Classic Coffee. - 200g , stabilo', 'Classic Coffee. - 200g , stabilo', 'Classic Coffee. - 200g , stabilo', '', '', 0, 'product-featured-95.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (96, 'Pepsi 750ml Bottle', 'Pepsi 750ml Bottle', 'Pepsi 750ml Bottle', '', '', 0, 'product-featured-96.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (97, 'Instant Coffee  - Classic 50g  Glass Jar', 'Instant Coffee  - Classic 50g  Glass Jar', 'Instant Coffee  - Classic 50g  Glass Jar', '', '', 0, 'product-featured-97.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (98, 'Pepsi 2.25 L Bottle', 'Pepsi 2.25 L Bottle', 'Pepsi 2.25 L Bottle', '', '', 0, 'product-featured-98.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (99, 'Mirinda 2.25 L', 'Mirinda 2.25 L', 'Mirinda 2.25 L', '', '', 0, 'product-featured-99.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (100, 'Pepsi Black 250 ml Can', 'Pepsi Black 250 ml Can', 'Pepsi Black 250 ml Can', '', '', 0, 'product-featured-100.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (101, 'Coca Cola 750 ml', 'Coca Cola 750 ml', 'Coca Cola 750 ml', '', '', 0, 'product-featured-101.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (102, 'Coca Cola 2 L', 'Coca Cola 2 L', 'Coca Cola 2 L', '', '', 0, 'product-featured-102.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (103, '7Up Lemon 750 ml', '7Up Lemon 750 ml', '7Up Lemon 750 ml', '', '', 0, 'product-featured-103.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (104, 'Monster Mango Loco 350 ml', 'Monster Mango Loco 350 ml', 'Monster Mango Loco 350 ml', '', '', 0, 'product-featured-104.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (105, 'Mountain Dew 750 ml', 'Mountain Dew 750 ml', 'Mountain Dew 750 ml', '', '', 0, 'product-featured-105.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (106, 'Kingfisher Radler 300 ml Can', 'Kingfisher Radler 300 ml Can', 'Kingfisher Radler 300 ml Can', '', '', 0, 'product-featured-106.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (107, '7Up Lemon 250 ml Can', '7Up Lemon 250 ml Can', '7Up Lemon 250 ml Can', '', '', 0, 'product-featured-107.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (108, 'Masti Buttermilk -  spice 200ml Cartoon', 'Masti Buttermilk -  spice 200ml Cartoon', 'Masti Buttermilk -  spice 200ml Cartoon', '', '', 0, 'product-featured-108.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (109, 'Heineken Beer Non Alcohol 330 ml Can', 'Heineken Beer Non Alcohol 330 ml Can', 'Heineken Beer Non Alcohol 330 ml Can', '', '', 0, 'product-featured-109.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (110, 'Frooti', 'Frooti', 'Frooti', '', '', 0, 'product-featured-110.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (111, 'Sprite Lime Flavour 300 ml Can', 'Sprite Lime Flavour 300 ml Can', 'Sprite Lime Flavour 300 ml Can', '', '', 0, 'product-featured-111.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (112, 'Fruit Juice', 'Fruit Juice', 'Fruit Juice', '', '', 0, 'product-featured-112.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (113, 'Red Bull 250 ml Can', 'Red Bull 250 ml Can', 'Red Bull 250 ml Can', '', '', 0, 'product-featured-113.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (114, 'Red Bull 350 ml Can', 'Red Bull 350 ml Can', 'Red Bull 350 ml Can', '', '', 0, 'product-featured-114.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (115, 'Fruit Juice -  Delight , Guava', 'Fruit Juice -  Delight , Guava', 'Fruit Juice -  Delight , Guava', '', '', 0, 'product-featured-115.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (116, 'Coca Cola 300 ml Can', 'Coca Cola 300 ml Can', 'Coca Cola 300 ml Can', '', '', 0, 'product-featured-116.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (117, 'Monster Energy Drink 350 ml Can', 'Monster Energy Drink 350 ml Can', 'Monster Energy Drink 350 ml Can', '', '', 0, 'product-featured-117.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (118, 'Maza , Mango Juice', 'Maza , Mango Juice', 'Maza , Mango Juice', '', '', 0, 'product-featured-118.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (119, 'Limca Lime & Lemon 2 L ', 'Limca Lime & Lemon 2 L ', 'Limca Lime & Lemon 2 L ', '', '', 0, 'product-featured-119.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (120, 'Limca Lime & Lemon 750 ml', 'Limca Lime & Lemon 750 ml', 'Limca Lime & Lemon 750 ml', '', '', 0, 'product-featured-120.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (121, 'Pulpy Orange - PET  Bottle', 'Pulpy Orange - PET  Bottle', 'Pulpy Orange - PET  Bottle', '', '', 0, 'product-featured-121.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (122, 'Coca Cola Diet Coke 300 ml', 'Coca Cola Diet Coke 300 ml', 'Coca Cola Diet Coke 300 ml', '', '', 0, 'product-featured-122.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (123, 'Minute Made , Pulpy Orange', 'Minute Made , Pulpy Orange', 'Minute Made , Pulpy Orange', '', '', 0, 'product-featured-123.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (124, 'Appy Fizz 250 ml Bottle', 'Appy Fizz 250 ml Bottle', 'Appy Fizz 250 ml Bottle', '', '', 0, 'product-featured-124.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (125, 'Appy Fizz 1L Bottle', 'Appy Fizz 1L Bottle', 'Appy Fizz 1L Bottle', '', '', 0, 'product-featured-125.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (126, 'Amul, Lassi', 'Amul, Lassi', 'Amul, Lassi', '', '', 0, 'product-featured-126.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (127, 'Appy Fizz 600ml Bottle', 'Appy Fizz 600ml Bottle', 'Appy Fizz 600ml Bottle', '', '', 0, 'product-featured-127.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (128, 'Fanta Orange Flavour 2 L', 'Fanta Orange Flavour 2 L', 'Fanta Orange Flavour 2 L', '', '', 0, 'product-featured-128.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (129, 'Fanta Orange Flavour 750 ml', 'Fanta Orange Flavour 750 ml', 'Fanta Orange Flavour 750 ml', '', '', 0, 'product-featured-129.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (130, 'Fanta Orange Flavour 1.25 L', 'Fanta Orange Flavour 1.25 L', 'Fanta Orange Flavour 1.25 L', '', '', 0, 'product-featured-130.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (131, 'Radler Mint & Lime 300ml Kingfisher', 'Radler Mint & Lime 300ml Kingfisher', 'Radler Mint & Lime 300ml Kingfisher', '', '', 0, 'product-featured-131.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (132, '7Up Nimbooz', '7Up Nimbooz', '7Up Nimbooz', '', '', 0, 'product-featured-132.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (133, 'Tropicana Delight Litchi', 'Tropicana Delight Litchi', 'Tropicana Delight Litchi', '', '', 0, 'product-featured-133.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (134, 'Apple Juice', 'Apple Juice', 'Apple Juice', '', '', 0, 'product-featured-134.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (135, 'Real Orange ', 'Real Orange ', 'Real Orange ', '', '', 0, 'product-featured-135.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (136, 'Paper Boat Aamras  , fruit Juice', 'Paper Boat Aamras  , fruit Juice', 'Paper Boat Aamras  , fruit Juice', '', '', 0, 'product-featured-136.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (137, 'Real Litchi , Fruit Juice', 'Real Litchi , Fruit Juice', 'Real Litchi , Fruit Juice', '', '', 0, 'product-featured-137.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (138, 'Tang Orange , Pouch', 'Tang Orange , Pouch', 'Tang Orange , Pouch', '', '', 0, 'product-featured-138.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (139, 'Tropicana Delight Apple Juice', 'Tropicana Delight Apple Juice', 'Tropicana Delight Apple Juice', '', '', 0, 'product-featured-139.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (140, 'Paper Boat Lychee Ras', 'Paper Boat Lychee Ras', 'Paper Boat Lychee Ras', '', '', 0, 'product-featured-140.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (141, 'Real Mango Fruit Juice', 'Real Mango Fruit Juice', 'Real Mango Fruit Juice', '', '', 0, 'product-featured-141.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (142, 'Real Juice mix Fruit', 'Real Juice mix Fruit', 'Real Juice mix Fruit', '', '', 0, 'product-featured-142.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (143, 'Slice Mango', 'Slice Mango', 'Slice Mango', '', '', 0, 'product-featured-143.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (144, 'Real Fruit Apple', 'Real Fruit Apple', 'Real Fruit Apple', '', '', 0, 'product-featured-144.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (145, 'Appy Fizz', 'Appy Fizz', 'Appy Fizz', '', '', 0, 'product-featured-145.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (146, 'Appy Fizz', 'Appy Fizz', 'Appy Fizz', '', '', 0, 'product-featured-146.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (147, 'Appy Fizz', 'Appy Fizz', 'Appy Fizz', '', '', 0, 'product-featured-147.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (148, 'Tang Lemon , Pouch', 'Tang Lemon , Pouch', 'Tang Lemon , Pouch', '', '', 0, 'product-featured-148.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (149, 'Paper Boat Jaljeera', 'Paper Boat Jaljeera', 'Paper Boat Jaljeera', '', '', 0, 'product-featured-149.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (150, 'Paper Boat, Aanar', 'Paper Boat, Aanar', 'Paper Boat, Aanar', '', '', 0, 'product-featured-150.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (151, 'Amul Cool , Kesar', 'Amul Cool , Kesar', 'Amul Cool , Kesar', '', '', 0, 'product-featured-151.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (152, 'Amul Cafe ', 'Amul Cafe ', 'Amul Cafe ', '', '', 0, 'product-featured-152.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (153, 'Mango Frooti', 'Mango Frooti', 'Mango Frooti', '', '', 0, 'product-featured-153.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (154, 'Mango Frooti ', 'Mango Frooti ', 'Mango Frooti ', '', '', 0, 'product-featured-154.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (155, 'Real ,Grape', 'Real ,Grape', 'Real ,Grape', '', '', 0, 'product-featured-155.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (156, 'Dairy Milk Silk', 'Dairy Milk Silk', 'Dairy Milk Silk', '', '', 1, 'product-featured-156.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (157, 'Dairy Milk Silk', 'Dairy Milk Silk', 'Dairy Milk Silk', '', '', 0, 'product-featured-157.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (158, 'Dark Chocolate Amul', 'Dark Chocolate Amul', 'Dark Chocolate Amul', '', '', 0, 'product-featured-158.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (159, 'Dairy Milk Minis 126g', 'Dairy Milk Minis 126g', 'Dairy Milk Minis 126g', '', '', 0, 'product-featured-159.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (160, 'Amul Chocominis', 'Amul Chocominis', 'Amul Chocominis', '', '', 0, 'product-featured-160.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (161, 'Dairy Milk 23g', 'Dairy Milk 23g', 'Dairy Milk 23g', '', '', 1, 'product-featured-161.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 18, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (162, 'KitKat 4 Finger 37.3 g', 'KitKat 4 Finger 37.3 g', 'KitKat 4 Finger 37.3 g', '', '', 0, 'product-featured-162.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (163, 'Milk Chocolate Amul', 'Milk Chocolate Amul', 'Milk Chocolate Amul', '', '', 0, 'product-featured-163.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (164, 'Dairy Milk Crackle 36g', 'Dairy Milk Crackle 36g', 'Dairy Milk Crackle 36g', '', '', 0, 'product-featured-164.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 10, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (165, 'Bournville Cranberry', 'Bournville Cranberry', 'Bournville Cranberry', '', '', 1, 'product-featured-165.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (166, 'Gems 21.36g', 'Gems 21.36g', 'Gems 21.36g', '', '', 1, 'product-featured-166.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 13, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (167, 'Dairy Milk 50g', 'Dairy Milk 50g', 'Dairy Milk 50g', '', '', 0, 'product-featured-167.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (168, 'Fruit & Nut Dairy Milk 36g', 'Fruit & Nut Dairy Milk 36g', 'Fruit & Nut Dairy Milk 36g', '', '', 0, 'product-featured-168.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (169, 'Fruit & Nut Dairy Milk ', 'Fruit & Nut Dairy Milk ', 'Fruit & Nut Dairy Milk ', '', '', 0, 'product-featured-169.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (170, 'Milk Chocolate Amul', 'Milk Chocolate Amul', 'Milk Chocolate Amul', '', '', 0, 'product-featured-170.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 13, 1, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (171, '5Star Cadbury', '5Star Cadbury', '5Star Cadbury', '', '', 0, 'product-featured-171.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (172, 'Cadbury Gems 8.9g', 'Cadbury Gems 8.9g', 'Cadbury Gems 8.9g', '', '', 0, 'product-featured-172.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (173, 'Dairy Milk Silk Oreo ', 'Dairy Milk Silk Oreo ', 'Dairy Milk Silk Oreo ', '', '', 0, 'product-featured-173.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (174, 'KitKat 3 Finger 27.5g', 'KitKat 3 Finger 27.5g', 'KitKat 3 Finger 27.5g', '', '', 0, 'product-featured-174.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (175, 'Kinder Joy Girls 20g', 'Kinder Joy Girls 20g', 'Kinder Joy Girls 20g', '', '', 0, 'product-featured-175.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (176, 'Cadbury Fuse 48g', 'Cadbury Fuse 48g', 'Cadbury Fuse 48g', '', '', 0, 'product-featured-176.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (177, 'Nestle Munch Crisp Pop 20.1g', 'Nestle Munch Crisp Pop 20.1g', 'Nestle Munch Crisp Pop 20.1g', '', '', 0, 'product-featured-177.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (178, 'Dairy Milk Silk Oreo ', 'Dairy Milk Silk Oreo ', 'Dairy Milk Silk Oreo ', '', '', 0, 'product-featured-178.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (179, 'Crunch \'O\' Nuts Munch 32g', 'Crunch \'O\' Nuts Munch 32g', 'Crunch \'O\' Nuts Munch 32g', '', '', 0, 'product-featured-179.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (180, 'Munch Nuts Nestle 35.2g Crunchy Wafer Bar', 'Munch Nuts Nestle 35.2g Crunchy Wafer Bar', 'Munch Nuts Nestle 35.2g Crunchy Wafer Bar', '', '', 1, 'product-featured-180.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (181, 'Dairy Milk Silk Bubbly', 'Dairy Milk Silk Bubbly', 'Dairy Milk Silk Bubbly', '', '', 0, 'product-featured-181.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (182, 'Dairy Milk Silk Bubbly', 'Dairy Milk Silk Bubbly', 'Dairy Milk Silk Bubbly', '', '', 0, 'product-featured-182.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (183, '5Star 3D Cadbury 42g', '5Star 3D Cadbury 42g', '5Star 3D Cadbury 42g', '', '', 0, 'product-featured-183.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (184, 'Lollipop 4 Flavours 63g Jolly Rancher', 'Lollipop 4 Flavours 63g Jolly Rancher', 'Lollipop 4 Flavours 63g Jolly Rancher', '', '', 0, 'product-featured-184.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (185, 'Center Fresh Chewing Gum', 'Center Fresh Chewing Gum', 'Center Fresh Chewing Gum', '', '', 0, 'product-featured-185.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (186, 'Kinder Joy Boys 20g', 'Kinder Joy Boys 20g', 'Kinder Joy Boys 20g', '', '', 0, 'product-featured-186.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (187, 'Cadbury Perk 13g', 'Cadbury Perk 13g', 'Cadbury Perk 13g', '', '', 0, 'product-featured-187.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (188, 'Dairy Milk Lickables Cadbury', 'Dairy Milk Lickables Cadbury', 'Dairy Milk Lickables Cadbury', '', '', 0, 'product-featured-188.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (189, 'Center Fruit Chewing Gum 23.6g', 'Center Fruit Chewing Gum 23.6g', 'Center Fruit Chewing Gum 23.6g', '', '', 0, 'product-featured-189.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (190, 'Chupa Chups sour chewy Toffee mixed Fruit Flavours 61.6g', 'Chupa Chups sour chewy Toffee mixed Fruit Flavours 61.6g', 'Chupa Chups sour chewy Toffee mixed Fruit Flavours 61.6g', '', '', 0, 'product-featured-190.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (191, 'HappyDent Chewing Gum Sugarfree 15pcs 16.1g', 'HappyDent Chewing Gum Sugarfree 15pcs 16.1g', 'HappyDent Chewing Gum Sugarfree 15pcs 16.1g', '', '', 0, 'product-featured-191.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (192, 'Munch Crunchiest 20.1g Nestle', 'Munch Crunchiest 20.1g Nestle', 'Munch Crunchiest 20.1g Nestle', '', '', 0, 'product-featured-192.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (193, 'Cadbury Gems 17.8g Ball Surprise Pack', 'Cadbury Gems 17.8g Ball Surprise Pack', 'Cadbury Gems 17.8g Ball Surprise Pack', '', '', 0, 'product-featured-193.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (194, 'Cadbury Celebrations Gift Pack 64.2g', 'Cadbury Celebrations Gift Pack 64.2g', 'Cadbury Celebrations Gift Pack 64.2g', '', '', 0, 'product-featured-194.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (195, 'Cadbury Celebrations Gift Pack 186.6g', 'Cadbury Celebrations Gift Pack 186.6g', 'Cadbury Celebrations Gift Pack 186.6g', '', '', 0, 'product-featured-195.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (196, 'Cadbury Family Pack Dairy Milk', 'Cadbury Family Pack Dairy Milk', 'Cadbury Family Pack Dairy Milk', '', '', 0, 'product-featured-196.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 10, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (197, 'Mango Bite Parle 289g', 'Mango Bite Parle 289g', 'Mango Bite Parle 289g', '', '', 0, 'product-featured-197.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (198, 'Orange Bite Parle 289g', 'Orange Bite Parle 289g', 'Orange Bite Parle 289g', '', '', 0, 'product-featured-198.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (199, 'Crispello Dairy Milk Cadbury 33g', 'Crispello Dairy Milk Cadbury 33g', 'Crispello Dairy Milk Cadbury 33g', '', '', 0, 'product-featured-199.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (200, 'Cadbury Celebrations Gift Box Rich Dry Fruit, 177g', 'Cadbury Celebrations Gift Box Rich Dry Fruit, 177g', 'Cadbury Celebrations Gift Box Rich Dry Fruit, 177g', '', '', 0, 'product-featured-200.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (201, 'Nestle Milkybar Eclairs 340g Pouch', 'Nestle Milkybar Eclairs 340g Pouch', 'Nestle Milkybar Eclairs 340g Pouch', '', '', 0, 'product-featured-201.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (202, 'Kaccha Mango Bite Parle 277g Pouch', 'Kaccha Mango Bite Parle 277g Pouch', 'Kaccha Mango Bite Parle 277g Pouch', '', '', 0, 'product-featured-202.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (203, 'Snickers Peanut filled Chocolate Bar', 'Snickers Peanut filled Chocolate Bar', 'Snickers Peanut filled Chocolate Bar', '', '', 0, 'product-featured-203.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (235, 'Masala Instant Noodles , vegetarian', 'Masala Instant Noodles , vegetarian', 'Masala Instant Noodles , vegetarian', '', '', 0, 'product-featured-691241651.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (236, 'Desi Hakka Noodles Veg', 'Desi Hakka Noodles Veg', 'Desi Hakka Noodles Veg', '', '', 0, 'product-featured-821196293.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (237, 'Yippee Magic Masala Noodles', 'Yippee Magic Masala Noodles', 'Yippee Magic Masala Noodles', '', '', 0, 'product-featured-535073250.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (238, 'Special Masala Noodles ', 'Special Masala Noodles ', 'Special Masala Noodles ', '', '', 0, 'product-featured-185522370.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (239, 'Masala Veg Aata noodles', 'Masala Veg Aata noodles', 'Masala Veg Aata noodles', '', '', 0, 'product-featured-380791413.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (240, 'WAI WAI  Veg Masala Noodles', 'WAI WAI  Veg Masala Noodles', 'WAI WAI  Veg Masala Noodles', '', '', 0, 'product-featured-414213130.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (241, 'Maggi  Noodles', 'Maggi  Noodles', 'Maggi  Noodles', '', '', 0, 'product-featured-558503841.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (243, 'Yippee Mood  Masala Noodles', 'Yippee Mood  Masala Noodles', 'Yippee Mood  Masala Noodles', '', '', 0, 'product-featured-125230660.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (244, 'Cuppa Noodles , Masala', 'Cuppa Noodles , Masala', 'Cuppa Noodles , Masala', '', '', 0, 'product-featured-512899153.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (245, 'Power up Aata noodles', 'Power up Aata noodles', 'Power up Aata noodles', '', '', 0, 'product-featured-733866001.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (246, 'Macaroni', 'Macaroni', 'Macaroni', '', '', 0, 'product-featured-540688463.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (248, 'Masala Oats Noodles', 'Masala Oats Noodles', 'Masala Oats Noodles', '', '', 0, 'product-featured-538381028.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (249, 'Yippee Pasta - Treat Masala', 'Yippee Pasta - Treat Masala', 'Yippee Pasta - Treat Masala', '', '', 0, 'product-featured-440753699.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (250, 'Noodles  - Masala', 'Noodles  - Masala', 'Noodles  - Masala', '', '', 0, 'product-featured-585259123.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (251, 'Yippee Pasta - Treat Tomato Cheese', 'Yippee Pasta - Treat Tomato Cheese', 'Yippee Pasta - Treat Tomato Cheese', '', '', 0, 'product-featured-273130962.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (252, 'Yippee Noodles', 'Yippee Noodles', 'Yippee Noodles', '', '', 0, 'product-featured-191370172.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (267, 'Maggi Hot & Sweet Tomato Chilli Sauce Bottle', 'Maggi Hot & Sweet Tomato Chilli Sauce Bottle', 'Maggi Hot & Sweet Tomato Chilli Sauce Bottle', '', '', 0, 'product-featured-853353455.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 30, 0, 1, 1, 1, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (268, 'Kissan Fresh Tomato Ketchup 950g Pouch', 'Kissan Fresh Tomato Ketchup 950g Pouch', 'Kissan Fresh Tomato Ketchup 950g Pouch', '', '', 0, 'product-featured-64629205.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 21, 0, 1, 0, 1, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (269, 'Dabur Honey ? 1 Kg', 'Dabur Honey ? 1 Kg', 'Dabur Honey ? 1 Kg', '', '', 0, 'product-featured-473612880.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (270, 'Kissan Mixed Fruit Jam', 'Kissan Mixed Fruit Jam', 'Kissan Mixed Fruit Jam', '', '', 0, 'product-featured-358267914.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 13, 0, 1, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (271, 'Patanjali Honey', 'Patanjali Honey', 'Patanjali Honey', '', '', 0, 'product-featured-50420827.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (272, 'Kissan Fresh Tomato Ketchup Bottle', 'Kissan Fresh Tomato Ketchup Bottle', 'Kissan Fresh Tomato Ketchup Bottle', '', '', 0, 'product-featured-526915559.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 1, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (273, 'Kissan Sauce - Pizza & Pasta ', 'Kissan Sauce - Pizza & Pasta ', 'Kissan Sauce - Pizza & Pasta ', '', '', 0, 'product-featured-578831306.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 13, 0, 1, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (274, 'Saffola Gold Edible Oil', 'Saffola Gold Edible Oil', 'Saffola Gold Edible Oil', '', '', 0, 'product-featured-26951886.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (275, 'Aashirwaad Aata - Whole Wheat / आटा', 'Aata - Whole Wheat / आटा', 'Aata - Whole Wheat / आटा', '', '', 0, 'product-featured-214580122.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 22, 0, 1, 0, 1, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (276, 'Lays Potato Chips American Style Cream & Onion', 'Lays Potato Chips American Style Cream & Onion', 'Lays Potato Chips American Style Cream & Onion', '', '', 0, 'product-featured-170092983.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (277, 'Lijjat - Papad Punjabi  Masala Pouch', 'Lijjat - Papad Punjabi  Masala Pouch', 'Lijjat - Papad Punjabi  Masala Pouch', '', '', 0, 'product-featured-246613159.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (278, 'Lays Potato Chips Indias Magic Masala', 'Lays Potato Chips Indias Magic Masala', 'Lays Potato Chips Indias Magic Masala', '', '', 0, 'product-featured-860127780.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (279, 'Haldiram Rasgulla', 'Haldiram Rasgulla', 'Haldiram Rasgulla', '', '', 0, 'product-featured-582394306.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (281, 'Lays Potato Chips Spanish Tomato Tango', 'Lays Potato Chips Spanish Tomato Tango', 'Lays Potato Chips Spanish Tomato Tango', '', '', 0, 'product-featured-535776674.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (282, 'Finger Papad', 'Finger Papad', 'Finger Papad', '', '', 0, 'product-featured-806032199.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (283, 'Haldiram Gulab Jamun', 'Haldiram Gulab Jamun', 'Haldiram Gulab Jamun', '', '', 0, 'product-featured-979859572.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (284, 'Bikaji Dilkhush Papad', 'Bikaji Dilkhush Papad', 'Bikaji Dilkhush Papad', '', '', 0, 'product-featured-137801616.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (285, 'Bikaji Baat Chest Papad', 'Bikaji Baat Chest Papad', 'Bikaji Baat Chest Papad', '', '', 0, 'product-featured-839818558.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (286, 'Bingo Potato Chips Masala', 'Bingo Potato Chips Masala', 'Bingo Potato Chips Masala', '', '', 0, 'product-featured-452212695.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (287, 'Papad Fryms', 'Papad Fryms', 'Papad Fryms', '', '', 0, 'product-featured-26188743.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (288, 'Bingo Potato Chips Chilli Sprinkled Original Style', 'Bingo Potato Chips Chilli Sprinkled Original Style', 'Bingo Potato Chips Chilli Sprinkled Original Style', '', '', 0, 'product-featured-443508239.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (289, 'Bingo Potato Chips Chilli Sprinkled Original Style', 'Bingo Potato Chips Chilli Sprinkled Original Style', 'Bingo Potato Chips Chilli Sprinkled Original Style', '', '', 0, 'product-featured-937963550.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (290, 'Bingo Potato Chips Salt Sprinkled Original Style', 'Bingo Potato Chips Salt Sprinkled Original Style', 'Bingo Potato Chips Salt Sprinkled Original Style', '', '', 0, 'product-featured-510419971.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (291, 'Gulab Jamun Gol m Gol ', 'Gulab Jamun Gol m Gol ', 'Gulab Jamun Gol m Gol ', '', '', 0, 'product-featured-131784467.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (292, 'Bingo Potato Cream & Onion', 'Bingo Potato Cream & Onion', 'Bingo Potato Cream & Onion', '', '', 0, 'product-featured-791345124.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 1, 6, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (293, 'Aashirvaad Multigrain Aata ', 'Aashirvaad Multigrain Aata ', 'Aashirvaad Multigrain Aata ', '', '', 0, 'product-featured-912997882.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (296, 'Maida ', 'Maida ', 'Maida ', '', '', 0, 'product-featured-713373927.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (297, 'India Gate Basmati Rice , Feast Rozana Pouch', 'India Gate Basmati Rice , Feast Rozana Pouch', 'India Gate Basmati Rice , Feast Rozana Pouch', '', '', 0, 'product-featured-519793330.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (298, 'Dawat Basmati Rice , Rozana Gold Pouch', 'Dawat Basmati Rice , Rozana Gold Pouch', 'Dawat Basmati Rice , Rozana Gold Pouch', '', '', 0, 'product-featured-963019375.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (299, 'India Gate Basmati Rice, Dubar Pouch', 'India Gate Basmati Rice, Dubar Pouch', 'India Gate Basmati Rice, Dubar Pouch', '', '', 0, 'product-featured-209101460.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (301, 'India Gate Basmati Rice , Mogra/Broken Bag', 'India Gate Basmati Rice , Mogra/Broken Bag', 'India Gate Basmati Rice , Mogra/Broken Bag', '', '', 0, 'product-featured-834997718.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (302, 'Kohinoor Long Grain Rice', 'Kohinoor Long Grain Rice', 'Kohinoor Long Grain Rice', '', '', 0, 'product-featured-161276816.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (303, 'Dawat Basmati Rice - Pulav', 'Dawat Basmati Rice - Pulav', 'Dawat Basmati Rice - Pulav', '', '', 0, 'product-featured-378225701.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (304, 'Dawat Basmati Biryani Rice', 'Dawat Basmati Biryani Rice', 'Dawat Basmati Biryani Rice', '', '', 0, 'product-featured-866574172.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (306, 'Fortune Sunflower Refined Oil , Pouch', 'Fortune Sunflower Refined Oil , Pouch', 'Fortune Sunflower Refined Oil , Pouch', '', '', 0, 'product-featured-922015399.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (308, 'Fortune  Kachi Ghani Mustard Oil', 'Fortune  Kachi Ghani Mustard Oil', 'Fortune  Kachi Ghani Mustard Oil', '', '', 0, 'product-featured-447233918.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (309, 'Fortune Rice Bran oil Pouch', 'Fortune Rice Bran oil Pouch', 'Fortune Rice Bran oil Pouch', '', '', 0, 'product-featured-879600108.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (311, 'Patanjali Cow Ghee', 'Patanjali Cow Ghee', 'Patanjali Cow Ghee', '', '', 0, 'product-featured-996488890.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (312, 'Fortune Sunflower Refined Oil', 'Fortune Sunflower Refined Oil', 'Fortune Sunflower Refined Oil', '', '', 0, 'product-featured-630538992.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (313, 'Dhara Oil Groundnut , Pouch', 'Dhara Oil Groundnut , Pouch', 'Dhara Oil Groundnut , Pouch', '', '', 0, 'product-featured-925726971.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (314, 'Dhara Kachi Ghani Mustard Oil', 'Dhara Kachi Ghani Mustard Oil', 'Dhara Kachi Ghani Mustard Oil', '', '', 0, 'product-featured-664227024.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 0, 1, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (315, 'Saffola Active - Pro Weight watchers Edible Oil', 'Saffola Active - Pro Weight watchers Edible Oil', 'Saffola Active - Pro Weight watchers Edible Oil', '', '', 0, 'product-featured-524990553.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (316, 'Amul Pure Ghee , Tin', 'Amul Pure Ghee , Tin', 'Amul Pure Ghee , Tin', '', '', 0, 'product-featured-76454032.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 0, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (317, 'Amul Pure Ghee , Cartoon', 'Amul Pure Ghee , Cartoon', 'Amul Pure Ghee , Cartoon', '', '', 0, 'product-featured-614023925.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (319, 'Fortune Refined Oil Rice Bran , can', 'Fortune Refined Oil Rice Bran , can', 'Fortune Refined Oil Rice Bran , can', '', '', 0, 'product-featured-671613389.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (322, 'Engine  Kacchi Ghani Mustard Oil , Bottle', 'Engine  Kacchi Ghani Mustard Oil , Bottle', 'Engine  Kacchi Ghani Mustard Oil , Bottle', '', '', 0, 'product-featured-937491251.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (324, 'Fortune Soyabean Oil , Pouch', 'Fortune Soyabean Oil , Pouch', 'Fortune Soyabean Oil , Pouch', '', '', 0, 'product-featured-431661291.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (325, 'Dhara Refined Oil - Rice Bran ( Natural Oryzonal & Vitamin E )', 'Dhara Refined Oil - Rice Bran ( Natural Oryzonal & Vitamin E )', 'Dhara Refined Oil - Rice Bran ( Natural Oryzonal & Vitamin E )', '', '', 0, 'product-featured-392788956.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 0, 1, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (326, 'Saffola Total - Pro Heart Conscious Edible Oil', 'Saffola Total - Pro Heart Conscious Edible Oil', 'Saffola Total - Pro Heart Conscious Edible Oil', '', '', 0, 'product-featured-696298087.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (327, 'Dhara Mustard Oil ( Kacchi Ghani) ', 'Dhara Mustard Oil ( Kacchi Ghani) ', 'Dhara Mustard Oil ( Kacchi Ghani) ', '', '', 0, 'product-featured-400195279.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (330, 'Saffola Total - Pro Heart Conscious Edible Oil', 'Saffola Total - Pro Heart Conscious Edible Oil', 'Saffola Total - Pro Heart Conscious Edible Oil', '', '', 0, 'product-featured-512378193.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (331, 'Saffola Gold Total pro Heart Conscious Edible Oil', 'Saffola Gold Total pro Heart Conscious Edible Oil', 'Saffola Gold Total pro Heart Conscious Edible Oil', '', '', 0, 'product-featured-306066603.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (332, 'Nutrela Soya - Mini Chunk', 'Nutrela Soya - Mini Chunk', 'Nutrela Soya - Mini Chunk', '', '', 0, 'product-featured-220534204.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (333, 'Nutrela Soya ', 'Nutrela Soya ', 'Nutrela Soya ', '', '', 0, 'product-featured-500903566.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (334, 'Nutrela Soya  Granules, Cartoon', 'Nutrela Soya  Granules, Cartoon', 'Nutrela Soya  Granules, Cartoon', '', '', 0, 'product-featured-748746214.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (335, 'Nutrela Soya Chunks , Pouch', 'Nutrela Soya Chunks , Pouch', 'Nutrela Soya Chunks , Pouch', '', '', 0, 'product-featured-777244046.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (336, 'Nutrela Soya Chunks - Mini', 'Nutrela Soya Chunks - Mini', 'Nutrela Soya Chunks - Mini', '', '', 0, 'product-featured-390024535.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (337, 'Nutrela Soya Chunks 200g Cartoon', 'Nutrela Soya Chunks 200g Cartoon', 'Nutrela Soya Chunks 200g Cartoon', '', '', 0, 'product-featured-173324079.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (338, 'Catch Jeera Powder', 'Catch Jeera Powder', 'Catch Jeera Powder', '', '', 0, 'product-featured-767061388.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (347, 'Beans / बीन्स', 'Beans / बीन्स', 'Beans / बीन्स', '', '', 0, 'product-featured-534849504.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 26, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (349, 'Round Brinjal / Gol Baingan / गोल बैगन', 'Round Brinjal / Gol Baingan / गोल बैगन', 'Round Brinjal / Gol Baingan / गोल बैगन', '', '', 0, 'product-featured-707029653.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 14, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (358, 'Catch Turmaric Powder', 'Catch Turmaric Powder', 'Catch Turmaric Powder', '', '', 0, 'product-featured-381707080.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (360, 'Catch Coriander Powder', 'Catch Coriander Powder', 'Catch Coriander Powder', '', '', 0, 'product-featured-583016191.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (365, 'Catch Hing/Asafoetida Plastic Bottle', 'Catch Hing/Asafoetida Plastic Bottle', 'Catch Hing/Asafoetida Plastic Bottle', '', '', 0, 'product-featured-357796912.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (366, 'Catch Red Chili Powder', 'Catch Red Chili Powder', 'Catch Red Chili Powder', '', '', 0, 'product-featured-73528004.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (367, 'Catch Turmeric Powder', 'Catch Turmeric Powder', 'Catch Turmeric Powder', '', '', 0, 'product-featured-907246695.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (370, ' Catch Super Garam Masala', ' Catch Super Garam Masala', ' Catch Super Garam Masala', '', '', 0, 'product-featured-233744644.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (371, 'Catch Sambhar Masala', 'Catch Sambhar Masala', 'Catch Sambhar Masala', '', '', 0, 'product-featured-487157063.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (373, 'Catch Dry Mango/Aam Chur Powder', 'Catch Dry Mango/Aam Chur Powder', 'Catch Dry Mango/Aam Chur Powder', '', '', 0, 'product-featured-363507567.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (375, 'Catch Coriander Powder', 'Catch Coriander Powder', 'Catch Coriander Powder', '', '', 0, 'product-featured-832501218.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (377, 'Catch Red Chili  Powder , Cartoon', 'Catch Red Chili  Powder , Cartoon', 'Catch Red Chili  Powder , Cartoon', '', '', 0, 'product-featured-176145050.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (379, 'Catch Black Pepper Powder , Carton', 'Catch Black Pepper Powder , Carton', 'Catch Black Pepper Powder , Carton', '', '', 0, 'product-featured-490172115.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (381, 'Catch Garam Masala', 'Catch Garam Masala', 'Catch Garam Masala', '', '', 0, 'product-featured-121045345.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (386, 'Catch Rajma Masala Carton', 'Catch Rajma Masala Carton', 'Catch Rajma Masala Carton', '', '', 0, 'product-featured-147068037.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (387, 'Catch Kitchen King  Masala Carton', 'Catch Kitchen King  Masala Carton', 'Catch Kitchen King  Masala Carton', '', '', 0, 'product-featured-190129312.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (388, 'Catch Sprinklers Chat Masala ,Can', 'Catch Sprinklers Chat Masala ,Can', 'Catch Sprinklers Chat Masala ,Can', '', '', 0, 'product-featured-547513955.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (392, 'Catch Chana Masala Carton', 'Catch Chana Masala Carton', 'Catch Chana Masala Carton', '', '', 0, 'product-featured-510640579.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (394, 'Catch Chicken Masala Carton', 'Catch Chicken Masala Carton', 'Catch Chicken Masala Carton', '', '', 0, 'product-featured-630026354.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (395, 'Catch Sabzi Masala Carton', 'Catch Sabzi Masala Carton', 'Catch Sabzi Masala Carton', '', '', 0, 'product-featured-878566070.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (397, 'Catch Chatpata Chat Masala Carton', 'Catch Chatpata Chat Masala Carton', 'Catch Chatpata Chat Masala Carton', '', '', 0, 'product-featured-664996733.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (399, 'Catch Chole Masala Carton', 'Catch Chole Masala Carton', 'Catch Chole Masala Carton', '', '', 0, 'product-featured-188452266.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (400, 'Catch Meat Masala Carton', 'Catch Meat Masala Carton', 'Catch Meat Masala Carton', '', '', 0, 'product-featured-509761866.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (402, 'Catch Kasuri methi Carton', 'Catch Kasuri methi Carton', 'Catch Kasuri methi Carton', '', '', 0, 'product-featured-28614653.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (403, 'Catch Pav bhaji masala Carton', 'Catch Pav bhaji masala Carton', 'Catch Pav bhaji masala Carton', '', '', 0, 'product-featured-864162144.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (408, 'Catch Sprinklers Black Pepper ,Can', 'Catch Sprinklers Black Pepper ,Can', 'Catch Sprinklers Black Pepper ,Can', '', '', 0, 'product-featured-343239391.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (409, 'Catch Kashmiri Mirch Powder Carton', 'Catch Kashmiri Mirch Powder Carton', 'Catch Kashmiri Mirch Powder Carton', '', '', 0, 'product-featured-644228772.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (410, 'Catch Sprinklers Dahi Masala Can', 'Catch Sprinklers Dahi Masala Can', 'Catch Sprinklers Dahi Masala Can', '', '', 0, 'product-featured-267953288.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (411, 'Catch Raita Masala, Carton', 'Catch Raita Masala, Carton', 'Catch Raita Masala, Carton', '', '', 0, 'product-featured-860946336.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (412, 'Catch Sahi Paneer Masala, Carton', 'Catch Sahi Paneer Masala, Carton', 'Catch Sahi Paneer Masala, Carton', '', '', 0, 'product-featured-387354699.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (413, 'Catch Jeera whole  Pouch', 'Catch Jeera whole  Pouch', 'Catch Jeera whole  Pouch', '', '', 0, 'product-featured-368127485.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (414, 'Catch Jal Jeera ,Carton', 'Catch Jal Jeera ,Carton', 'Catch Jal Jeera ,Carton', '', '', 0, 'product-featured-276194091.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (415, 'Everest Turmeric Powder, Pouch', 'Everest Turmeric Powder, Pouch', 'Everest Turmeric Powder, Pouch', '', '', 0, 'product-featured-854540619.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (416, 'Everest Tikhalal  Chilli powder', 'Everest Tikhalal  Chilli powder', 'Everest Tikhalal  Chilli powder', '', '', 0, 'product-featured-848479071.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (417, 'Everest - Green Coriander Powder , Pouch', 'Everest - Green Coriander Powder , Pouch', 'Everest - Green Coriander Powder , Pouch', '', '', 0, 'product-featured-423410774.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (418, 'Everest Cumin Powder, Carton', 'Everest Cumin Powder, Carton', 'Everest Cumin Powder, Carton', '', '', 0, 'product-featured-811323391.webp', '<p>1New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (419, 'Everest Black Pepper Powder', 'Everest Black Pepper Powder', 'Everest Black Pepper Powder', '', '', 0, 'product-featured-452347428.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (420, 'Everest Hing Asafoetida Powder Yellow', 'Everest Hing Asafoetida Powder Yellow', 'Everest Hing Asafoetida Powder Yellow', '', '', 0, 'product-featured-716701316.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (421, 'Everest Kutilal Red Chili Powder', 'Everest Kutilal Red Chili Powder', 'Everest Kutilal Red Chili Powder', '', '', 0, 'product-featured-42299995.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (422, 'Everest Kashmirilal', 'Everest Kashmirilal', 'Everest Kashmirilal', '', '', 0, 'product-featured-269507425.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (423, 'Everest Dry Mango Powder , Carton', 'Everest Dry Mango Powder , Carton', 'Everest Dry Mango Powder , Carton', '', '', 0, 'product-featured-602347093.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (424, 'Everest Jaljeera  Powder', 'Everest Jaljeera  Powder', 'Everest Jaljeera  Powder', '', '', 0, 'product-featured-887955164.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (425, 'Everest Hingraj Powder', 'Everest Hingraj Powder', 'Everest Hingraj Powder', '', '', 0, 'product-featured-464572599.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (426, 'Everest Turmeric Powder', 'Everest Turmeric Powder', 'Everest Turmeric Powder', '', '', 0, 'product-featured-920477569.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (427, 'Everest White Pepper Powder', 'Everest White Pepper Powder', 'Everest White Pepper Powder', '', '', 0, 'product-featured-152342830.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (428, 'Everest Garam Masala, Carton ,41g', 'Everest Garam Masala, Carton ,41g', 'Everest Garam Masala, Carton ,41g', '', '', 0, 'product-featured-837787004.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (429, 'Everest Chicken Masala', 'Everest Chicken Masala', 'Everest Chicken Masala', '', '', 0, 'product-featured-377001089.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (430, 'Everest Chole Masala', 'Everest Chole Masala', 'Everest Chole Masala', '', '', 0, 'product-featured-962641800.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (431, 'Everest Chat Masala', 'Everest Chat Masala', 'Everest Chat Masala', '', '', 0, 'product-featured-510535479.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (432, 'Everest Pav bhaji masala', 'Everest Pav bhaji masala', 'Everest Pav bhaji masala', '', '', 0, 'product-featured-373715856.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (433, 'Everest Sahi Biryani Masala', 'Everest Sahi Biryani Masala', 'Everest Sahi Biryani Masala', '', '', 0, 'product-featured-456631812.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (434, 'Everest  Kitchen King Masala', 'Everest  Kitchen King Masala', 'Everest  Kitchen King Masala', '', '', 0, 'product-featured-473899145.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (435, 'Everest Sabhi Masala', 'Everest Sabhi Masala', 'Everest Sabhi Masala', '', '', 0, 'product-featured-73624328.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (436, 'Everest Sambhar Masala', 'Everest Sambhar Masala', 'Everest Sambhar Masala', '', '', 0, 'product-featured-562120279.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (437, 'Everest Tea Masala', 'Everest Tea Masala', 'Everest Tea Masala', '', '', 0, 'product-featured-629362257.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 15, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (438, 'Everest Sahi Paneer Masala', 'Everest Sahi Paneer Masala', 'Everest Sahi Paneer Masala', '', '', 0, 'product-featured-453000453.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (439, 'Everest Panipuri Masala', 'Everest Panipuri Masala', 'Everest Panipuri Masala', '', '', 0, 'product-featured-459437987.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (440, 'Everest Meat Masala', 'Everest Meat Masala', 'Everest Meat Masala', '', '', 0, 'product-featured-173543627.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (441, 'Tata Salt Iodized, Pouch', 'Tata Salt Iodized, Pouch', 'Tata Salt Iodized, Pouch', '', '', 0, 'product-featured-786301048.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (442, 'Tata Salt Lite , Pouch', 'Tata Salt Lite , Pouch', 'Tata Salt Lite , Pouch', '', '', 0, 'product-featured-62077843.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (447, 'Sugar free Natura Low Calories Sweetner', 'Sugar free Natura Low Calories Sweetner', 'Sugar free Natura Low Calories Sweetner', '', '', 0, 'product-featured-665712868.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (449, 'Sugar free Gold Low Calorie Sweetner , Pellets', 'Sugar free Gold Low Calorie Sweetner , Pellets', 'Sugar free Gold Low Calorie Sweetner , Pellets', '', '', 0, 'product-featured-978480493.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (450, 'Sugar free Low Calorie Sweetner', 'Sugar free Low Calorie Sweetner', 'Sugar free Low Calorie Sweetner', '', '', 0, 'product-featured-262561704.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (451, 'Sugar free Gold Low Calorie Sweetner 500, Pellets', 'Sugar free Gold Low Calorie Sweetner 500, Pellets', 'Sugar free Gold Low Calorie Sweetner 500, Pellets', '', '', 0, 'product-featured-925592254.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (452, 'Catch Sprinklers Iodised Table Salt', 'Catch Sprinklers Iodised Table Salt', 'Catch Sprinklers Iodised Table Salt', '', '', 0, 'product-featured-494298092.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (453, 'Catch Sprinklers Sendh Namak ,Can', 'Catch Sprinklers Sendh Namak ,Can', 'Catch Sprinklers Sendh Namak ,Can', '', '', 0, 'product-featured-711486933.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (454, 'Tata Salt  Iron Plus Iodine', 'Tata Salt  Iron Plus Iodine', 'Tata Salt  Iron Plus Iodine', '', '', 0, 'product-featured-697851991.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (455, 'Puro Salt - Undefined, 100% Natural', 'Puro Salt - Undefined, 100% Natural', 'Puro Salt - Undefined, 100% Natural', '', '', 0, 'product-featured-243607926.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (458, 'Cabbage / Patta gobhi / पत्ता गोभी ', 'Cabbage / Patta gobhi / पत्ता गोभी ', 'Cabbage / Patta gobhi / पत्ता गोभी ', '', '', 1, 'product-featured-100991119.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (459, 'Capsicum / Shimla Mirch / शिमला मिर्च ', 'Capsicum / Shimla Mirch / शिमला मिर्च ', 'Capsicum / Shimla Mirch / शिमला मिर्च ', '', '', 0, 'product-featured-373006624.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (460, 'Carrot / Gajar / गाजर ', 'Carrot / Gajar / गाजर ', 'Carrot / Gajar / गाजर ', '', '', 0, 'product-featured-264218731.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 14, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (463, 'Coriander / Dhaniya / धनिया ', 'Coriander / Dhaniya / धनिया ', 'Coriander / Dhaniya / धनिया ', '', '', 0, 'product-featured-123411214.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 10, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (466, 'Cucumber / Kheera / खीरा ', 'Cucumber / Kheera / खीरा ', 'Cucumber / Kheera / खीरा ', '', '', 0, 'product-featured-163629480.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (468, 'Garlic / Lehsun / लहसुन ', 'Garlic / Lehsun / लहसुन ', 'Garlic / Lehsun / लहसुन ', '', '', 0, 'product-featured-440713445.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 14, 0, 1, 1, 1, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (469, 'Ginger / Adarak / अदरक ', 'Ginger / Adarak / अदरक ', 'Ginger / Adarak / अदरक ', '', '', 0, 'product-featured-486446772.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (470, 'Green Chili / Hari Mirch / हरी मिर्च ', 'Green Chili / Hari Mirch / हरी मिर्च ', 'Green Chili / Hari Mirch / हरी मिर्च ', '', '', 0, 'product-featured-767219540.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (474, 'Tamarind / Imli / इमली', 'Tamarind / Imli / इमली', 'Tamarind / Imli / इमली', '', '', 0, 'product-featured-203423319.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (477, 'Bitter Gourd / Karela / करैला  ', 'Bitter Gourd / Karela / करैला  ', 'Bitter Gourd / Karela / करैला  ', '', '', 0, 'product-featured-306966209.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (478, 'Kundru / कुंदरू ', 'Kundru / कुंदरू ', 'Kundru / कुंदरू ', '', '', 0, 'product-featured-141123690.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (479, 'Nestle Nan Pro 2 - After 6 month', 'Nestle Nan Pro 2 - After 6 month', 'Nestle Nan Pro 2 - After 6 month', '', '', 0, 'product-featured-750738478.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (480, 'Lady Finger / Bhindi / भिंडी ', 'Lady Finger / Bhindi / भिंडी ', 'Lady Finger / Bhindi / भिंडी ', '', '', 1, 'product-featured-767610474.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (481, 'Nestle Cerelac Baby Cereal With Milk From 12 Months', 'Nestle Cerelac Baby Cereal With Milk From 12 Months', 'Nestle Cerelac Baby Cereal With Milk From 12 Months', '', '', 0, 'product-featured-950514976.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (482, 'Nestle Nan Pro For Follow Up Formula After 18 Month', 'Nestle Nan Pro For Follow Up Formula After 18 Month', 'Nestle Nan Pro For Follow Up Formula After 18 Month', '', '', 0, 'product-featured-738228013.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (483, 'Bottle Gourd / Lauki / लौकी ', 'Bottle Gourd / Lauki / लौकी ', 'Bottle Gourd / Lauki / लौकी ', '', '', 0, 'product-featured-234058897.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (484, 'Nestle Ceregrow Growing Up Multigrain Cereal From 2-5 Year ', 'Nestle Ceregrow Growing Up Multigrain Cereal From 2-5 Year ', 'Nestle Ceregrow Growing Up Multigrain Cereal From 2-5 Year ', '', '', 0, 'product-featured-225029222.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (485, 'Lemon / Nimbu / नींबू ', 'Lemon / Nimbu / नींबू ', 'Lemon / Nimbu / नींबू ', '', '', 0, 'product-featured-166080298.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (486, 'Nestle Nan Pro After 12 Months Stage 3', 'Nestle Nan Pro After 12 Months Stage 3', 'Nestle Nan Pro After 12 Months Stage 3', '', '', 0, 'product-featured-917360176.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (489, 'Sweet Gourd / Nenua / नेनुआ ', 'Sweet Gourd / Nenua / नेनुआ ', 'Sweet Gourd / Nenua / नेनुआ ', '', '', 0, 'product-featured-445728470.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (490, 'Sweet Gourd / Desi Nenua / देसी नेनुआ  ', 'Sweet Gourd / Desi Nenua / देसी नेनुआ  ', 'Sweet Gourd / Desi Nenua / देसी नेनुआ  ', '', '', 0, 'product-featured-181657745.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (491, 'onion / Pyaaz / प्याज ', 'onion / Pyaaz / प्याज ', 'onion / Pyaaz / प्याज ', '', '', 7, 'product-featured-342952034.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 36, 0, 1, 1, 1, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (493, 'Patal  / Parwal / परवल ', 'Patal  / Parwal / परवल ', 'Patal  / Parwal / परवल ', '', '', 0, 'product-featured-132475967.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 16, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (494, 'Forzen / Hari Matar / हरी मटर ', 'Forzen / Hari Matar / हरी मटर ', 'Forzen / Hari Matar / हरी मटर ', '', '', 0, 'product-featured-744554633.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 13, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (495, 'Potato / Aaloo / आलू ', 'Potato / Aaloo / आलू ', 'Potato / Aaloo / आलू ', '', '', 0, 'product-featured-587634301.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 32, 0, 1, 1, 1, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (496, 'Pumpkin / Kaddoo / कद्दू ', 'Pumpkin / Kaddoo / कद्दू ', 'Pumpkin / Kaddoo / कद्दू ', '', '', 0, 'product-featured-485013740.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (497, 'Radish / Muli / मूली ', 'Radish / Muli / मूली ', 'Radish / Muli / मूली ', '', '', 0, 'product-featured-247259370.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 28, 1, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (498, 'red chili pickle / Laal Mirch Aachar / लाल मिर्च अचार', 'red chili pickle / Laal Mirch Aachar / लाल मिर्च अचार', 'red chili pickle / Laal Mirch Aachar / लाल मिर्च अचार', '', '', 0, 'product-featured-355404983.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (499, 'Red Potato / Laal Aaloo / लाल आलू ', 'Red Potato / Laal Aaloo / लाल आलू ', 'Red Potato / Laal Aaloo / लाल आलू ', '', '', 0, 'product-featured-68887167.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (500, 'Round Bottle Gourd / Lauki / लौकी ', 'Round Bottle Gourd / Lauki / लौकी ', 'Round Bottle Gourd / Lauki / लौकी ', '', '', 0, 'product-featured-228442994.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (501, 'Drumstick / Sahjan / सहजन ', 'Drumstick / Sahjan / सहजन ', 'Drumstick / Sahjan / सहजन ', '', '', 0, 'product-featured-30079374.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (503, 'Pointed Gourd / Desila Parwal / देसीला परवल  ', 'Pointed Gourd / Desila Parwal / देसीला परवल  ', 'Pointed Gourd / Desila Parwal / देसीला परवल  ', '', '', 0, 'product-503.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (505, 'Spinach / Palak saag / पालक साग  ', 'Spinach / Palak saag / पालक साग  ', 'Spinach / Palak saag / पालक साग  ', '', '', 0, 'product-featured-646946846.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (508, 'Sweet Potato / Shakarkand / शकरकंद ', 'Sweet Potato / Shakarkand / शकरकंद ', 'Sweet Potato / Shakarkand / शकरकंद ', '', '', 0, 'product-featured-285218977.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (509, 'Tomato / Tamatar / टमाटर ', 'Tomato / Tamatar / टमाटर ', 'Tomato / Tamatar / टमाटर ', '', '', 0, 'product-509.jpg', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 21, 0, 1, 1, 1, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (510, 'Ridged Gourd / Turai / तुरई ', 'Ridged Gourd / Turai / तुरई ', 'Ridged Gourd / Turai / तुरई ', '', '', 0, 'product-featured-790185827.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 6, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (511, 'Turmeric / Haldi / हल्दी ', 'Turmeric / Haldi / हल्दी ', 'Turmeric / Haldi / हल्दी ', '', '', 0, 'product-featured-414051060.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 1, 0, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (512, 'Raw Banana / Kaccha Kela / कच्चा केला', 'Raw Banana / Kaccha Kela / कच्चा केला', 'Raw Banana / Kaccha Kela / कच्चा केला', '', '', 0, 'product-featured-565426831.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 15, 0, 1, 1, 1, 1, 1, 2, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (514, 'Nestle Cerelac Baby Cereal With Milk Multigrain Dal Veg From 12 Months', 'Nestle Cerelac Baby Cereal With Milk Multigrain Dal Veg From 12 Months', 'Nestle Cerelac Baby Cereal With Milk Multigrain Dal Veg From 12 Months', '', '', 0, 'product-featured-492764468.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 1, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (515, 'Amul Spray Infant Milk Food/Substitute', 'Amul Spray Infant Milk Food/Substitute', 'Amul Spray Infant Milk Food/Substitute', '', '', 0, 'product-featured-108833344.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 8, 0, 0, 0, 1, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (516, 'Nestle Cerelac Baby Cereal With Milk Wheat Apple From 6 Months ', 'Nestle Cerelac Baby Cereal With Milk Wheat Apple From 6 Months ', 'Nestle Cerelac Baby Cereal With Milk Wheat Apple From 6 Months ', '', '', 0, 'product-featured-299226321.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (517, 'Nestle Nan Pro 1 Infant Formula Powder Upto 6 Months', 'Nestle Nan Pro 1 Infant Formula Powder Upto 6 Months', 'Nestle Nan Pro 1 Infant Formula Powder Upto 6 Months', '', '', 0, 'product-featured-706092582.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (518, 'Nestle Lactogen 4, After 18 Month  Up to 24 Months', 'Nestle Lactogen 4, After 18 Month  Up to 24 Months', 'Nestle Lactogen 4, After 18 Month  Up to 24 Months', '', '', 0, 'product-featured-755991139.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (519, 'Nestle Nan Excellpro 3', 'Nestle Nan Excellpro 3', 'Nestle Nan Excellpro 3', '', '', 0, 'product-featured-11293929.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (520, 'Himalaya Extra Moisturising Baby Soap', 'Himalaya Extra Moisturising Baby Soap', 'Himalaya Extra Moisturising Baby Soap', '', '', 0, 'product-featured-678579830.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (521, 'Himalaya Gentle Baby Shampoo with Hibiscus & Chickpea', 'Himalaya Gentle Baby Shampoo with Hibiscus & Chickpea', 'Himalaya Gentle Baby Shampoo with Hibiscus & Chickpea', '', '', 0, 'product-featured-533775260.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 2, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (522, 'Johnson\'s Baby Soap', 'Johnson\'s Baby Soap', 'Johnson\'s Baby Soap', '', '', 0, 'product-featured-373805809.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 10, 0, 0, 1, 1, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (523, 'Johnson\'s Baby Blossoms Soap', 'Johnson\'s Baby Blossoms Soap', 'Johnson\'s Baby Blossoms Soap', '', '', 0, 'product-featured-118368248.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 7, 0, 0, 1, 1, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (524, 'Johnson\'s Baby Soap 100 g (Buy 3 Get 1 Free)', 'Johnson\'s Baby Soap 100 g (Buy 3 Get 1 Free)', 'Johnson\'s Baby Soap 100 g (Buy 3 Get 1 Free)', '', '', 2, 'product-featured-539849732.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 17, 0, 0, 1, 1, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (525, 'Nestle  Lactogen 2 Powder  After 6 Months', 'Nestle  Lactogen 2 Powder  After 6 Months', 'Nestle  Lactogen 2 Powder  After 6 Months', '', '', 0, 'product-featured-907308909.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (526, 'Johnson\'s Baby Soap', 'Johnson\'s Baby Soap', 'Johnson\'s Baby Soap', '', '', 2, 'product-featured-455072944.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 15, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (528, 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', '', '', 0, 'product-featured-384163113.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (529, 'Nestle Nan Pro Excellapro 2 Follow Up Formula Powder  After 6 Months', 'Nestle Nan Pro Excellapro 2 Follow Up Formula Powder  After 6 Months', 'Nestle Nan Pro Excellapro 2 Follow Up Formula Powder  After 6 Months', '', '', 0, 'product-featured-789970084.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (530, 'Nestle Lactogen 3  After 12 Months ', 'Nestle Lactogen 3  After 12 Months ', 'Nestle Lactogen 3  After 12 Months ', '', '', 0, 'product-featured-143875809.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (531, 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', '', '', 0, 'product-featured-125635264.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 4, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (532, 'Johnson\'s Baby Top-To-Toe Bath', 'Johnson\'s Baby Top-To-Toe Bath', 'Johnson\'s Baby Top-To-Toe Bath', '', '', 0, 'product-featured-707596482.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 5, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (536, 'Nestle Nan Excellapro 1 Infant Formula Powder upto 6 Months ', 'Nestle Nan Excellapro 1 Infant Formula Powder upto 6 Months ', 'Nestle Nan Excellapro 1 Infant Formula Powder upto 6 Months ', '', '', 0, 'product-featured-503678404.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 0, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (543, 'Nestle Lactogen 1 Infant Formula Powder upto 6 Months', 'Nestle Lactogen 1 Infant Formula Powder upto 6 Months', 'Nestle Lactogen 1 Infant Formula Powder upto 6 Months', '', '', 0, 'product-featured-220956209.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 0, 0, 0, 0, 0, 1, 6, 49, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (544, 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', 'Johnson\'s Baby Shampoo No More Tears ', '', '', 0, 'product-featured-472300756.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 1, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (551, 'Himalaya Baby Powder', 'Himalaya Baby Powder', 'Himalaya Baby Powder', '', '', 1, 'product-featured-224514831.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 3, 0, 0, 1, 0, 1, 6, 50, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (626, 'Makhan Bhog Atta Chakki Fresh', 'Makhan Bhog Atta Chakki Fresh', 'Makhan Bhog Atta Chakki Fresh', '', '', 0, 'product-featured-698249706.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 11, 0, 1, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (627, 'Ruchi Bhog Premium Basmati Rice', 'Ruchi Bhog Premium Basmati Rice', 'Ruchi Bhog Premium Basmati Rice', '', '', 0, 'product-featured-971629306.webp', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', '<p>New Product</p>', 9, 0, 1, 1, 0, 1, 1, 4, 'freshmart@decent.com', 2, 0);
INSERT INTO `tbl_product` (`p_id`, `p_name`, `tags`, `p_keyword`, `p_old_price`, `p_current_price`, `p_qty`, `p_featured_photo`, `p_description`, `p_short_description`, `p_feature`, `p_condition`, `p_return_policy`, `p_total_view`, `p_is_featured`, `p_is_active`, `p_is_active_home`, `todays_best_deal`, `tcat_id`, `mcat_id`, `ecat_id`, `user`, `p_type`, `sett`) VALUES (628, 'LIVON Serum for all hair types', 'LIVON Serum for all hair types', 'LIVON Serum for all hair types', '', '', 0, 'product-featured-38